/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.fileTypes;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import java.net.URI;
import java.net.URISyntaxException;
import org.intellij.images.ImagesBundle;
import org.intellij.images.index.ImageInfoIndex;
import org.intellij.images.util.ImageInfo;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class ImageDocumentationProvider
extends AbstractDocumentationProvider {
    private static final int MAX_IMAGE_SIZE = 300;

    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof PsiFileSystemItem && !((PsiFileSystemItem)element).isDirectory()) {
            ImageInfo imageInfo;
            VirtualFile file = ((PsiFileSystemItem)element).getVirtualFile();
            if (!DumbService.isDumb((Project)element.getProject()) && (imageInfo = ImageInfoIndex.getInfo(file, element.getProject())) != null) {
                int imageWidth = imageInfo.width;
                int imageHeight = imageInfo.height;
                int maxSize = Math.max(imageInfo.width, imageInfo.height);
                if (maxSize > 300) {
                    double scaleFactor = 300.0 / (double)maxSize;
                    imageWidth = (int)((double)imageWidth * scaleFactor);
                    imageHeight = (int)((double)imageHeight * scaleFactor);
                }
                try {
                    Object path = file.getPath();
                    if (SystemInfo.isWindows) {
                        path = "/" + (String)path;
                    }
                    String url = new URI("file", null, (String)path, null).toString();
                    HtmlChunk.Element img = HtmlChunk.tag((String)"img").attr("src", url).attr("width", imageWidth).attr("height", imageHeight);
                    String message = ImagesBundle.message("image.description", imageInfo.width, imageInfo.height, imageInfo.bpp);
                    return new HtmlBuilder().append((HtmlChunk)img).append((HtmlChunk)HtmlChunk.p().addText(message)).toString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

