/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.jdk;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.download.SharedIndexId;
import com.intellij.indexing.shared.java.jdk.JdkIndexLookupRequest;
import com.intellij.indexing.shared.java.jdk.SharedJdkChunkStore;
import com.intellij.indexing.shared.java.jdk.SharedJdkIndexChunkLocatorKt;
import com.intellij.indexing.shared.java.jdk.SharedJdkIndexSuggestion;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000-\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000*\u0001\u0006\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001d\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u001c\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0002\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\n*\u00020\u0005H\u0002\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\n*\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"isEnabled", "", "newSuggestion", "Lcom/intellij/indexing/shared/java/jdk/SharedJdkIndexSuggestion;", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "com/intellij/indexing/shared/java/jdk/SharedJdkIndexChunkLocatorKt$newSuggestion$1", "jdkName", "", "id", "Lcom/intellij/indexing/shared/download/SharedIndexId;", "(Ljava/lang/String;Lcom/intellij/indexing/shared/download/SharedIndexId;)Lcom/intellij/indexing/shared/java/jdk/SharedJdkIndexChunkLocatorKt$newSuggestion$1;", "toSharedIndexId", "homePath", "versionString", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "intellij.indexing.shared.java"})
public final class SharedJdkIndexChunkLocatorKt {
    private static final boolean isEnabled() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        return !application.isUnitTestMode() && Registry.is((String)"shared.indexes.download") && Registry.is((String)"shared.indexes.jdk.download");
    }

    private static final SharedJdkIndexSuggestion newSuggestion(Sdk jdk) {
        String string = jdk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jdk.name");
        String jdkName = string;
        SharedIndexId sharedIndexId = SharedJdkIndexChunkLocatorKt.toSharedIndexId(jdk);
        if (sharedIndexId == null) {
            return null;
        }
        SharedIndexId id = sharedIndexId;
        return SharedJdkIndexChunkLocatorKt.newSuggestion(jdkName, id);
    }

    private static final newSuggestion.1 newSuggestion(String jdkName, SharedIndexId id) {
        return new SharedJdkIndexSuggestion(jdkName, id){
            @NotNull
            private final String sdkName;
            @NotNull
            private final SharedIndexId sharedIndexId;
            final /* synthetic */ String $jdkName;
            final /* synthetic */ SharedIndexId $id;

            @NotNull
            public String getSdkName() {
                return this.sdkName;
            }

            @NotNull
            public SharedIndexId getSharedIndexId() {
                return this.sharedIndexId;
            }

            @Nullable
            public JdkIndexLookupRequest resolveRequest(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Sdk sdk = ProjectJdkTable.getInstance().findJdk(this.$jdkName);
                if (sdk == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"ProjectJdkTable.getInsta\u2026k(jdkName) ?: return null");
                Sdk jdk = sdk;
                boolean $i$f$service = false;
                Class<SharedJdkChunkStore> serviceClass$iv = SharedJdkChunkStore.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                return ((SharedJdkChunkStore)((Object)object)).getOrComputeJdkRequest(jdk);
            }

            @NotNull
            public String toString() {
                return "JdkSharedIndexSuggestion(" + this.$id + ", lazy)";
            }
            {
                this.$jdkName = $captured_local_variable$0;
                this.$id = $captured_local_variable$1;
                this.sdkName = $captured_local_variable$0;
                this.sharedIndexId = $captured_local_variable$1;
            }

            @NotNull
            public String getSharedIndexDownloadedPresentableText() {
                return SharedJdkIndexSuggestion.DefaultImpls.getSharedIndexDownloadedPresentableText(this);
            }

            @NotNull
            public String getSharedIndexConsentNotificationKindPresentableText() {
                return SharedJdkIndexSuggestion.DefaultImpls.getSharedIndexConsentNotificationKindPresentableText(this);
            }
        };
    }

    private static final SharedIndexId toSharedIndexId(JdkInstallRequest $this$toSharedIndexId) {
        Object object;
        Object object2 = $this$toSharedIndexId;
        try {
            JdkInstallRequest $this$runCatching = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)SharedJdkIndexChunkLocatorKt.toSharedIndexId(((Object)$this$runCatching.getInstallDir()).toString(), $this$runCatching.getItem().getVersionString()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (SharedIndexId)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    private static final SharedIndexId toSharedIndexId(Sdk $this$toSharedIndexId) {
        Object object;
        Object object2 = $this$toSharedIndexId;
        try {
            Object object3;
            Sdk $this$runCatching = object2;
            boolean bl = false;
            Object object4 = $this$runCatching;
            String string = $this$runCatching.getHomePath();
            try {
                Sdk $this$runCatching2 = object4;
                boolean bl2 = false;
                object3 = Result.constructor-impl((Object)$this$runCatching2.getVersionString());
            }
            catch (Throwable throwable) {
                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object5 = object3;
            object4 = object5;
            object = Result.constructor-impl((Object)SharedJdkIndexChunkLocatorKt.toSharedIndexId(string, (String)(Result.isFailure-impl((Object)object4) ? null : object4)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (SharedIndexId)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    private static final SharedIndexId toSharedIndexId(String homePath, String versionString) {
        String string;
        block5: {
            block4: {
                String string2;
                string = homePath;
                if (string == null) break block4;
                String it = string2 = string;
                boolean bl = false;
                string = FileUtil.toSystemIndependentName((String)it);
                if (string != null) break block5;
            }
            string = "no home path";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(homePath?.let { FileUti\u2026(it) } ?: \"no home path\")");
        String string3 = UtilKt.sha256(string);
        String string4 = versionString;
        if (string4 == null) {
            string4 = "no version";
        }
        String indexId2 = string3 + "#" + string4;
        return new SharedIndexId("jdk", JdkIndexLookupRequest.Companion.getBaseJdkUrl(), indexId2);
    }

    public static final /* synthetic */ SharedIndexId access$toSharedIndexId(JdkInstallRequest $this$access_u24toSharedIndexId) {
        return SharedJdkIndexChunkLocatorKt.toSharedIndexId($this$access_u24toSharedIndexId);
    }

    public static final /* synthetic */ boolean access$isEnabled() {
        return SharedJdkIndexChunkLocatorKt.isEnabled();
    }

    public static final /* synthetic */ SharedJdkIndexSuggestion access$newSuggestion(Sdk jdk) {
        return SharedJdkIndexChunkLocatorKt.newSuggestion(jdk);
    }
}

