/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.MonthDay;

public class MonthDayDeserializer
extends JodaDateDeserializerBase<MonthDay> {
    private static final long serialVersionUID = 1L;

    public MonthDayDeserializer() {
        this(FormatConfig.DEFAULT_MONTH_DAY_FORMAT);
    }

    public MonthDayDeserializer(JacksonJodaDateFormat format2) {
        super(MonthDay.class, format2);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format2) {
        return new MonthDayDeserializer(format2);
    }

    public MonthDay deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p2, ctxt, p2.getText());
        }
        if (p2.isExpectedStartObjectToken()) {
            return this._fromString(p2, ctxt, ctxt.extractScalarFromObject(p2, (JsonDeserializer)this, this.handledType()));
        }
        return (MonthDay)ctxt.handleUnexpectedToken(this.handledType(), p2.currentToken(), p2, "expected JSON String", new Object[0]);
    }

    protected MonthDay _fromString(JsonParser p2, DeserializationContext ctxt, String value2) throws IOException {
        if ((value2 = value2.trim()).isEmpty()) {
            return (MonthDay)this._fromEmptyString(p2, ctxt, value2);
        }
        return MonthDay.parse(value2, this._format.createParser(ctxt));
    }
}

