/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;

public class MonthDaySerializer
extends JSR310FormattedSerializerBase<MonthDay> {
    private static final long serialVersionUID = 1L;
    public static final MonthDaySerializer INSTANCE = new MonthDaySerializer();

    protected MonthDaySerializer() {
        this((DateTimeFormatter)null);
    }

    public MonthDaySerializer(DateTimeFormatter formatter2) {
        super(MonthDay.class, formatter2);
    }

    private MonthDaySerializer(MonthDaySerializer base, Boolean useTimestamp, DateTimeFormatter formatter2) {
        super(base, useTimestamp, formatter2, null);
    }

    protected MonthDaySerializer withFormat(Boolean useTimestamp, DateTimeFormatter formatter2, JsonFormat.Shape shape) {
        return new MonthDaySerializer(this, useTimestamp, formatter2);
    }

    public void serialize(MonthDay value2, JsonGenerator g, SerializerProvider provider2) throws IOException {
        if (this._useTimestampExplicitOnly(provider2)) {
            g.writeStartArray();
            this._serializeAsArrayContents(value2, g, provider2);
            g.writeEndArray();
        } else {
            g.writeString(this._formatter == null ? value2.toString() : value2.format(this._formatter));
        }
    }

    @Override
    public void serializeWithType(MonthDay value2, JsonGenerator g, SerializerProvider provider2, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value2, this.serializationShape(provider2)));
        if (typeIdDef.valueShape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(value2, g, provider2);
        } else {
            g.writeString(this._formatter == null ? value2.toString() : value2.format(this._formatter));
        }
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    protected void _serializeAsArrayContents(MonthDay value2, JsonGenerator g, SerializerProvider provider2) throws IOException {
        g.writeNumber(value2.getMonthValue());
        g.writeNumber(value2.getDayOfMonth());
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider provider2) {
        return this._useTimestampExplicitOnly(provider2) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }
}

