/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.chat.ui;

import circlet.client.api.TD_MemberProfile;
import circlet.platform.client.RefResolveKt;
import circlet.principals.PrincipalExtKt;
import com.intellij.collaboration.ui.codereview.timeline.TimelineItemComponentFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.space.SpaceIcons;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.ui.UtilitiesKt;
import com.intellij.space.ui.panel.SpaceComponentWrapper;
import com.intellij.space.vcs.chat.model.api.SpaceChatItem;
import com.intellij.space.vcs.chat.model.api.SpaceChatItemType;
import com.intellij.space.vcs.chat.model.api.SpaceChatStartThreadVm;
import com.intellij.space.vcs.chat.ui.HoverableJPanel;
import com.intellij.space.vcs.chat.ui.SpaceChatAvatarType;
import com.intellij.space.vcs.chat.ui.SpaceChatContentPanelKt;
import com.intellij.space.vcs.chat.ui.SpaceChatInputProvider;
import com.intellij.space.vcs.chat.ui.SpaceChatItemComponentFactory;
import com.intellij.space.vcs.chat.ui.SpaceChatItemComponentFactory$WhenMappings;
import com.intellij.space.vcs.chat.ui.SpaceChatMarkdownTextComponent;
import com.intellij.space.vcs.chat.ui.SpaceChatNewThreadInputContext;
import com.intellij.space.vcs.chat.ui.SpaceChatSimpleCommentComponentFactory;
import com.intellij.space.vcs.chat.ui.SpaceChatThreadUiDetails;
import com.intellij.space.vcs.chat.ui.SpaceChatUiDetails;
import com.intellij.space.vcs.chat.ui.discussion.SpaceChatCodeDiscussionComponentFactory;
import com.intellij.space.vcs.chat.ui.emojis.SpaceChatItemReactionsComponentFactory;
import com.intellij.space.vcs.chat.ui.message.MessageTitleComponent;
import com.intellij.space.vcs.chat.ui.message.SpaceChatMessagePendingHeader;
import com.intellij.space.vcs.chat.ui.message.SpaceMCMessageComponent;
import com.intellij.space.vcs.chat.ui.message.SpaceStyledMessageComponent;
import com.intellij.space.vcs.chat.ui.thread.SpaceChatCollapsedThreadComponentKt;
import com.intellij.space.vcs.ui.icons.SpaceAvatarProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.CollaborationToolsIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.PropertyKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0014\u0010\u001c\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0002H\u0002J\u0014\u0010\u001e\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0002H\u0002J\u0014\u0010\u001f\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0002H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/space/vcs/chat/ui/SpaceChatItemComponentFactory;", "Lcom/intellij/collaboration/ui/codereview/timeline/TimelineItemComponentFactory;", "Lcom/intellij/space/vcs/chat/model/api/SpaceChatItem;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "server", "", "avatarType", "Lcom/intellij/space/vcs/chat/ui/SpaceChatAvatarType;", "uiDetails", "Lcom/intellij/space/vcs/chat/ui/SpaceChatUiDetails;", "(Lcom/intellij/openapi/project/Project;Llibraries/coroutines/extra/Lifetime;Ljava/lang/String;Lcom/intellij/space/vcs/chat/ui/SpaceChatAvatarType;Lcom/intellij/space/vcs/chat/ui/SpaceChatUiDetails;)V", "codeDiscussionComponentFactory", "Lcom/intellij/space/vcs/chat/ui/discussion/SpaceChatCodeDiscussionComponentFactory;", "createAvatarIcon", "Ljavax/swing/Icon;", "item", "createComponent", "Lcom/intellij/space/vcs/chat/ui/HoverableJPanel;", "createTitleComponent", "Lcom/intellij/space/vcs/chat/ui/message/MessageTitleComponent;", "createUnsupportedMessageTypePanel", "Ljavax/swing/JComponent;", "messageLink", "resizeIcon", "icon", "addReactionsComponentIfNeeded", "message", "addStartThreadField", "addThreadComponentIfNeeded", "Item", "intellij.space.vcs"})
public final class SpaceChatItemComponentFactory
implements TimelineItemComponentFactory<SpaceChatItem> {
    private final SpaceChatCodeDiscussionComponentFactory codeDiscussionComponentFactory;
    private final Project project;
    private final Lifetime lifetime;
    private final String server;
    private final SpaceChatAvatarType avatarType;
    private final SpaceChatUiDetails uiDetails;

    @NotNull
    public HoverableJPanel createComponent(@NotNull SpaceChatItem item2) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        SpaceChatItemType type = item2.getType();
        if (type instanceof SpaceChatItemType.CodeDiscussion) {
            jComponent = this.codeDiscussionComponentFactory.createComponent(item2, ((SpaceChatItemType.CodeDiscussion)type).getDiscussion());
            if (jComponent == null) {
                jComponent = this.createUnsupportedMessageTypePanel(item2.getLink());
            }
        } else if (type instanceof SpaceChatItemType.SimpleText) {
            jComponent = SpaceChatSimpleCommentComponentFactory.INSTANCE.create(this.project, this.lifetime, this.server, this.uiDetails.getInputProvider(), item2);
        } else if (type instanceof SpaceChatItemType.ReviewCompletionStateChanged) {
            jComponent = (JComponent)((Object)new SpaceStyledMessageComponent((JComponent)((Object)new SpaceChatMarkdownTextComponent(this.project, this.server, item2.getText(), item2.isEdited(), null, 16, null)), null, 2, null));
        } else if (type instanceof SpaceChatItemType.ReviewerChanged) {
            String string2;
            HtmlChunk user = SpaceChatContentPanelKt.link(RefResolveKt.resolve(((SpaceChatItemType.ReviewerChanged)type).getUid()));
            switch (SpaceChatItemComponentFactory$WhenMappings.$EnumSwitchMapping$0[((SpaceChatItemType.ReviewerChanged)type).getChangeType().ordinal()]) {
                case 1: {
                    string2 = SpaceBundle.message("chat.reviewer.added", user);
                    break;
                }
                case 2: {
                    string2 = SpaceBundle.message("chat.reviewer.removed", user);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (type.changeType) {\u2026moved\", user)\n          }");
            String text2 = string2;
            jComponent = (JComponent)((Object)new SpaceStyledMessageComponent((JComponent)((Object)new SpaceChatMarkdownTextComponent(this.project, this.server, text2, false, null, 24, null)), null, 2, null));
        } else if (type instanceof SpaceChatItemType.MergeRequestMerged) {
            jComponent = (JComponent)((Object)new SpaceStyledMessageComponent((JComponent)((Object)new SpaceChatMarkdownTextComponent(this.project, this.server, HtmlChunk.raw((String)SpaceBundle.message("chat.review.merged", HtmlChunk.text((String)((SpaceChatItemType.MergeRequestMerged)type).getSourceBranch()).bold(), HtmlChunk.text((String)((SpaceChatItemType.MergeRequestMerged)type).getTargetBranch()).bold())).wrapWith(HtmlChunk.html()).toString(), false, null, 24, null)), null, 2, null));
        } else if (type instanceof SpaceChatItemType.MergeRequestBranchDeleted) {
            jComponent = (JComponent)((Object)new SpaceStyledMessageComponent((JComponent)((Object)new SpaceChatMarkdownTextComponent(this.project, this.server, HtmlChunk.raw((String)SpaceBundle.message("chat.review.deleted.branch", HtmlChunk.text((String)((SpaceChatItemType.MergeRequestBranchDeleted)type).getBranch()).bold())).wrapWith(HtmlChunk.html()).toString(), false, null, 24, null)), null, 2, null));
        } else if (type instanceof SpaceChatItemType.ReviewTitleChanged) {
            jComponent = (JComponent)((Object)new SpaceStyledMessageComponent((JComponent)((Object)new SpaceChatMarkdownTextComponent(this.project, this.server, HtmlChunk.raw((String)SpaceBundle.message("chat.review.title.changed", HtmlChunk.text((String)((SpaceChatItemType.ReviewTitleChanged)type).getOldTitle()).bold(), HtmlChunk.text((String)((SpaceChatItemType.ReviewTitleChanged)type).getNewTitle()).bold())).wrapWith(HtmlChunk.html()).toString(), false, null, 24, null)), null, 2, null));
        } else if (type instanceof SpaceChatItemType.MCMessage) {
            jComponent = (JComponent)((Object)new SpaceMCMessageComponent(this.project, this.server, ((SpaceChatItemType.MCMessage)type).getContent(), item2.getAttachments()));
        } else if (type instanceof SpaceChatItemType.Deleted) {
            String string3 = SpaceBundle.message("chat.message.removed.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"SpaceBundle.message(\"chat.message.removed.text\")");
            jComponent = (JComponent)((Object)new SpaceChatMarkdownTextComponent(this.project, this.server, SpaceChatContentPanelKt.getGrayTextHtml(string3), false, null, 24, null));
        } else if (type instanceof SpaceChatItemType.Unknown) {
            jComponent = this.createUnsupportedMessageTypePanel(item2.getLink());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JComponent component2 = jComponent;
        SpaceChatItemType spaceChatItemType = item2.getType();
        Integer width = spaceChatItemType instanceof SpaceChatItemType.CodeDiscussion ? null : Integer.valueOf(Item.Companion.getDEFAULT_CHAT_MESSAGE_WIDTH());
        return new Item(this.createAvatarIcon(item2), this.createTitleComponent(item2), new SpaceChatMessagePendingHeader(item2), this.addStartThreadField(this.addThreadComponentIfNeeded(this.addReactionsComponentIfNeeded(component2, item2), item2), item2), width);
    }

    private final MessageTitleComponent createTitleComponent(SpaceChatItem item2) {
        if (Intrinsics.areEqual((Object)item2.getType(), (Object)SpaceChatItemType.Deleted.INSTANCE)) {
            return null;
        }
        return new MessageTitleComponent(this.project, this.lifetime, item2);
    }

    private final Icon createAvatarIcon(SpaceChatItem item2) {
        TD_MemberProfile user = PrincipalExtKt.getAsUser(item2.getAuthor());
        if (user != null) {
            return SpaceAvatarProvider.Companion.getInstance().getIcon(user, this.avatarType.getSize());
        }
        if (Intrinsics.areEqual((Object)item2.getType(), (Object)SpaceChatItemType.Deleted.INSTANCE)) {
            Icon icon2 = CollaborationToolsIcons.Delete;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"CollaborationToolsIcons.Delete");
            return this.resizeIcon(icon2);
        }
        Icon icon3 = SpaceIcons.Main;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"SpaceIcons.Main");
        return this.resizeIcon(icon3);
    }

    private final Icon resizeIcon(Icon icon2) {
        return UtilitiesKt.resizeIcon(icon2, this.avatarType.getSize());
    }

    private final JComponent createUnsupportedMessageTypePanel(String messageLink) {
        String string2 = messageLink != null ? SpaceBundle.message("chat.unsupported.message.type.with.link", messageLink) : SpaceBundle.message("chat.unsupported.message.type", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (messageLink != null)\u2026rted.message.type\")\n    }");
        String description2 = string2;
        JBLabel jBLabel = new JBLabel(description2, AllIcons.General.Warning, 2).setCopyable(true);
        Intrinsics.checkNotNullExpressionValue((Object)jBLabel, (String)"JBLabel(description, All\u2026s.LEFT).setCopyable(true)");
        return (JComponent)jBLabel;
    }

    private final JComponent addReactionsComponentIfNeeded(JComponent $this$addReactionsComponentIfNeeded, SpaceChatItem message2) {
        JComponent jComponent;
        if (message2.getType() instanceof SpaceChatItemType.CodeDiscussion || message2.getType() instanceof SpaceChatItemType.SimpleText) {
            jComponent = $this$addReactionsComponentIfNeeded;
        } else {
            NonOpaquePanel nonOpaquePanel;
            JComponent reactionsComponent = SpaceChatItemReactionsComponentFactory.INSTANCE.create(this.lifetime, message2.getItemReactions());
            NonOpaquePanel $this$apply = nonOpaquePanel = UtilitiesKt.verticalPanel$default(2, 0, 2, null);
            boolean bl = false;
            $this$apply.add((Component)$this$addReactionsComponentIfNeeded);
            $this$apply.add((Component)reactionsComponent);
            jComponent = (JComponent)nonOpaquePanel;
        }
        return jComponent;
    }

    private final JComponent addThreadComponentIfNeeded(JComponent $this$addThreadComponentIfNeeded, SpaceChatItem message2) {
        JComponent jComponent;
        if (message2.getType() instanceof SpaceChatItemType.CodeDiscussion) {
            jComponent = $this$addThreadComponentIfNeeded;
        } else {
            NonOpaquePanel nonOpaquePanel;
            SpaceChatThreadUiDetails threadUiDeprecated = new SpaceChatThreadUiDetails(this.uiDetails.getInputProvider());
            JComponent threadComponent = SpaceChatCollapsedThreadComponentKt.createCollapsedThreadComponent(this.project, this.lifetime, this.server, message2, null, threadUiDeprecated);
            NonOpaquePanel $this$apply = nonOpaquePanel = UtilitiesKt.verticalPanel$default(8, 0, 2, null);
            boolean bl = false;
            $this$apply.add((Component)$this$addThreadComponentIfNeeded);
            $this$apply.add((Component)threadComponent);
            jComponent = (JComponent)nonOpaquePanel;
        }
        return jComponent;
    }

    private final JComponent addStartThreadField(JComponent $this$addStartThreadField, SpaceChatItem message2) {
        NonOpaquePanel nonOpaquePanel;
        SpaceChatStartThreadVm startThreadVm = message2.getStartThreadVm();
        SpaceComponentWrapper firstThreadMessageField = new SpaceComponentWrapper(null, "First Thread Message Field", 1, null);
        startThreadVm.isWritingFirstMessage().forEach(this.lifetime, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this, message2, startThreadVm, firstThreadMessageField){
            final /* synthetic */ SpaceChatItemComponentFactory this$0;
            final /* synthetic */ SpaceChatItem $message;
            final /* synthetic */ SpaceChatStartThreadVm $startThreadVm;
            final /* synthetic */ SpaceComponentWrapper $firstThreadMessageField;

            public final void invoke(boolean it) {
                if (it) {
                    Boolean bl = this.$message.getPending();
                    JComponent inputComponent2 = SpaceChatInputProvider.DefaultImpls.createInputComponent$default(SpaceChatItemComponentFactory.access$getUiDetails$p(this.this$0).getInputProvider(), SpaceChatItemComponentFactory.access$getLifetime$p(this.this$0), new SpaceChatNewThreadInputContext(this.$message.getChat(), this.$startThreadVm, PropertyKt.property(bl != null ? bl : false), null, 8, null), (Function0)new Function0<Unit>(this){
                        final /* synthetic */ addStartThreadField.1 this$0;

                        public final void invoke() {
                            this.this$0.$startThreadVm.stopWritingFirstMessage();
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, null, 8, null);
                    this.$firstThreadMessageField.setContent(inputComponent2);
                    IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)inputComponent2);
                    Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.findInst\u2026Component(inputComponent)");
                    IdeFocusManager focusManager = ideFocusManager;
                    JComponent toFocus = focusManager.getFocusTargetFor(inputComponent2);
                    if (toFocus != null) {
                        focusManager.doWhenFocusSettlesDown(new Runnable(focusManager, toFocus){
                            final /* synthetic */ IdeFocusManager $focusManager;
                            final /* synthetic */ JComponent $toFocus;

                            public final void run() {
                                this.$focusManager.requestFocus((Component)this.$toFocus, true);
                            }
                            {
                                this.$focusManager = ideFocusManager;
                                this.$toFocus = jComponent;
                            }
                        });
                    }
                } else {
                    this.$firstThreadMessageField.setContent(null);
                }
            }
            {
                this.this$0 = spaceChatItemComponentFactory;
                this.$message = spaceChatItem;
                this.$startThreadVm = spaceChatStartThreadVm;
                this.$firstThreadMessageField = spaceComponentWrapper;
                super(1);
            }
        }));
        NonOpaquePanel $this$apply = nonOpaquePanel = UtilitiesKt.verticalPanel$default(10, 0, 2, null);
        boolean bl = false;
        $this$apply.add((Component)$this$addStartThreadField);
        $this$apply.add((Component)((Object)firstThreadMessageField));
        return (JComponent)nonOpaquePanel;
    }

    public SpaceChatItemComponentFactory(@NotNull Project project2, @NotNull Lifetime lifetime, @NotNull String server2, @NotNull SpaceChatAvatarType avatarType, @NotNull SpaceChatUiDetails uiDetails) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)server2, (String)"server");
        Intrinsics.checkNotNullParameter((Object)((Object)avatarType), (String)"avatarType");
        Intrinsics.checkNotNullParameter((Object)uiDetails, (String)"uiDetails");
        this.project = project2;
        this.lifetime = lifetime;
        this.server = server2;
        this.avatarType = avatarType;
        this.uiDetails = uiDetails;
        this.codeDiscussionComponentFactory = new SpaceChatCodeDiscussionComponentFactory(this.project, this.lifetime, this.server, this.uiDetails);
    }

    public static final /* synthetic */ SpaceChatUiDetails access$getUiDetails$p(SpaceChatItemComponentFactory $this) {
        return $this.uiDetails;
    }

    public static final /* synthetic */ Lifetime access$getLifetime$p(SpaceChatItemComponentFactory $this) {
        return $this.lifetime;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/space/vcs/chat/ui/SpaceChatItemComponentFactory$Item;", "Lcom/intellij/space/vcs/chat/ui/HoverableJPanel;", "avatar", "Ljavax/swing/Icon;", "title", "Lcom/intellij/space/vcs/chat/ui/message/MessageTitleComponent;", "header", "Ljavax/swing/JComponent;", "content", "width", "", "(Ljavax/swing/Icon;Lcom/intellij/space/vcs/chat/ui/message/MessageTitleComponent;Ljavax/swing/JComponent;Ljavax/swing/JComponent;Ljava/lang/Integer;)V", "hoverStateChanged", "", "isHovered", "", "userAvatar", "Ljavax/swing/JLabel;", "Companion", "intellij.space.vcs"})
    public static final class Item
    extends HoverableJPanel {
        private final MessageTitleComponent title;
        public static final int AVATAR_GAP = 8;
        @NotNull
        public static final Companion Companion = new Companion(null);

        private final JLabel userAvatar(Icon avatar) {
            return new JLabel(avatar);
        }

        @Override
        public void hoverStateChanged(boolean isHovered) {
            if (this.title == null) {
                return;
            }
            this.title.getActionsPanel().setVisible(isHovered);
            this.title.revalidate();
            this.title.repaint();
        }

        public Item(@NotNull Icon avatar, @Nullable MessageTitleComponent title2, @NotNull JComponent header3, @NotNull JComponent content2, @Nullable Integer width) {
            AC aC;
            MessageTitleComponent it;
            BorderLayoutPanel borderLayoutPanel;
            Intrinsics.checkNotNullParameter((Object)avatar, (String)"avatar");
            Intrinsics.checkNotNullParameter((Object)header3, (String)"header");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.title = title2;
            BorderLayoutPanel $this$apply = borderLayoutPanel = new BorderLayoutPanel();
            boolean bl = false;
            $this$apply.setOpaque(false);
            $this$apply.setBorder((Border)JBUI.Borders.emptyLeft((int)(avatar.getIconWidth() + 8)));
            $this$apply.addToCenter((Component)header3);
            BorderLayoutPanel headerPart = borderLayoutPanel;
            $this$apply = new BorderLayoutPanel();
            Object $this$apply2 = $this$apply;
            boolean bl2 = false;
            $this$apply2.setOpaque(false);
            $this$apply2.setBorder((Border)JBUI.Borders.empty());
            $this$apply2.addToTop((Component)this.userAvatar(avatar));
            BorderLayoutPanel avatarPanel = $this$apply;
            Object $this$apply3 = $this$apply2 = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)5)));
            boolean bl3 = false;
            ((JComponent)$this$apply3).setOpaque(false);
            ((JComponent)$this$apply3).setBorder((Border)JBUI.Borders.emptyLeft((int)8));
            MessageTitleComponent messageTitleComponent = this.title;
            if (messageTitleComponent != null) {
                MessageTitleComponent messageTitleComponent2;
                it = messageTitleComponent2 = messageTitleComponent;
                boolean bl4 = false;
                ((Container)$this$apply3).add((Component)it, "fill_h");
            }
            MessageTitleComponent $this$apply4 = it = new BorderLayoutPanel();
            boolean bl5 = false;
            $this$apply4.setOpaque(false);
            if (this.title == null) {
                $this$apply4.setBorder((Border)JBUI.Borders.emptyTop((int)(avatar.getIconHeight() / 4)));
            }
            $this$apply4.addToCenter(content2);
            MessageTitleComponent contentWrapper = it;
            ((Container)$this$apply3).add((Component)contentWrapper, "fill_h");
            Object rightPart = $this$apply2;
            Object $this$apply5 = $this$apply3 = new BorderLayoutPanel();
            boolean bl6 = false;
            $this$apply5.setOpaque(false);
            $this$apply5.addToLeft((Component)avatarPanel);
            $this$apply5.addToCenter((Component)rightPart);
            Object messagePanel = $this$apply3;
            AC it2 = aC = new AC();
            boolean bl7 = false;
            AC ac = width != null ? it2.size(":" + width + ":" + width) : it2;
            this.setLayout((LayoutManager)new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill().flowY(), ac));
            this.setOpaque(false);
            this.setBorder((Border)JBUI.Borders.emptyTop((int)15));
            this.add((Component)headerPart, new CC().grow().pushX());
            this.add((Component)messagePanel, new CC().grow().pushX());
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/space/vcs/chat/ui/SpaceChatItemComponentFactory$Item$Companion;", "", "()V", "AVATAR_GAP", "", "DEFAULT_CHAT_MESSAGE_WIDTH", "getDEFAULT_CHAT_MESSAGE_WIDTH", "()I", "intellij.space.vcs"})
        public static final class Companion {
            public final int getDEFAULT_CHAT_MESSAGE_WIDTH() {
                return JBUI.scale((int)500);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

