/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.dependencies;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.dependencies.ExternalDependenciesResolver;
import kotlin.script.experimental.dependencies.RepositoryCoordinates;
import kotlin.script.experimental.dependencies.impl.ResolverUtilsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J7\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00170\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0004*\u00020\u000fH\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0004*\u00020\fH\u0002R\"\u0010\u0006\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0007j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0004`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lkotlin/script/experimental/dependencies/FileSystemDependenciesResolver;", "Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver;", "paths", "", "Ljava/io/File;", "([Ljava/io/File;)V", "localRepos", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "acceptsArtifact", "", "artifactCoordinates", "", "acceptsRepository", "repositoryCoordinates", "Lkotlin/script/experimental/dependencies/RepositoryCoordinates;", "addRepository", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "options", "Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver$Options;", "sourceCodeLocation", "Lkotlin/script/experimental/api/SourceCode$LocationWithId;", "resolve", "", "(Ljava/lang/String;Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver$Options;Lkotlin/script/experimental/api/SourceCode$LocationWithId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toFilePath", "toRepositoryFileOrNull", "kotlin-scripting-dependencies"})
public final class FileSystemDependenciesResolver
implements ExternalDependenciesResolver {
    @NotNull
    private final ArrayList<File> localRepos;

    public FileSystemDependenciesResolver(File ... paths) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        Object[] objectArray = new File[]{null};
        this.localRepos = CollectionsKt.arrayListOf((Object[])objectArray);
        for (File path2 : paths) {
            boolean bl = path2.exists() && path2.isDirectory();
            if (bl) continue;
            boolean bl2 = false;
            String string2 = "Invalid flat lib directory repository path '" + path2 + '\'';
            throw new IllegalArgumentException(string2.toString());
        }
        CollectionsKt.addAll((Collection)this.localRepos, (Object[])paths);
    }

    private final File toRepositoryFileOrNull(String $this$toRepositoryFileOrNull) {
        File file2;
        File it = file2 = new File($this$toRepositoryFileOrNull);
        boolean bl = false;
        return it.exists() && it.isDirectory() ? file2 : null;
    }

    /*
     * WARNING - void declaration
     */
    private final File toFilePath(RepositoryCoordinates $this$toFilePath) {
        String string2;
        FileSystemDependenciesResolver fileSystemDependenciesResolver = this;
        URL uRL = ResolverUtilsKt.toRepositoryUrlOrNull($this$toFilePath);
        if (uRL == null) {
            string2 = null;
        } else {
            void it;
            URL uRL2;
            URL uRL3 = uRL2 = uRL;
            FileSystemDependenciesResolver fileSystemDependenciesResolver2 = fileSystemDependenciesResolver;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)it.getProtocol(), (Object)"file");
            fileSystemDependenciesResolver = fileSystemDependenciesResolver2;
            URL uRL4 = bl2 ? uRL2 : null;
            string2 = uRL4 == null ? null : uRL4.getPath();
        }
        String string3 = string2;
        return fileSystemDependenciesResolver.toRepositoryFileOrNull(string3 == null ? $this$toFilePath.getString() : string3);
    }

    @Override
    @NotNull
    public ResultWithDiagnostics<Boolean> addRepository(@NotNull RepositoryCoordinates repositoryCoordinates, @NotNull ExternalDependenciesResolver.Options options2, @Nullable SourceCode.LocationWithId sourceCodeLocation) {
        Intrinsics.checkNotNullParameter((Object)repositoryCoordinates, (String)"repositoryCoordinates");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        if (!this.acceptsRepository(repositoryCoordinates)) {
            return (ResultWithDiagnostics)ErrorHandlingKt.asSuccess$default((Object)false, null, (int)1, null);
        }
        File file2 = this.toFilePath(repositoryCoordinates);
        if (file2 == null) {
            return (ResultWithDiagnostics)ResolverUtilsKt.makeResolveFailureResult("Invalid repository location: '" + repositoryCoordinates + '\'', sourceCodeLocation);
        }
        File repoDir = file2;
        this.localRepos.add(repoDir);
        return (ResultWithDiagnostics)ErrorHandlingKt.asSuccess$default((Object)true, null, (int)1, null);
    }

    @Override
    @Nullable
    public Object resolve(@NotNull String artifactCoordinates, @NotNull ExternalDependenciesResolver.Options options2, @Nullable SourceCode.LocationWithId sourceCodeLocation, @NotNull Continuation<? super ResultWithDiagnostics<? extends List<? extends File>>> $completion) {
        if (!this.acceptsArtifact(artifactCoordinates)) {
            throw new IllegalArgumentException("Path is invalid");
        }
        List messages2 = new ArrayList();
        for (File repo : this.localRepos) {
            File file2 = repo == null ? new File(artifactCoordinates) : new File(repo, artifactCoordinates);
            if (!file2.exists()) {
                messages2.add("File '" + file2 + "' not found");
                continue;
            }
            if (!file2.isFile() && !file2.isDirectory()) {
                messages2.add("Path '" + file2 + "' is neither file nor directory");
                continue;
            }
            return new ResultWithDiagnostics.Success((Object)CollectionsKt.listOf((Object)file2), null, 2, null);
        }
        return ResolverUtilsKt.makeResolveFailureResult(messages2, sourceCodeLocation);
    }

    @Override
    public boolean acceptsArtifact(@NotNull String artifactCoordinates) {
        Intrinsics.checkNotNullParameter((Object)artifactCoordinates, (String)"artifactCoordinates");
        return !StringsKt.isBlank((CharSequence)artifactCoordinates);
    }

    @Override
    public boolean acceptsRepository(@NotNull RepositoryCoordinates repositoryCoordinates) {
        Intrinsics.checkNotNullParameter((Object)repositoryCoordinates, (String)"repositoryCoordinates");
        return this.toFilePath(repositoryCoordinates) != null;
    }
}

