/*
 * Decompiled with CFR 0.152.
 */
package libraries.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010J\u0006\u0010\u0011\u001a\u00020\tJ\u000b\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Llibraries/collections/SortedList;", "T", "", "", "()V", "list", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "sorted", "", "add", "", "item", "(Ljava/lang/Comparable;)V", "addAll", "items", "", "isEmpty", "remove", "()Ljava/lang/Comparable;", "libraries-collections"})
public final class SortedList<T extends Comparable<? super T>> {
    @NotNull
    private final ArrayList<T> list = new ArrayList();
    private boolean sorted;

    public final void add(@NotNull T item2) {
        Intrinsics.checkNotNullParameter(item2, (String)"item");
        this.list.add(item2);
        this.sorted = false;
    }

    public final void addAll(@NotNull Iterable<? extends T> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        CollectionsKt.addAll((Collection)this.list, items2);
        this.sorted = false;
    }

    @NotNull
    public final T remove() {
        if (!this.sorted) {
            CollectionsKt.sortDescending((List)this.list);
            this.sorted = true;
        }
        if (this.list.isEmpty()) {
            throw new NoSuchElementException();
        }
        T t = this.list.remove(this.list.size() - 1);
        Intrinsics.checkNotNullExpressionValue(t, (String)"list.removeAt(list.size - 1)");
        return (T)((Comparable)t);
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }
}

