/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.sort.ModuleInSort;
import org.apache.ivy.core.sort.NonMatchingVersionReporter;
import org.apache.ivy.plugins.version.VersionMatcher;

class CollectionOfModulesToSort
implements Iterable<ModuleInSort> {
    private final List<ModuleInSort> moduleDescriptors;
    private final VersionMatcher versionMatcher;
    private final Map<ModuleId, Collection<ModuleInSort>> modulesByModuleId;
    private final NonMatchingVersionReporter nonMatchingVersionReporter;

    public CollectionOfModulesToSort(Collection<ModuleDescriptor> modulesToSort, VersionMatcher matcher2, NonMatchingVersionReporter nonMatchingVersionReporter) {
        this.versionMatcher = matcher2;
        this.nonMatchingVersionReporter = nonMatchingVersionReporter;
        this.modulesByModuleId = new HashMap<ModuleId, Collection<ModuleInSort>>();
        this.moduleDescriptors = new ArrayList<ModuleInSort>(modulesToSort.size());
        for (ModuleDescriptor md : modulesToSort) {
            ModuleInSort mdInSort = new ModuleInSort(md);
            this.moduleDescriptors.add(mdInSort);
            this.addToModulesByModuleId(md, mdInSort);
        }
    }

    private void addToModulesByModuleId(ModuleDescriptor md, ModuleInSort mdInSort) {
        ModuleId mdId = md.getModuleRevisionId().getModuleId();
        LinkedList<ModuleInSort> mdInSortAsList = new LinkedList<ModuleInSort>();
        mdInSortAsList.add(mdInSort);
        Collection previousList = this.modulesByModuleId.put(mdId, mdInSortAsList);
        if (previousList != null) {
            mdInSortAsList.addAll(previousList);
        }
    }

    @Override
    public Iterator<ModuleInSort> iterator() {
        return this.moduleDescriptors.iterator();
    }

    public int size() {
        return this.moduleDescriptors.size();
    }

    public ModuleInSort getModuleDescriptorDependency(DependencyDescriptor descriptor2) {
        Collection<ModuleInSort> modulesOfSameId = this.modulesByModuleId.get(descriptor2.getDependencyId());
        if (modulesOfSameId == null) {
            return null;
        }
        for (ModuleInSort mdInSort : modulesOfSameId) {
            if (mdInSort.match(descriptor2, this.versionMatcher)) {
                return mdInSort;
            }
            this.nonMatchingVersionReporter.reportNonMatchingVersion(descriptor2, mdInSort.getSortedModuleDescriptor());
        }
        return null;
    }
}

