/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.version;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;

public class Match {
    private String revision;
    private String pattern;
    private String args;
    private String matcher;

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String matcher2) {
        this.matcher = matcher2;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern2) {
        this.pattern = pattern2;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public Matcher getPatternMatcher(ModuleRevisionId askedMrid) {
        String revision = askedMrid.getRevision();
        List<String> args = Match.split(this.getArgs());
        List<String> argValues = this.getRevisionArgs(revision);
        if (args.size() != argValues.size()) {
            return new NoMatchMatcher();
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        for (String arg : args) {
            variables.put(arg, argValues.get(args.indexOf(arg)));
        }
        String pattern2 = this.getPattern();
        pattern2 = IvyPatternHelper.substituteVariables(pattern2, variables);
        PatternMatcher pMatcher = IvyContext.getContext().getSettings().getMatcher(this.matcher);
        return pMatcher.getMatcher(pattern2);
    }

    private List<String> getRevisionArgs(String revision) {
        int bracketStartIndex = revision.indexOf(40);
        if (bracketStartIndex == -1) {
            return Collections.emptyList();
        }
        int bracketEndIndex = revision.indexOf(41);
        if (bracketEndIndex <= bracketStartIndex + 1) {
            return Collections.emptyList();
        }
        return Match.split(revision.substring(bracketStartIndex + 1, bracketEndIndex));
    }

    private static List<String> split(String string2) {
        if (string2 == null) {
            return Collections.emptyList();
        }
        StringTokenizer tokenizer = new StringTokenizer(string2, ", ");
        LinkedList<String> tokens2 = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens2.add(tokenizer.nextToken());
        }
        return tokens2;
    }

    private static class NoMatchMatcher
    implements Matcher {
        private NoMatchMatcher() {
        }

        @Override
        public boolean isExact() {
            return false;
        }

        @Override
        public boolean matches(String str) {
            return false;
        }
    }
}

