/*
 * Decompiled with CFR 0.152.
 */
package runtime.text;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.text.BOM;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"detectBOM", "Lruntime/text/BOM;", "bytes", "", "fileContentToString", "", "encoding", "Ljava/nio/charset/Charset;", "defaultEncoding", "isBinaryFileContent", "", "isControlChar", "ch", "", "platform-runtime"})
public final class FileContentKt {
    public static final boolean isBinaryFileContent(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (FileContentKt.detectBOM(bytes) != null) {
            return false;
        }
        int controlChars = 0;
        for (byte by : bytes) {
            if (!FileContentKt.isControlChar(by)) continue;
            ++controlChars;
        }
        int n = bytes.length;
        if (n == 0) {
            return false;
        }
        int threshold = (1 <= n ? n < 256 : false) ? 1 : Math.min(bytes.length / 100, 100);
        return controlChars >= threshold;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isControlChar(byte ch) {
        boolean bl;
        byte by = ch;
        if (0 <= by) {
            if (by < 8) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        by = ch;
        if (14 > by) return false;
        if (by >= 26) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final BOM detectBOM(@NotNull byte[] bytes) {
        BOM element$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        BOM[] $this$firstOrNull$iv = BOM.values();
        boolean $i$f$firstOrNull = false;
        BOM[] bOMArray = $this$firstOrNull$iv;
        int n = 0;
        int n2 = bOMArray.length;
        do {
            if (n >= n2) return null;
            element$iv = bOMArray[n];
            ++n;
            BOM bom = element$iv;
            boolean bl2 = false;
            if (bytes.length >= bom.getBom().length) {
                boolean bl3;
                block6: {
                    Iterable $this$all$iv = (Iterable)ArraysKt.getIndices((byte[])bom.getBom());
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        Iterator iterator2 = $this$all$iv.iterator();
                        while (iterator2.hasNext()) {
                            int element$iv2;
                            int it = element$iv2 = ((IntIterator)iterator2).nextInt();
                            boolean bl4 = false;
                            if (bom.getBom()[it] == bytes[it]) continue;
                            bl3 = false;
                            break block6;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        BOM bOM = element$iv;
        return bOM;
    }

    @NotNull
    public static final String fileContentToString(@NotNull byte[] bytes, @Nullable String defaultEncoding) {
        Charset charset;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        byte[] byArray = bytes;
        String string2 = defaultEncoding;
        if (string2 == null) {
            charset = null;
        } else {
            String it;
            String string3;
            String string4 = string3 = string2;
            byte[] byArray2 = byArray;
            boolean bl = false;
            boolean bl2 = Charset.isSupported(it);
            byArray = byArray2;
            String string5 = bl2 ? string3 : null;
            if (string5 == null) {
                charset = null;
            } else {
                it = string5;
                byArray2 = byArray;
                boolean bl3 = false;
                charset = Charset.forName(it);
                byArray = byArray2;
            }
        }
        Charset charset2 = charset;
        if (charset == null) {
            charset2 = Charsets.UTF_8;
        }
        return FileContentKt.fileContentToString(byArray, charset2);
    }

    public static /* synthetic */ String fileContentToString$default(byte[] byArray, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return FileContentKt.fileContentToString(byArray, string2);
    }

    @NotNull
    public static final String fileContentToString(@NotNull byte[] bytes, @NotNull Charset encoding) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        BOM bom = FileContentKt.detectBOM(bytes);
        if (bom != null) {
            int n = bom.getBom().length;
            int n2 = bytes.length - bom.getBom().length;
            Charset charset = bom.getCharset();
            return new String(bytes, n, n2, charset);
        }
        return new String(bytes, encoding);
    }
}

