/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JListCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JListCellBoundsQuery;
import org.assertj.swing.driver.JListCellCenterQuery;
import org.assertj.swing.driver.JListItemPreconditions;
import org.assertj.swing.driver.JListMatchingItemQuery;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.TextMatcher;

final class JListScrollToItemTask {
    static final Pair<Integer, Point> ITEM_NOT_FOUND = Pair.of(-1, null);

    @Nonnull
    @RunsInEDT
    static Point scrollToItem(@Nonnull JList<?> list2, int index) {
        Point result2 = GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(list2);
            JListItemPreconditions.checkIndexInBounds(list2, index);
            return JListScrollToItemTask.scrollToItemWithIndex(list2, index);
        });
        return Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInEDT
    static Pair<Integer, Point> scrollToItem(final @Nonnull JList<?> list2, final @Nonnull TextMatcher matcher2, final @Nonnull JListCellReader cellReader) {
        Pair<Integer, Point> result2 = GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(list2);
                int index = JListMatchingItemQuery.matchingItemIndex(list2, matcher2, cellReader);
                if (index < 0) {
                    return ITEM_NOT_FOUND;
                }
                return Pair.of(index, JListScrollToItemTask.scrollToItemWithIndex(list2, index));
            }
        });
        return Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInEDT
    static Pair<Integer, Point> scrollToItemIfNotSelectedYet(final @Nonnull JList<?> list2, final @Nonnull TextMatcher matcher2, final @Nonnull JListCellReader cellReader) {
        Pair<Integer, Point> result2 = GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(list2);
                int index = JListMatchingItemQuery.matchingItemIndex(list2, matcher2, cellReader);
                if (index < 0) {
                    return ITEM_NOT_FOUND;
                }
                return Pair.of(index, JListScrollToItemTask.scrollToItemWithIndexIfNotSelectedYet(list2, index));
            }
        });
        return Preconditions.checkNotNull(result2);
    }

    @Nullable
    @RunsInEDT
    static Point scrollToItemIfNotSelectedYet(@Nonnull JList<?> list2, int index) {
        return GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(list2);
            JListItemPreconditions.checkIndexInBounds(list2, index);
            return JListScrollToItemTask.scrollToItemWithIndexIfNotSelectedYet(list2, index);
        });
    }

    @Nullable
    @RunsInCurrentThread
    private static Point scrollToItemWithIndexIfNotSelectedYet(@Nonnull JList<?> list2, int index) {
        if (list2.getSelectedIndex() == index) {
            return null;
        }
        return JListScrollToItemTask.scrollToItemWithIndex(list2, index);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point scrollToItemWithIndex(@Nonnull JList<?> list2, int index) {
        Rectangle cellBounds = Preconditions.checkNotNull(JListCellBoundsQuery.cellBounds(list2, index));
        list2.scrollRectToVisible(cellBounds);
        return JListCellCenterQuery.cellCenter(list2, cellBounds);
    }

    private JListScrollToItemTask() {
    }
}

