/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.format;

import java.awt.Component;
import javax.swing.JFileChooser;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.format.ComponentFormatterTemplate;
import org.assertj.swing.format.IntEnum;

public class JFileChooserFormatter
extends ComponentFormatterTemplate {
    private static final IntEnum DIALOG_TYPES = new IntEnum();

    @Override
    @Nonnull
    @RunsInCurrentThread
    protected String doFormat(@Nonnull Component c) {
        JFileChooser fileChooser = (JFileChooser)c;
        String format = "%s[name=%s, dialogTitle=%s, dialogType=%s, currentDirectory=%s, enabled=%b, visible=%b, showing=%b";
        return String.format(format, this.getRealClassName(c), Strings.quote(fileChooser.getName()), Strings.quote(fileChooser.getDialogTitle()), DIALOG_TYPES.get(fileChooser.getDialogType()), new StandardRepresentation().toStringOf((Object)fileChooser.getCurrentDirectory()), fileChooser.isEnabled(), fileChooser.isVisible(), fileChooser.isShowing());
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        return JFileChooser.class;
    }

    static {
        DIALOG_TYPES.put(0, "OPEN_DIALOG").put(1, "SAVE_DIALOG").put(2, "CUSTOM_DIALOG");
    }
}

