/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.suggesters;

import com.intellij.codeWithMe.ClientId;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.local.ActionExtendedSummary;
import com.intellij.internal.statistic.local.ActionsLocalSummary;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.keymap.KeymapUtil;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.featuresSuggester.DocumentationSuggestion;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.NoSuggestion;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.TipSuggestion;
import training.featuresSuggester.settings.FeatureSuggesterSettings;
import training.featuresSuggester.suggesters.FeatureSuggester;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0004J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0016\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0016"}, d2={"Ltraining/featuresSuggester/suggesters/AbstractFeatureSuggester;", "Ltraining/featuresSuggester/suggesters/FeatureSuggester;", "()V", "message", "", "getMessage", "()Ljava/lang/String;", "suggestingActionId", "getSuggestingActionId", "suggestingDocUrl", "getSuggestingDocUrl", "suggestingTipFileName", "getSuggestingTipFileName", "createSuggestion", "Ltraining/featuresSuggester/Suggestion;", "getShortcutText", "actionId", "isRedoOrUndoRunning", "", "isSuggestingActionUsedRecently", "isSuggestionNeeded", "isSuggestionShownRecently", "intellij.featuresTrainer"})
public abstract class AbstractFeatureSuggester
implements FeatureSuggester {
    @Nullable
    private final String suggestingTipFileName;
    @Nullable
    private final String suggestingDocUrl;

    @Nullable
    protected String getSuggestingTipFileName() {
        return this.suggestingTipFileName;
    }

    @Nullable
    protected String getSuggestingDocUrl() {
        return this.suggestingDocUrl;
    }

    @NotNull
    protected abstract String getMessage();

    @NotNull
    protected abstract String getSuggestingActionId();

    @Override
    public boolean isSuggestionNeeded() {
        return !this.isSuggestingActionUsedRecently() && !this.isSuggestionShownRecently();
    }

    private final boolean isSuggestingActionUsedRecently() {
        boolean $i$f$service = false;
        Class<ActionsLocalSummary> serviceClass$iv = ActionsLocalSummary.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        ActionExtendedSummary actionExtendedSummary = ((ActionsLocalSummary)object).getActionStatsById(this.getSuggestingActionId());
        if (actionExtendedSummary == null) {
            return false;
        }
        ActionExtendedSummary summary = actionExtendedSummary;
        long lastTimeUsed = summary.lastUsedTimestamp;
        long oldestWorkingDayStart = FeatureSuggesterSettings.Companion.instance().getOldestWorkingDayStartMillis(this.getMinSuggestingIntervalDays());
        return lastTimeUsed > oldestWorkingDayStart;
    }

    private final boolean isSuggestionShownRecently() {
        long lastTimeShown = FeatureSuggesterSettings.Companion.instance().getSuggestionLastShownTime(this.getId());
        long delta = System.currentTimeMillis() - lastTimeShown;
        return delta < TimeUnit.DAYS.toMillis(1L);
    }

    @NotNull
    protected final Suggestion createSuggestion() {
        Suggestion suggestion;
        if (this.isRedoOrUndoRunning()) {
            return NoSuggestion.INSTANCE;
        }
        String fullMessage = this.getMessage() + " " + this.getShortcutText(this.getSuggestingActionId());
        if (this.getSuggestingTipFileName() != null) {
            String string = this.getId();
            String string2 = this.getSuggestingTipFileName();
            Intrinsics.checkNotNull((Object)string2);
            suggestion = new TipSuggestion(fullMessage, string, string2);
        } else {
            if (this.getSuggestingDocUrl() == null) {
                String string = "Suggester must implement 'suggestingTipFileName' or 'suggestingDocLink' property.";
                throw new IllegalStateException(string.toString());
            }
            String string = this.getId();
            String string3 = this.getSuggestingDocUrl();
            Intrinsics.checkNotNull((Object)string3);
            suggestion = new DocumentationSuggestion(fullMessage, string, string3);
        }
        return suggestion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRedoOrUndoRunning() {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)commandProcessor, (String)"CommandProcessor.getInstance()");
        String commandName = commandProcessor.getCurrentCommandName();
        if (commandName == null) return false;
        String string = ActionsBundle.message((String)"action.redo.description", (Object[])new Object[]{""});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ActionsBundle.message(\"a\u2026on.redo.description\", \"\")");
        if (StringsKt.startsWith$default((String)commandName, (String)string, (boolean)false, (int)2, null)) return true;
        String string2 = ActionsBundle.message((String)"action.undo.description", (Object[])new Object[]{""});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ActionsBundle.message(\"a\u2026on.undo.description\", \"\")");
        if (!StringsKt.startsWith$default((String)commandName, (String)string2, (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nls
    @NotNull
    public final String getShortcutText(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        String string = KeymapUtil.getShortcutText((String)actionId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KeymapUtil.getShortcutText(actionId)");
        String shortcut = string;
        return Intrinsics.areEqual((Object)shortcut, (Object)"<no shortcut>") ? FeatureSuggesterBundle.INSTANCE.message("shortcut.not.found.message", new Object[0]) : FeatureSuggesterBundle.INSTANCE.message("shortcut", shortcut);
    }
}

