/*
 * Decompiled with CFR 0.152.
 */
package org.toml.lang.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.lexer.UtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001aD\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000fH\u0086\b\u00f8\u0001\u0000\u001a\n\u0010\u0010\u001a\u00020\u0003*\u00020\u0011\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0012"}, d2={"esc", "Lcom/intellij/psi/tree/IElementType;", "test", "", "parseStringCharacters", "lexer", "Lcom/intellij/lexer/Lexer;", "chars", "", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sourceOffsets", "", "decoder", "Lkotlin/Function1;", "isWhitespaceChar", "", "intellij.toml.core"})
public final class EscapeUtilsKt {
    @NotNull
    public static final IElementType esc(boolean test) {
        IElementType iElementType;
        if (test) {
            IElementType iElementType2 = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            iElementType = iElementType2;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"VALID_STRING_ESCAPE_TOKEN");
        } else {
            IElementType iElementType3 = StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
            iElementType = iElementType3;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"INVALID_CHARACTER_ESCAPE_TOKEN");
        }
        return iElementType;
    }

    public static final boolean isWhitespaceChar(char $this$isWhitespaceChar) {
        return Character.valueOf($this$isWhitespaceChar).equals(Character.valueOf(' ')) || Character.valueOf($this$isWhitespaceChar).equals(Character.valueOf('\r')) || Character.valueOf($this$isWhitespaceChar).equals(Character.valueOf('\n')) || Character.valueOf($this$isWhitespaceChar).equals(Character.valueOf('\t'));
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean parseStringCharacters(@NotNull Lexer lexer, @NotNull String chars, @NotNull StringBuilder outChars, @NotNull int[] sourceOffsets, @NotNull Function1<? super String, String> decoder) {
        int $i$f$parseStringCharacters = 0;
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
        Intrinsics.checkNotNullParameter((Object)sourceOffsets, (String)"sourceOffsets");
        Intrinsics.checkNotNullParameter(decoder, (String)"decoder");
        int outOffset = outChars.length();
        int index = 0;
        block0: for (Pair pair : UtilsKt.tokenize(chars, lexer)) {
            void type;
            IElementType iElementType = (IElementType)pair.component1();
            String text = (String)pair.component2();
            sourceOffsets[outChars.length() - outOffset] = index;
            sourceOffsets[outChars.length() - outOffset + 1] = index + 1;
            void var12_12 = type;
            if (Intrinsics.areEqual((Object)var12_12, (Object)StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN)) {
                outChars.append((String)decoder.invoke((Object)text));
                index += text.length();
                continue;
            }
            if (Intrinsics.areEqual((Object)var12_12, (Object)StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) || Intrinsics.areEqual((Object)var12_12, (Object)StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN)) {
                return false;
            }
            int first = outChars.length() - outOffset;
            outChars.append(text);
            int n = first;
            int last = outChars.length() - outOffset - 1;
            int n2 = last;
            if (n > n2) continue;
            while (true) {
                void i;
                sourceOffsets[i] = index++;
                if (i == n2) continue block0;
                ++i;
            }
        }
        sourceOffsets[outChars.length() - outOffset] = index;
        return true;
    }
}

