/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI;

import com.intellij.debugger.mockJDI.MockMirror;
import com.intellij.debugger.mockJDI.MockStackFrame;
import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.types.MockType;
import com.intellij.debugger.mockJDI.values.MockValue;
import com.intellij.psi.PsiVariable;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public class MockLocalVariable
extends MockMirror
implements LocalVariable {
    private final String myName;
    private final MockType myType;
    private final MockValue myValue;

    public MockLocalVariable(MockVirtualMachine virtualMachine, PsiVariable psiVariable) {
        this(virtualMachine, psiVariable.getName(), MockType.createType(virtualMachine, psiVariable.getType()), null);
    }

    public MockLocalVariable(MockVirtualMachine virtualMachine, String name, MockType type, MockValue value) {
        super(virtualMachine);
        this.myName = name;
        this.myType = type;
        this.myValue = value;
    }

    @Override
    public String name() {
        return this.myName;
    }

    @Override
    public String typeName() {
        return this.myType.name();
    }

    @Override
    public Type type() {
        return this.myType;
    }

    @Override
    public String signature() {
        return this.myType.signature();
    }

    @Override
    public String genericSignature() {
        throw new UnsupportedOperationException("Not implemented: \"genericSignature\" in " + this.getClass().getName());
    }

    @Override
    public boolean isVisible(StackFrame stackFrame) {
        return ((MockStackFrame)stackFrame).visibleVariables().contains(this);
    }

    @Override
    public boolean isArgument() {
        return false;
    }

    @Override
    public int compareTo(LocalVariable o) {
        throw new UnsupportedOperationException("Not implemented: \"compareTo\" in " + this.getClass().getName());
    }

    public Value getValue() {
        return this.myValue;
    }
}

