/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.projectWizard.ChooseTemplateStep;
import com.intellij.ide.projectWizard.ProjectTypeStep;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.SelectTemplateSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.NewProjectWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LanguageLevelProjectExtensionImpl;
import com.intellij.openapi.roots.ui.configuration.actions.NewModuleAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectWizardTestCase<T extends AbstractProjectWizard>
extends HeavyPlatformTestCase {
    protected static final String DEFAULT_SDK = "default";
    protected T myWizard;
    @Nullable
    private Project myCreatedProject;
    private Sdk myOldDefaultProjectSdk;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        this.myOldDefaultProjectSdk = ProjectRootManager.getInstance((Project)defaultProject).getProjectSdk();
        Sdk projectSdk = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk();
        for (Sdk jdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (projectSdk == jdk) continue;
            ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().removeJdk(jdk));
        }
        ProjectTypeStep.resetGroupForTests();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            if (this.myWizard != null) {
                Disposer.dispose((Disposable)this.myWizard.getDisposable());
                this.myWizard = null;
            }
            if (this.myCreatedProject != null) {
                PlatformTestUtil.forceCloseProjectWithoutSaving(this.myCreatedProject);
                this.myCreatedProject = null;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                LanguageLevelProjectExtensionImpl extension = LanguageLevelProjectExtensionImpl.getInstanceImpl((Project)ProjectManager.getInstance().getDefaultProject());
                extension.resetDefaults();
                ProjectRootManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).setProjectSdk(this.myOldDefaultProjectSdk);
                JavaAwareProjectJdkTableImpl.removeInternalJdkInTests();
            });
            SelectTemplateSettings.getInstance().setLastTemplate(null, null);
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected Project createProjectFromTemplate(@NotNull String group, @Nullable String name, @Nullable Consumer<? super Step> adjuster) throws IOException {
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(0);
        }
        this.runWizard(group, name, null, adjuster);
        try {
            this.myCreatedProject = NewProjectUtil.createFromWizard(this.myWizard);
        }
        catch (Throwable e) {
            this.myCreatedProject = (Project)ContainerUtil.find((Object[])ProjectManager.getInstance().getOpenProjects(), project2 -> this.myWizard.getProjectName().equals(project2.getName()));
            throw new RuntimeException(e);
        }
        ProjectWizardTestCase.assertNotNull((Object)this.myCreatedProject);
        UIUtil.dispatchAllInvocationEvents();
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        ProjectWizardTestCase.assertEquals((String)Arrays.asList(projects).toString(), (int)2, (int)projects.length);
        return this.myCreatedProject;
    }

    protected Project getCreatedProject() {
        return this.myCreatedProject;
    }

    @Nullable
    protected Module createModuleFromTemplate(String group, String name, @Nullable Consumer<? super Step> adjuster) throws IOException {
        return this.createModuleFromTemplate(group, name, this.getProject(), adjuster);
    }

    @Nullable
    protected Module createModuleFromTemplate(String group, String name, @NotNull Project project2, @Nullable Consumer<? super Step> adjuster) throws IOException {
        if (project2 == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(1);
        }
        this.runWizard(group, name, project2, adjuster);
        return this.createModuleFromWizard(project2);
    }

    private Module createModuleFromWizard(@NotNull Project project2) {
        if (project2 == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(2);
        }
        return new NewModuleAction().createModuleFromWizard(project2, null, this.myWizard);
    }

    private void runWizard(@NotNull String group, @Nullable String name, @Nullable Project project2, @Nullable Consumer<? super Step> adjuster) throws IOException {
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(3);
        }
        this.createWizard(project2);
        ProjectTypeStep step = (ProjectTypeStep)this.myWizard.getCurrentStepObject();
        if (!step.setSelectedTemplate(group, name)) {
            throw new IllegalArgumentException(group + "/" + name + " template not found. Available groups: " + step.availableTemplateGroupsToString());
        }
        this.runWizard(step1 -> {
            if (name != null && step1 instanceof ChooseTemplateStep) {
                ((ChooseTemplateStep)step1).setSelectedTemplate(name);
            }
            if (adjuster != null) {
                adjuster.accept((Step)step1);
            }
        });
    }

    protected void cancelWizardRun() {
        throw new CancelWizardException();
    }

    private void runWizard(@Nullable Consumer<? super Step> adjuster) {
        block5: {
            ModuleWizardStep currentStep;
            do {
                currentStep = (ModuleWizardStep)this.myWizard.getCurrentStepObject();
                if (adjuster != null) {
                    try {
                        adjuster.accept((Step)currentStep);
                    }
                    catch (CancelWizardException e) {
                        this.myWizard.doCancelAction();
                        return;
                    }
                }
                if (this.myWizard.isLast()) break block5;
                this.myWizard.doNextAction();
            } while (currentStep != this.myWizard.getCurrentStepObject());
            throw new RuntimeException(currentStep + " is not validated");
        }
        if (!this.myWizard.doFinishAction()) {
            throw new RuntimeException(this.myWizard.getCurrentStepObject() + " is not validated");
        }
    }

    protected void createWizard(@Nullable Project project2) throws IOException {
        if (this.myWizard != null) {
            Disposer.dispose((Disposable)this.myWizard.getDisposable());
            this.myWizard = null;
        }
        this.myWizard = this.createWizard(project2, this.createTempDirectoryWithSuffix("new").toFile());
        UIUtil.dispatchAllInvocationEvents();
    }

    protected Project createProject(Consumer<? super Step> adjuster) throws IOException {
        this.createWizard(null);
        this.runWizard(adjuster);
        this.myWizard.disposeIfNeeded();
        this.myCreatedProject = NewProjectUtil.createFromWizard(this.myWizard);
        return this.myCreatedProject;
    }

    protected Project createProjectFromTemplate(@NotNull Consumer<? super NewProjectWizardStep> adjuster) throws IOException {
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(4);
        }
        return this.createProjectFromTemplate(UIBundle.message((String)"label.project.wizard.project.generator.name", (Object[])new Object[0]), adjuster);
    }

    protected Project createProjectFromTemplate(@NotNull String group, @NotNull Consumer<? super NewProjectWizardStep> adjuster) throws IOException {
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(5);
        }
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(6);
        }
        return this.createProject(step -> {
            NewProjectWizardStep npwStep = this.getNewProjectWizardStep((Step)step, group);
            if (npwStep != null) {
                adjuster.accept(npwStep);
            }
        });
    }

    protected Module createModule(@NotNull Project project2, @NotNull Consumer<? super Step> adjuster) throws IOException {
        if (project2 == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(7);
        }
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(8);
        }
        this.createWizard(null);
        this.runWizard(adjuster);
        this.myWizard.disposeIfNeeded();
        return this.createModuleFromWizard(project2);
    }

    protected Module createModuleFromTemplate(@NotNull Project project2, @NotNull Consumer<? super NewProjectWizardStep> adjuster) throws IOException {
        if (project2 == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(9);
        }
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(10);
        }
        return this.createModuleFromTemplate(project2, UIBundle.message((String)"label.project.wizard.module.generator.name", (Object[])new Object[0]), adjuster);
    }

    protected Module createModuleFromTemplate(@NotNull Project project2, @NotNull String group, @NotNull Consumer<? super NewProjectWizardStep> adjuster) throws IOException {
        if (project2 == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(11);
        }
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(12);
        }
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(13);
        }
        return this.createModuleFromTemplate(group, null, project2, step -> {
            NewProjectWizardStep npwStep = this.getNewProjectWizardStep((Step)step, group);
            if (npwStep != null) {
                adjuster.accept(npwStep);
            }
        });
    }

    @Nullable
    protected NewProjectWizardStep getNewProjectWizardStep(@NotNull Step step, @NotNull String group) {
        if (step == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(14);
        }
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(15);
        }
        if (step instanceof ProjectTypeStep) {
            ProjectTypeStep projectTypeStep = (ProjectTypeStep)step;
            ProjectWizardTestCase.assertTrue((boolean)projectTypeStep.setSelectedTemplate(group, null));
            List steps = this.myWizard.getSequence().getSelectedSteps();
            ProjectWizardTestCase.assertEquals((String)steps.toString(), (int)1, (int)steps.size());
            ModuleWizardStep moduleWizardStep = projectTypeStep.getCustomStep();
            ProjectWizardTestCase.assertInstanceOf(moduleWizardStep, NewProjectWizardStep.class);
            return (NewProjectWizardStep)moduleWizardStep;
        }
        return null;
    }

    protected T createWizard(Project project2, File directory) {
        throw new RuntimeException();
    }

    protected void configureJdk() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.addSdk(new SimpleJavaSdkType().createJdk(DEFAULT_SDK, SystemProperties.getJavaHome()));
            this.addSdk(new SimpleJavaSdkType().createJdk("_other", SystemProperties.getJavaHome()));
            LOG.debug("ProjectWizardTestCase.configureJdk:");
            LOG.debug(String.valueOf(Arrays.asList(ProjectJdkTable.getInstance().getAllJdks())));
        });
    }

    protected void addSdk(Sdk sdk) {
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk, this.getTestRootDisposable()));
    }

    protected Module importModuleFrom(ProjectImportProvider provider, String path) {
        return this.importFrom(path, this.getProject(), null, provider);
    }

    protected Module importProjectFrom(String path, Consumer<? super Step> adjuster, ProjectImportProvider ... providers) {
        Module module = this.importFrom(path, null, adjuster, providers);
        if (module != null) {
            this.myCreatedProject = module.getProject();
        }
        return module;
    }

    private Module importFrom(String path, @Nullable Project project2, Consumer<? super Step> adjuster, ProjectImportProvider ... providers) {
        return ProjectWizardTestCase.computeInWriteSafeContext(() -> this.doImportModule(path, project2, adjuster, providers));
    }

    private Module doImportModule(String path, @Nullable Project project2, Consumer<? super Step> adjuster, ProjectImportProvider[] providers) {
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        ProjectWizardTestCase.assertNotNull((String)("Can't find " + path), (Object)file2);
        ProjectWizardTestCase.assertTrue((boolean)providers[0].canImport(file2, project2));
        this.myWizard = ImportModuleAction.createImportWizard((Project)project2, null, (VirtualFile)file2, (ProjectImportProvider[])providers);
        ProjectWizardTestCase.assertNotNull(this.myWizard);
        if (this.myWizard.getStepCount() > 0) {
            this.runWizard(adjuster);
        }
        return (Module)ContainerUtil.getFirstItem((List)ImportModuleAction.createFromWizard((Project)project2, this.myWizard));
    }

    private static <T> T computeInWriteSafeContext(Supplier<? extends T> supplier) {
        Ref module = Ref.create();
        ApplicationManager.getApplication().invokeLater(() -> module.set(supplier.get()));
        UIUtil.dispatchAllInvocationEvents();
        return (T)module.get();
    }

    protected Sdk createSdk(String name, SdkTypeId sdkType) {
        Sdk sdk = ProjectJdkTable.getInstance().createSdk(name, sdkType);
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk, this.getTestRootDisposable()));
        return sdk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adjuster";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectWizard/ProjectWizardTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createProjectFromTemplate";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createModuleFromTemplate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createModuleFromWizard";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runWizard";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createModule";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getNewProjectWizardStep";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CancelWizardException
    extends RuntimeException {
        private CancelWizardException() {
        }
    }
}

