/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PropertyBag
implements Map<String, Object> {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<String> additionalTags = new LinkedHashSet<String>();

    public Set<String> getTags() {
        HashSet<String> result = new HashSet<String>(this.properties.keySet());
        result.addAll(this.additionalTags);
        return result;
    }

    public Set<String> getAdditionalTags() {
        return this.additionalTags;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.properties.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.properties.putAll(m);
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.properties.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyBag that = (PropertyBag)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.additionalTags, that.additionalTags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.properties, this.additionalTags);
    }

    public static class PropertyBagTypeAdapter
    extends TypeAdapter<PropertyBag> {
        private static final Gson embedded = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

        public void write(JsonWriter out, PropertyBag bag) throws IOException {
            HashMap<String, Object> toSerialize = new HashMap<String, Object>(bag);
            toSerialize.put("tags", bag.getTags());
            embedded.toJson(toSerialize, Map.class, out);
        }

        public PropertyBag read(JsonReader reader) throws IOException {
            PropertyBag result = new PropertyBag();
            Map map = (Map)embedded.fromJson(reader, Map.class);
            Object tags = map.remove("tags");
            result.putAll(map);
            if (tags instanceof String[]) {
                for (String tag : (String[])tags) {
                    if (map.containsKey(tag)) continue;
                    result.additionalTags.add(tag);
                }
            }
            return result;
        }
    }
}

