/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.highlight;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.navigation.JBProtocolRevisionResolver;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.VersionControlDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.highlight.QodanaRevisionData;
import org.jetbrains.qodana.highlight.QodanaRevisionDataKt;
import org.jetbrains.qodana.problem.SarifProblem;
import org.jetbrains.qodana.report.HighlightedReportData;
import org.jetbrains.qodana.report.QodanaReportsService;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J(\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J$\u0010\u001c\u001a\u00020\u00152\u001a\u0010\u001d\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u001e0\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/qodana/highlight/QodanaReportHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "myFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "myHighlightInfos", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "buildHighlightInfo", "problem", "Lorg/jetbrains/qodana/problem/SarifProblem;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "calculateTextRanges", "", "relevantProblems", "revisionPsiFile", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getPsiFileByRevision", "revisionId", "", "updateProblemsStatuses", "problemsWithRanges", "Lkotlin/Pair;", "Registrar", "intellij.qodana"})
public final class QodanaReportHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    private final List<HighlightInfo> myHighlightInfos;
    private final PsiFile myFile;
    private final Editor editor;

    /*
     * WARNING - void declaration
     */
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object project$iv;
        QodanaRevisionData data;
        List relevantProblems;
        VirtualFile virtualFile;
        block8: {
            void title$iv;
            String revisionId;
            String $this$filterTo$iv$iv;
            block7: {
                Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                VirtualFile virtualFile2 = this.myFile.getVirtualFile();
                if (virtualFile2 == null) {
                    return;
                }
                virtualFile = virtualFile2;
                this.myHighlightInfos.clear();
                Project project = this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                Project $this$service$iv = project;
                boolean $i$f$service = false;
                Object object = $this$service$iv.getService(QodanaReportsService.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                QodanaReportsService reportsService = (QodanaReportsService)object;
                HighlightedReportData highlightedReportData = reportsService.getHighlightedReportData();
                if (highlightedReportData == null) {
                    return;
                }
                HighlightedReportData highlightedReportData2 = highlightedReportData;
                Iterable $this$filter$iv = highlightedReportData2.getProblems();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    SarifProblem it = (SarifProblem)element$iv$iv;
                    boolean bl = false;
                    if (!it.isRelevantToFile(virtualFile)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                relevantProblems = (List)destination$iv$iv;
                if (relevantProblems.isEmpty()) {
                    return;
                }
                Run run = highlightedReportData2.getReport().getRuns().get(0);
                Intrinsics.checkNotNullExpressionValue((Object)run, (String)"highlightedReportData.report.runs[0]");
                Set<VersionControlDetails> set = run.getVersionControlProvenance();
                revisionId = set != null && (set = (VersionControlDetails)CollectionsKt.firstOrNull((Iterable)set)) != null ? ((VersionControlDetails)((Object)set)).getRevisionId() : null;
                data = (QodanaRevisionData)this.editor.getDocument().getUserData(QodanaRevisionDataKt.getQODANA_REVISION_DATA());
                if (data == null || Intrinsics.areEqual((Object)data.getRevisionId(), (Object)revisionId) ^ true) break block7;
                PsiFile psiFile = data.getRevisionPsiFile();
                if (psiFile == null) break block8;
                if (psiFile.isValid()) break block8;
            }
            String string = QodanaBundle.message("progress.title.qodana.highlight.calc", this.myFile.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"pr\u2026light.calc\", myFile.name)");
            $this$filterTo$iv$iv = string;
            project$iv = this.myProject;
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable((Project)project$iv, (String)title$iv, cancellable$iv, (Project)project$iv, (String)title$iv, cancellable$iv, this, revisionId){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                final /* synthetic */ boolean $cancellable;
                final /* synthetic */ QodanaReportHighlightingPass this$0;
                final /* synthetic */ String $revisionId$inlined;
                {
                    this.$project = $captured_local_variable$1;
                    this.$title = $captured_local_variable$2;
                    this.$cancellable = $captured_local_variable$3;
                    this.this$0 = qodanaReportHighlightingPass;
                    this.$revisionId$inlined = string;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    PsiFile revisionPsiFile = QodanaReportHighlightingPass.access$getPsiFileByRevision(this.this$0, QodanaReportHighlightingPass.access$getMyFile$p(this.this$0), this.$revisionId$inlined);
                    QodanaReportHighlightingPass.access$getEditor$p(this.this$0).getDocument().putUserData(QodanaRevisionDataKt.getQODANA_REVISION_DATA(), (Object)new QodanaRevisionData(this.$revisionId$inlined, revisionPsiFile));
                    DaemonCodeAnalyzer.getInstance((Project)QodanaReportHighlightingPass.access$getMyProject$p(this.this$0)).restart(QodanaReportHighlightingPass.access$getMyFile$p(this.this$0));
                }
            });
            return;
        }
        List relevantProblemsWithRanges = CollectionsKt.zip((Iterable)relevantProblems, (Iterable)this.calculateTextRanges(relevantProblems, data.getRevisionPsiFile()));
        project$iv = relevantProblemsWithRanges;
        List<HighlightInfo> list = this.myHighlightInfos;
        boolean $i$f$mapNotNull = false;
        void $i$f$runBackgroundableTask = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            HighlightInfo highlightInfo;
            void problem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair $dstr$problem$range = (Pair)element$iv$iv;
            boolean bl2 = false;
            SarifProblem sarifProblem = (SarifProblem)$dstr$problem$range.component1();
            TextRange range = (TextRange)$dstr$problem$range.component2();
            if (this.buildHighlightInfo((SarifProblem)problem, range) == null) continue;
            HighlightInfo it$iv$iv = highlightInfo;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        list.addAll(list2);
        if (virtualFile.isInLocalFileSystem()) {
            this.updateProblemsStatuses(relevantProblemsWithRanges);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateProblemsStatuses(List<? extends Pair<SarifProblem, ? extends TextRange>> problemsWithRanges) {
        SarifProblem sarifProblem;
        Collection<SarifProblem> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void presentProblems;
        Pair it;
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        Object $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(QodanaReportsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        QodanaReportsService reportsService = (QodanaReportsService)object;
        Iterable $this$partition$iv = problemsWithRanges;
        boolean $i$f$partition22 = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            if (it.getSecond() != null) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Object object2 = new Pair(first$iv, second$iv);
        $this$service$iv = (List)object2.component1();
        List notPresentProblems = (List)object2.component2();
        object2 = (Iterable)presentProblems;
        QodanaReportsService qodanaReportsService = reportsService;
        boolean $i$f$map = false;
        void $i$f$partition22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            sarifProblem = (SarifProblem)it.getFirst();
            collection.add(sarifProblem);
        }
        collection = (List)destination$iv$iv;
        qodanaReportsService.setProblemsPresentStatus(collection, true);
        $this$map$iv = notPresentProblems;
        qodanaReportsService = reportsService;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            sarifProblem = (SarifProblem)it.getFirst();
            collection.add(sarifProblem);
        }
        collection = (List)destination$iv$iv;
        qodanaReportsService.setProblemsPresentStatus(collection, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PsiFile getPsiFileByRevision(PsiFile myFile, String revisionId) {
        PsiFile psiFile;
        if (revisionId == null) return null;
        VirtualFile virtualFile = myFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"myFile.virtualFile");
        String string = virtualFile.getCanonicalPath();
        if (string == null) return null;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myFile.virtualFile.canonicalPath ?: return null");
        String path = string;
        VirtualFile virtualFile2 = JBProtocolRevisionResolver.processResolvers((Project)this.myProject, (String)path, (String)revisionId);
        if (virtualFile2 == null) return null;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"JBProtocolRevisionResolv\u2026evisionId) ?: return null");
        VirtualFile revisionFile = virtualFile2;
        boolean $i$f$runReadAction = false;
        PsiFile psiFile2 = psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction(new Computable(this, revisionFile){
            final /* synthetic */ QodanaReportHighlightingPass this$0;
            final /* synthetic */ VirtualFile $revisionFile$inlined;
            {
                this.this$0 = qodanaReportHighlightingPass;
                this.$revisionFile$inlined = virtualFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)PsiManager.getInstance((Project)QodanaReportHighlightingPass.access$getMyProject$p(this.this$0)).findFile(this.$revisionFile$inlined);
            }
        });
        if (psiFile2 != null) {
            if (!psiFile2.isValid()) {
                return null;
            }
        }
        PsiFile psiFile3 = psiFile;
        return psiFile3;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextRange> calculateTextRanges(List<SarifProblem> relevantProblems, PsiFile revisionPsiFile) {
        TextRange textRange;
        int n;
        ArrayList<TextRange> arrayList;
        void $this$mapTo$iv$iv;
        if (relevantProblems.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = relevantProblems;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        ArrayList<TextRange> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SarifProblem sarifProblem = (SarifProblem)item$iv$iv;
            arrayList = destination$iv$iv;
            n = 0;
            Document document = this.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
            textRange = it.getTextRangeInDocument(document);
            arrayList.add(textRange);
        }
        List rangesInCurrentDocument = destination$iv$iv;
        if (revisionPsiFile == null) {
            return rangesInCurrentDocument;
        }
        FileViewProvider fileViewProvider = revisionPsiFile.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"revisionPsiFile.viewProvider");
        Document revisionDocument = fileViewProvider.getDocument();
        if (revisionDocument == null) {
            return rangesInCurrentDocument;
        }
        OffsetsInFile offsetsInFile = new OffsetsInFile(revisionPsiFile);
        List keys = new ArrayList();
        Iterable $this$forEachIndexed$iv = relevantProblems;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void problem;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SarifProblem sarifProblem = (SarifProblem)item$iv;
            int index2 = n;
            boolean bl2 = false;
            OffsetKey start = OffsetKey.create((String)("START" + index2));
            OffsetKey end = OffsetKey.create((String)("END" + index2));
            keys.add(TuplesKt.to((Object)start, (Object)end));
            TextRange oldTextRange = problem.getTextRangeInDocument(revisionDocument);
            if (oldTextRange == null) continue;
            offsetsInFile.getOffsets().addOffset(start, oldTextRange.getStartOffset());
            offsetsInFile.getOffsets().addOffset(end, oldTextRange.getEndOffset());
        }
        TextRange textRange2 = revisionPsiFile.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"revisionPsiFile.textRange");
        int n2 = textRange2.getEndOffset();
        String string = this.myFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myFile.text");
        OffsetMap newOffsets = offsetsInFile.copyWithReplacement(0, n2, string).getOffsets();
        int n3 = relevantProblems.size();
        ArrayList<TextRange> arrayList2 = new ArrayList<TextRange>(n3);
        for (int i = 0; i < n3; ++i) {
            void startKey;
            void index;
            int n4;
            n = n4 = i;
            arrayList = arrayList2;
            boolean bl = false;
            Pair index2 = (Pair)keys.get((int)index);
            OffsetKey bl2 = (OffsetKey)index2.component1();
            OffsetKey endKey = (OffsetKey)index2.component2();
            boolean rangeCalculatedSuccessfully = newOffsets.containsOffset((OffsetKey)startKey) && newOffsets.containsOffset(endKey);
            textRange = rangeCalculatedSuccessfully ? new TextRange(newOffsets.getOffset((OffsetKey)startKey), newOffsets.getOffset(endKey)) : null;
            arrayList.add(textRange);
        }
        return arrayList2;
    }

    private final HighlightInfo buildHighlightInfo(SarifProblem problem, TextRange textRange) {
        if (textRange == null) {
            return null;
        }
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"HighlightInfo.newHighlig\u2026GS_OR_ERRORS_FROM_SERVER)");
        HighlightInfo.Builder builder2 = builder;
        return builder2.range(textRange).needsUpdateOnTyping(true).descriptionAndTooltip(problem.getDescription()).create();
    }

    public void doApplyInformationToEditor() {
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), (Collection)this.myHighlightInfos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    public QodanaReportHighlightingPass(@NotNull PsiFile myFile, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(myFile.getProject(), editor.getDocument());
        this.myFile = myFile;
        this.editor = editor;
        this.myHighlightInfos = new ArrayList();
    }

    public static final /* synthetic */ PsiFile access$getPsiFileByRevision(QodanaReportHighlightingPass $this, PsiFile myFile, String revisionId) {
        return $this.getPsiFileByRevision(myFile, revisionId);
    }

    public static final /* synthetic */ PsiFile access$getMyFile$p(QodanaReportHighlightingPass $this) {
        return $this.myFile;
    }

    public static final /* synthetic */ Editor access$getEditor$p(QodanaReportHighlightingPass $this) {
        return $this.editor;
    }

    public static final /* synthetic */ Project access$getMyProject$p(QodanaReportHighlightingPass $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/highlight/QodanaReportHighlightingPass$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.qodana"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactory,
    TextEditorHighlightingPassFactoryRegistrar,
    DumbAware {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
        }

        @NotNull
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return new QodanaReportHighlightingPass(file, editor);
        }
    }
}

