/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.componentTree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.uiDesigner.ErrorAnalyzer;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.quickFixes.QuickFixManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Rectangle;
import javax.swing.JViewport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class QuickFixManagerImpl
extends QuickFixManager<ComponentTree> {
    private static final Logger LOG = Logger.getInstance(QuickFixManagerImpl.class);

    public QuickFixManagerImpl(GuiEditor editor, @NotNull ComponentTree componentTree, JViewport viewPort) {
        if (componentTree == null) {
            QuickFixManagerImpl.$$$reportNull$$$0(0);
        }
        super(editor, componentTree, viewPort);
        ((ComponentTree)((Object)this.myComponent)).addTreeSelectionListener(new MyTreeSelectionListener());
    }

    @Override
    protected ErrorInfo @NotNull [] getErrorInfos() {
        RadComponent component = ((ComponentTree)((Object)this.myComponent)).getSelectedComponent();
        if (component == null) {
            if (ErrorInfo.EMPTY_ARRAY == null) {
                QuickFixManagerImpl.$$$reportNull$$$0(1);
            }
            return ErrorInfo.EMPTY_ARRAY;
        }
        ErrorInfo[] errorInfoArray = ErrorAnalyzer.getAllErrorsForComponent(component);
        if (errorInfoArray == null) {
            QuickFixManagerImpl.$$$reportNull$$$0(2);
        }
        return errorInfoArray;
    }

    @Override
    public Rectangle getErrorBounds() {
        TreePath selectionPath = ((ComponentTree)((Object)this.myComponent)).getSelectionPath();
        LOG.assertTrue(selectionPath != null);
        return ((ComponentTree)((Object)this.myComponent)).getPathBounds(selectionPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentTree";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/componentTree/QuickFixManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/componentTree/QuickFixManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            QuickFixManagerImpl.this.hideIntentionHint();
            QuickFixManagerImpl.this.updateIntentionHintVisibility();
            ErrorInfo[] errorInfos = QuickFixManagerImpl.this.getErrorInfos();
            String text = errorInfos.length > 0 ? errorInfos[0].myDescription : "";
            StatusBar.Info.set((String)text, (Project)((ComponentTree)((Object)QuickFixManagerImpl.this.myComponent)).getProject());
        }
    }
}

