/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.ide.palette.impl.PaletteToolWindowManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.DragSelectionProcessor;
import com.intellij.uiDesigner.designSurface.EventProcessor;
import com.intellij.uiDesigner.designSurface.GroupSelectionProcessor;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.InplaceEditingLayer;
import com.intellij.uiDesigner.designSurface.InsertComponentProcessor;
import com.intellij.uiDesigner.designSurface.Painter;
import com.intellij.uiDesigner.designSurface.PasteProcessor;
import com.intellij.uiDesigner.designSurface.ResizeProcessor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class MainProcessor
extends EventProcessor {
    private static final Logger LOG = Logger.getInstance(MainProcessor.class);
    private static final int DRAGGER_SIZE = 10;
    private EventProcessor myCurrentProcessor;
    @NotNull
    private final InsertComponentProcessor myInsertComponentProcessor;
    @NotNull
    private final GuiEditor myEditor;
    private boolean myInsertFeedbackEnabled;
    private Point myLastMousePosition;

    public MainProcessor(@NotNull GuiEditor editor) {
        if (editor == null) {
            MainProcessor.$$$reportNull$$$0(0);
        }
        this.myInsertFeedbackEnabled = true;
        this.myLastMousePosition = new Point(0, 0);
        this.myEditor = editor;
        this.myInsertComponentProcessor = new InsertComponentProcessor(this.myEditor);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        ArrayList<RadComponent> selection;
        if (e.getKeyCode() == 16) {
            if (e.getID() == 401) {
                if (this.myCurrentProcessor != null && this.myCurrentProcessor.isDragActive() || PaletteToolWindowManager.getInstance(this.myEditor).getActiveItem(ComponentItem.class) != null && this.myCurrentProcessor != this.myInsertComponentProcessor) {
                    this.myEditor.setDesignTimeInsets(12);
                }
            } else {
                this.myEditor.setDesignTimeInsets(2);
            }
        }
        if (this.myCurrentProcessor != null) {
            this.myCurrentProcessor.processKeyEvent(e);
        } else if (e.getID() == 400 && Character.isLetterOrDigit(e.getKeyChar()) && (e.getModifiers() & 0xE) == 0 && (selection = FormEditingUtil.getAllSelectedComponents(this.myEditor)).size() > 0) {
            RadComponent component = selection.get(0);
            InplaceEditingLayer inplaceLayer = this.myEditor.getInplaceEditingLayer();
            inplaceLayer.startInplaceEditing(component, component.getDefaultInplaceProperty(), component.getDefaultInplaceEditorBounds(), new InplaceContext(false, e.getKeyChar()));
            e.consume();
        }
    }

    public Point getLastMousePosition() {
        return this.myLastMousePosition;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        this.myLastMousePosition = e.getPoint();
        if (this.myCurrentProcessor != null && this.myCurrentProcessor.isDragActive()) {
            return;
        }
        if (e.isPopupTrigger()) {
            RadComponent component = FormEditingUtil.getRadComponentAt(this.myEditor.getRootContainer(), e.getX(), e.getY());
            if (component != null && !component.isSelected()) {
                FormEditingUtil.selectSingleComponent(this.myEditor, component);
            }
            ActionManager actionManager = ActionManager.getInstance();
            ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("GuiDesigner.EditorPopup", (ActionGroup)actionManager.getAction("GuiDesigner.EditorPopupMenu"));
            popupMenu.getComponent().show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        int id = e.getID();
        if (!(2 != e.getButton() && 3 != e.getButton() || 501 != id && 502 != id && 500 != id)) {
            return;
        }
        RadComponent componentAt = FormEditingUtil.getRadComponentAt(this.myEditor.getRootContainer(), e.getX(), e.getY());
        if (componentAt != null) {
            Point p1 = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), componentAt.getDelegee());
            Component deepestComponentAt = SwingUtilities.getDeepestComponentAt(componentAt.getDelegee(), p1.x, p1.y);
            Point p2 = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), deepestComponentAt);
            EventProcessor processor = componentAt.getEventProcessor(e);
            if (processor != null) {
                this.myCurrentProcessor = processor;
            } else {
                Component source = deepestComponentAt != null ? deepestComponentAt : componentAt.getDelegee();
                componentAt.processMouseEvent(new MouseEvent(source, id, e.getWhen(), e.getModifiers(), p2.x, p2.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
            }
        }
        Cursor cursor = Cursor.getDefaultCursor();
        if (id == 503) {
            if (PaletteToolWindowManager.getInstance(this.myEditor).getActiveItem(ComponentItem.class) != null) {
                if (this.myInsertFeedbackEnabled) {
                    cursor = this.myInsertComponentProcessor.processMouseMoveEvent(e);
                }
            } else if (this.myCurrentProcessor != null) {
                this.myCurrentProcessor.processMouseEvent(e);
            } else {
                RadComponent component = FormEditingUtil.getRadComponentAt(this.myEditor.getRootContainer(), e.getX(), e.getY());
                if (component != null) {
                    Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), component.getDelegee());
                    int resizeMask = Painter.getResizeMask(component, point.x, point.y);
                    if (resizeMask != 0) {
                        cursor = Cursor.getPredefinedCursor(Painter.getResizeCursor(resizeMask));
                    }
                    this.updateDragger(e);
                }
            }
        } else if (id == 501) {
            this.processMousePressed(e);
        } else if (id == 502) {
            if (this.myCurrentProcessor != null) {
                this.myCurrentProcessor.processMouseEvent(e);
                this.myCurrentProcessor = null;
            }
        } else if (id == 500) {
            this.processMouseClicked(e);
        } else if (id == 505) {
            this.myEditor.getActiveDecorationLayer().removeFeedback();
        }
        if (!e.isConsumed() && this.myCurrentProcessor != null) {
            this.myCurrentProcessor.processMouseEvent(e);
        }
        if (this.myCurrentProcessor != null && this.myCurrentProcessor.isDragActive()) {
            this.myEditor.getLayeredPane().setCursor(null);
        } else {
            if (this.myCurrentProcessor != null && this.myCurrentProcessor.getCursor() != null) {
                cursor = this.myCurrentProcessor.getCursor();
            }
            this.myEditor.getLayeredPane().setCursor(cursor);
        }
    }

    private void updateDragger(MouseEvent e) {
        RadComponent component = FormEditingUtil.getRadComponentAt(this.myEditor.getRootContainer(), e.getX(), e.getY());
        LOG.assertTrue(component != null);
        RadComponent oldDraggerHost = FormEditingUtil.getDraggerHost(this.myEditor);
        RadComponent newDraggerHost = null;
        for (RadComponent c = component; c != null && !(c instanceof RadRootContainer); c = c.getParent()) {
            if (!c.isSelected()) continue;
            newDraggerHost = c;
            break;
        }
        boolean keepOldHost = false;
        if (oldDraggerHost != null && oldDraggerHost.isSelected()) {
            Point p = SwingUtilities.convertPoint(oldDraggerHost.getDelegee(), 0, 0, e.getComponent());
            int deltaX = e.getX() - p.x;
            int deltaY = e.getY() - p.y;
            if (deltaX > -10 && deltaX < oldDraggerHost.getWidth() && deltaY > -10 && deltaY < oldDraggerHost.getHeight()) {
                keepOldHost = true;
                newDraggerHost = null;
            }
        }
        boolean shouldRepaint = false;
        if (oldDraggerHost != null && !keepOldHost && oldDraggerHost != newDraggerHost) {
            oldDraggerHost.setDragger(false);
            shouldRepaint = true;
        }
        if (newDraggerHost != null) {
            newDraggerHost.setDragger(true);
            shouldRepaint = true;
        }
        if (shouldRepaint) {
            this.myEditor.repaintLayeredPane();
        }
    }

    private void removeDragger() {
        RadComponent oldDraggerHost = FormEditingUtil.getDraggerHost(this.myEditor);
        if (oldDraggerHost != null) {
            oldDraggerHost.setDragger(false);
            this.myEditor.repaintLayeredPane();
        }
    }

    private void processMousePressed(MouseEvent e) {
        if (this.myCurrentProcessor != null) {
            if (this.myCurrentProcessor.needMousePressed()) {
                this.myCurrentProcessor.processMouseEvent(e);
                return;
            }
            this.myCurrentProcessor.cancelOperation();
            this.myCurrentProcessor = null;
        }
        RadComponent component = null;
        RadComponent draggerHost = FormEditingUtil.getDraggerHost(this.myEditor);
        if (draggerHost != null) {
            JComponent delegee = draggerHost.getDelegee();
            Point p = SwingUtilities.convertPoint(delegee, 0, 0, e.getComponent());
            if (p.x - 10 <= e.getX() && e.getX() <= p.x && p.y - 10 <= e.getY() && e.getY() <= p.y) {
                component = draggerHost;
            }
        }
        if (component == null) {
            component = FormEditingUtil.getRadComponentAt(this.myEditor.getRootContainer(), e.getX(), e.getY());
        }
        if (component == null) {
            return;
        }
        ComponentItem selectedItem = PaletteToolWindowManager.getInstance(this.myEditor).getActiveItem(ComponentItem.class);
        if (selectedItem != null) {
            this.myInsertComponentProcessor.setSticky(UIUtil.isControlKeyDown((MouseEvent)e));
            this.myCurrentProcessor = this.myInsertComponentProcessor;
            return;
        }
        if (!(UIUtil.isControlKeyDown((MouseEvent)e) || e.isShiftDown() || component.isSelected() && FormEditingUtil.getSelectedComponents(this.myEditor).size() == 1)) {
            FormEditingUtil.selectSingleComponent(this.myEditor, component);
        }
        Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), component.getDelegee());
        int resizeMask = Painter.getResizeMask(component, point.x, point.y);
        LOG.debug("MainProcessor.processMousePressed: resizeMask at (" + point.x + "," + point.y + ") is " + resizeMask);
        if (resizeMask != 0) {
            if (component.getParent() != null) {
                component = component.getParent().getActionTargetComponent(component);
            }
            this.myCurrentProcessor = new ResizeProcessor(this.myEditor, component, resizeMask);
        } else if (component instanceof RadRootContainer || e.isShiftDown()) {
            this.myCurrentProcessor = new GroupSelectionProcessor(this.myEditor, component);
        } else if (!e.isShiftDown()) {
            this.myCurrentProcessor = new DragSelectionProcessor(this.myEditor);
        }
        this.updateDragger(e);
    }

    private void processMouseClicked(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        this.myEditor.getInplaceEditingLayer().startInplaceEditing(e.getX(), e.getY());
    }

    @Override
    protected boolean cancelOperation() {
        if (this.myCurrentProcessor != null) {
            if (this.myCurrentProcessor.cancelOperation()) {
                this.myCurrentProcessor = null;
                this.myEditor.getLayeredPane().setCursor(Cursor.getDefaultCursor());
                this.myEditor.getActiveDecorationLayer().removeFeedback();
                return true;
            }
        } else if (PaletteToolWindowManager.getInstance(this.myEditor).getActiveItem(ComponentItem.class) != null) {
            this.cancelPaletteInsert();
            return true;
        }
        return false;
    }

    void cancelPaletteInsert() {
        PaletteToolWindowManager.getInstance(this.myEditor).clearActiveItem();
        this.myEditor.getLayeredPane().setCursor(Cursor.getDefaultCursor());
        this.myEditor.getActiveDecorationLayer().removeFeedback();
    }

    public void setInsertFeedbackEnabled(boolean enabled) {
        this.myInsertFeedbackEnabled = enabled;
    }

    public void startPasteProcessor(ArrayList<RadComponent> componentsToPaste, IntList xs, IntList ys) {
        this.removeDragger();
        this.myEditor.hideIntentionHint();
        this.myCurrentProcessor = new PasteProcessor(this.myEditor, componentsToPaste, xs, ys);
        this.myCurrentProcessor.processMouseEvent(new MouseEvent(this.myEditor, 503, 0L, 0, this.myLastMousePosition.x, this.myLastMousePosition.y, 1, false));
    }

    public void startInsertProcessor(@NotNull ComponentItem componentToInsert, ComponentDropLocation location) {
        if (componentToInsert == null) {
            MainProcessor.$$$reportNull$$$0(1);
        }
        this.removeDragger();
        this.myEditor.hideIntentionHint();
        this.myInsertComponentProcessor.setComponentToInsert(componentToInsert);
        this.myInsertComponentProcessor.setLastLocation(location);
        this.myCurrentProcessor = this.myInsertComponentProcessor;
    }

    public void stopCurrentProcessor() {
        this.myCurrentProcessor = null;
        this.myEditor.getLayeredPane().setCursor(null);
    }

    public boolean isProcessorActive() {
        return this.myCurrentProcessor != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentToInsert";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/designSurface/MainProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "startInsertProcessor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

