/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.action.delombok;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.action.delombok.DelombokHandler;
import de.plushnikov.intellij.plugin.util.LombokLibraryUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDelombokAction
extends AnAction {
    private DelombokHandler myHandler;

    protected AbstractDelombokAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AbstractDelombokAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    protected abstract DelombokHandler createHandler();

    private DelombokHandler getHandler() {
        if (null == this.myHandler) {
            this.myHandler = this.createHandler();
        }
        return this.myHandler;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            AbstractDelombokAction.$$$reportNull$$$0(1);
        }
        if ((project = event.getProject()) == null) {
            return;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitAllDocuments();
        DataContext dataContext = event.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (null != editor) {
            PsiClass targetClass;
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            if (null != psiFile && null != (targetClass = AbstractDelombokAction.getTargetClass(editor, psiFile))) {
                this.process(project, psiFile, targetClass);
            }
        } else {
            VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            if (null != files) {
                for (VirtualFile file : files) {
                    if (file.isDirectory()) {
                        this.processDirectory(project, file);
                        continue;
                    }
                    this.processFile(project, file);
                }
            }
        }
    }

    private void processDirectory(final @NotNull Project project, @NotNull VirtualFile vFile) {
        if (project == null) {
            AbstractDelombokAction.$$$reportNull$$$0(2);
        }
        if (vFile == null) {
            AbstractDelombokAction.$$$reportNull$$$0(3);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file.isDirectory()) {
                    AbstractDelombokAction.this.processFile(project, file);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "de/plushnikov/intellij/plugin/action/delombok/AbstractDelombokAction$1", "visitFile"));
            }
        });
    }

    private void processFile(Project project, VirtualFile file) {
        PsiManager psiManager;
        PsiJavaFile psiFile;
        if (JavaFileType.INSTANCE.equals(file.getFileType()) && (psiFile = (PsiJavaFile)(psiManager = PsiManager.getInstance((Project)project)).findFile(file)) != null) {
            this.process(project, psiFile);
        }
    }

    protected void process(@NotNull Project project, @NotNull PsiJavaFile psiJavaFile) {
        if (project == null) {
            AbstractDelombokAction.$$$reportNull$$$0(4);
        }
        if (psiJavaFile == null) {
            AbstractDelombokAction.$$$reportNull$$$0(5);
        }
        this.executeCommand(project, () -> this.getHandler().invoke(project, psiJavaFile));
    }

    protected void process(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiClass psiClass) {
        if (project == null) {
            AbstractDelombokAction.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            AbstractDelombokAction.$$$reportNull$$$0(7);
        }
        if (psiClass == null) {
            AbstractDelombokAction.$$$reportNull$$$0(8);
        }
        this.executeCommand(project, () -> this.getHandler().invoke(project, psiFile, psiClass));
    }

    private void executeCommand(Project project, Runnable action) {
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(action), this.getCommandName(), null);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            AbstractDelombokAction.$$$reportNull$$$0(9);
        }
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = event.getProject();
        if (project == null || !LombokLibraryUtil.hasLombokLibrary(project)) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (null != editor) {
            PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            presentation.setEnabled(file != null && this.isValidForFile(editor, file));
            return;
        }
        boolean isValid = false;
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (null != files) {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            for (VirtualFile file : files) {
                PsiJavaFile psiFile;
                if (file.isDirectory()) {
                    isValid = true;
                    break;
                }
                if (JavaFileType.INSTANCE.equals(file.getFileType()) && (psiFile = (PsiJavaFile)psiManager.findFile(file)) != null) {
                    isValid = ContainerUtil.or((Object[])psiFile.getClasses(), this::isValidForClass);
                }
                if (isValid) break;
            }
        }
        presentation.setEnabled(isValid);
    }

    private boolean isValidForClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractDelombokAction.$$$reportNull$$$0(10);
        }
        if (psiClass.isInterface()) {
            return false;
        }
        Collection<PsiAnnotation> psiAnnotations = this.getHandler().collectProcessableAnnotations(psiClass);
        if (!psiAnnotations.isEmpty()) {
            return true;
        }
        Collection<PsiClass> classesIntern = PsiClassUtil.collectInnerClassesIntern(psiClass);
        return classesIntern.stream().anyMatch(this::isValidForClass);
    }

    @Nullable
    private static PsiClass getTargetClass(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiClass target = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        return target instanceof SyntheticElement ? null : target;
    }

    private boolean isValidForFile(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            AbstractDelombokAction.$$$reportNull$$$0(11);
        }
        if (file == null) {
            AbstractDelombokAction.$$$reportNull$$$0(12);
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (file instanceof PsiCompiledElement) {
            return false;
        }
        if (!file.isWritable()) {
            return false;
        }
        PsiClass targetClass = AbstractDelombokAction.getTargetClass(editor, file);
        return targetClass != null && this.isValidForClass(targetClass);
    }

    @NlsContexts.Command
    private String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text == null ? "" : text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/action/delombok/AbstractDelombokAction";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiJavaFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/action/delombok/AbstractDelombokAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDirectory";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isValidForClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

