/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.lombokconfig;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumDataDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import de.plushnikov.intellij.plugin.language.LombokConfigFileType;
import de.plushnikov.intellij.plugin.language.psi.LombokConfigCleaner;
import de.plushnikov.intellij.plugin.language.psi.LombokConfigFile;
import de.plushnikov.intellij.plugin.language.psi.LombokConfigProperty;
import de.plushnikov.intellij.plugin.language.psi.LombokConfigPsiUtil;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigValue;
import de.plushnikov.intellij.plugin.lombokconfig.LombokConfigUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LombokConfigIndex
extends FileBasedIndexExtension<ConfigKey, ConfigValue> {
    @NonNls
    public static final ID<ConfigKey, ConfigValue> NAME = ID.create((String)"LombokConfigIndex");

    @NotNull
    public ID<ConfigKey, ConfigValue> getName() {
        ID<ConfigKey, ConfigValue> iD = NAME;
        if (iD == null) {
            LombokConfigIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<ConfigKey, ConfigValue, FileContent> getIndexer() {
        return new DataIndexer<ConfigKey, ConfigValue, FileContent>(){

            @NotNull
            public Map<ConfigKey, ConfigValue> map(@NotNull FileContent inputData) {
                String canonicalPath;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                Map result = Collections.emptyMap();
                VirtualFile directoryFile = inputData.getFile().getParent();
                if (null != directoryFile && null != (canonicalPath = PathUtil.toSystemIndependentName((String)directoryFile.getCanonicalPath()))) {
                    Map<String, String> configValues = this.extractValues((LombokConfigFile)inputData.getPsiFile());
                    boolean stopBubblingValue = Boolean.parseBoolean(configValues.get(ConfigKey.CONFIG_STOP_BUBBLING.getConfigKey()));
                    result = ContainerUtil.map2Map((Object[])ConfigKey.values(), key -> Pair.create((Object)key, (Object)new ConfigValue((String)configValues.get(key.getConfigKey()), stopBubblingValue)));
                }
                Map map = result;
                if (map == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map;
            }

            private Map<String, String> extractValues(LombokConfigFile configFile) {
                LombokConfigProperty[] configProperties;
                LombokConfigCleaner[] configCleaners;
                HashMap<String, String> result = new HashMap<String, String>();
                for (LombokConfigCleaner configCleaner : configCleaners = LombokConfigUtil.getLombokConfigCleaners(configFile)) {
                    String key = StringUtil.toLowerCase((String)LombokConfigPsiUtil.getKey(configCleaner));
                    ConfigKey configKey = ConfigKey.fromConfigStringKey(key);
                    if (null == configKey) continue;
                    result.put(key, configKey.getConfigDefaultValue());
                }
                for (LombokConfigProperty configProperty : configProperties = LombokConfigUtil.getLombokConfigProperties(configFile)) {
                    String key = StringUtil.toLowerCase((String)LombokConfigPsiUtil.getKey(configProperty));
                    String value = LombokConfigPsiUtil.getValue(configProperty);
                    String sign = LombokConfigPsiUtil.getSign(configProperty);
                    if (null == sign) {
                        result.put(key, value);
                        continue;
                    }
                    String previousValue = StringUtil.defaultIfEmpty((String)((String)result.get(key)), (String)"");
                    String combinedValue = previousValue + sign + value + ";";
                    result.put(key, combinedValue);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "de/plushnikov/intellij/plugin/lombokconfig/LombokConfigIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "de/plushnikov/intellij/plugin/lombokconfig/LombokConfigIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public KeyDescriptor<ConfigKey> getKeyDescriptor() {
        return new EnumDataDescriptor(ConfigKey.class);
    }

    @NotNull
    public DataExternalizer<ConfigValue> getValueExternalizer() {
        return new DataExternalizer<ConfigValue>(){

            public void save(@NotNull DataOutput out, ConfigValue configValue) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean isNotNullValue = configValue.getValue() != null;
                out.writeBoolean(isNotNullValue);
                if (isNotNullValue) {
                    EnumeratorStringDescriptor.INSTANCE.save(out, configValue.getValue());
                }
                out.writeBoolean(configValue.isStopBubbling());
            }

            public ConfigValue read(@NotNull DataInput in) throws IOException {
                boolean isNotNullValue;
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                return new ConfigValue((isNotNullValue = in.readBoolean()) ? EnumeratorStringDescriptor.INSTANCE.read(in) : null, in.readBoolean());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "de/plushnikov/intellij/plugin/lombokconfig/LombokConfigIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{LombokConfigFileType.INSTANCE});
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 11;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/plushnikov/intellij/plugin/lombokconfig/LombokConfigIndex", "getName"));
    }
}

