/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PatternConfigurationProducer
extends AbstractPatternBasedConfigurationProducer<JUnitConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = JUnitConfigurationType.getInstance().getFactory();
        if (configurationFactory == null) {
            PatternConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected String getMethodPresentation(PsiMember psiMember) {
        return psiMember instanceof PsiMethod ? JUnitConfiguration.Data.getMethodPresentation((PsiMethod)psiMember) : super.getMethodPresentation(psiMember);
    }

    protected boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        String paramSetName;
        GlobalSearchScope resolveScope;
        LinkedHashSet<String> classes;
        PsiElement element;
        if (configuration == null) {
            PatternConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PatternConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            PatternConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((element = this.checkPatterns(context, classes = new LinkedHashSet<String>())) == null) {
            return false;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)context.getProject());
        if (psiFacade.findClass("junit.framework.TestCase", resolveScope = element.getResolveScope()) == null && psiFacade.findClass("org.junit.jupiter.api.Test", resolveScope) == null) {
            return false;
        }
        sourceElement.set((Object)element);
        JUnitConfiguration.Data data = configuration.getPersistentData();
        data.setPatterns(classes);
        data.TEST_OBJECT = "pattern";
        data.setScope(this.setupPackageConfiguration(context, (ModuleBasedConfiguration)configuration, data.getScope()));
        configuration.setGeneratedName();
        Location contextLocation = context.getLocation();
        if (contextLocation instanceof PsiMemberParameterizedLocation && (paramSetName = ((PsiMemberParameterizedLocation)contextLocation).getParamSetName()) != null) {
            configuration.setProgramParameters(paramSetName);
        }
        return true;
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return "pattern".equals(type);
    }

    protected Module findModule(JUnitConfiguration configuration, Module contextModule) {
        Set<String> patterns = configuration.getPersistentData().getPatterns();
        return this.findModule((ModuleBasedConfiguration)configuration, contextModule, patterns);
    }

    public boolean isConfigurationFromContext(@NotNull JUnitConfiguration unitConfiguration, @NotNull ConfigurationContext context) {
        if (unitConfiguration == null) {
            PatternConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PatternConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (!this.isApplicableTestType(unitConfiguration.getTestType(), context)) {
            return false;
        }
        if (this.differentParamSet((JavaTestConfigurationBase)unitConfiguration, context.getLocation())) {
            return false;
        }
        Set<String> patterns = unitConfiguration.getPersistentData().getPatterns();
        return this.isConfiguredFromContext(context, patterns);
    }

    protected boolean isRequiredVisibility(PsiMember psiElement) {
        if (JUnitUtil.isJUnit5((PsiElement)psiElement)) {
            return true;
        }
        return super.isRequiredVisibility(psiElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit/PatternConfigurationProducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit/PatternConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

