/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree.workspace;

import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.bridgeEntities.ExtensionsKt;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.JavaResourceRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.JavaSourceRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.SourceRootEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportData;
import org.jetbrains.idea.maven.importing.tree.workspace.ContentRootCollector;
import org.jetbrains.idea.maven.importing.tree.workspace.ContentRootDataHolder;
import org.jetbrains.idea.maven.importing.tree.workspace.GeneratedFoldersHolder;
import org.jetbrains.idea.maven.importing.tree.workspace.SourceFolder;
import org.jetbrains.idea.maven.importing.tree.workspace.WorkspaceFolderImporter$WhenMappings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J.\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f2\b\u0010 \u001a\u0004\u0018\u00010!J6\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J6\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f2\b\u0010(\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030+0*2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/idea/maven/importing/tree/workspace/WorkspaceFolderImporter;", "", "builder", "Lcom/intellij/workspaceModel/storage/MutableEntityStorage;", "virtualFileUrlManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "importingSettings", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings;", "(Lcom/intellij/workspaceModel/storage/MutableEntityStorage;Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;Lorg/jetbrains/idea/maven/project/MavenImportingSettings;)V", "addAllSubDirsAsGeneratedSources", "", "dir", "Ljava/io/File;", "rootType", "", "contentRootEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ContentRootEntity;", "addAsGeneratedSourceFolder", "addGeneratedJavaSourceFolder", "path", "addSourceRootFolder", "sourceFolder", "Lorg/jetbrains/idea/maven/importing/tree/workspace/SourceFolder;", "configGeneratedSourceFolder", "targetDir", "createContentRoots", "module", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleEntity;", "importData", "Lorg/jetbrains/idea/maven/importing/tree/MavenModuleImportData;", "excludedFolders", "", "generatedFolders", "Lorg/jetbrains/idea/maven/importing/tree/workspace/GeneratedFoldersHolder;", "createContentRootForTarget", "", "getBaseContentRoot", "getContentRootsData", "", "Lorg/jetbrains/idea/maven/importing/tree/workspace/ContentRootDataHolder;", "generatedFoldersHolder", "getFolderItemMap", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "intellij.maven"})
public final class WorkspaceFolderImporter {
    private final MutableEntityStorage builder;
    private final VirtualFileUrlManager virtualFileUrlManager;
    private final MavenImportingSettings importingSettings;

    public final void createContentRoots(@NotNull ModuleEntity module, @NotNull MavenModuleImportData importData, @NotNull List<String> excludedFolders, @Nullable GeneratedFoldersHolder generatedFolders) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)importData, (String)"importData");
        Intrinsics.checkNotNullParameter(excludedFolders, (String)"excludedFolders");
        this.createContentRoots(module, importData, excludedFolders, generatedFolders, false);
    }

    /*
     * WARNING - void declaration
     */
    public final void createContentRoots(@NotNull ModuleEntity module, @NotNull MavenModuleImportData importData, @NotNull List<String> excludedFolders, @Nullable GeneratedFoldersHolder generatedFolders, boolean createContentRootForTarget) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)importData, (String)"importData");
        Intrinsics.checkNotNullParameter(excludedFolders, (String)"excludedFolders");
        Collection<ContentRootDataHolder> contentRootDataHolders = this.getContentRootsData(importData, excludedFolders, generatedFolders, createContentRootForTarget);
        for (ContentRootDataHolder dataHolder : contentRootDataHolders) {
            Collection<VirtualFileUrl> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = dataHolder.getExcludedPaths();
            VirtualFileUrl virtualFileUrl = this.virtualFileUrlManager.fromPath(dataHolder.getContentRoot());
            MutableEntityStorage mutableEntityStorage = this.builder;
            boolean $i$f$map = false;
            void var12_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                VirtualFileUrl virtualFileUrl2 = this.virtualFileUrlManager.fromPath((String)it);
                collection.add(virtualFileUrl2);
            }
            collection = (List)destination$iv$iv;
            ContentRootEntity contentRootEntity = ExtensionsKt.addContentRootEntity((MutableEntityStorage)mutableEntityStorage, (VirtualFileUrl)virtualFileUrl, (List)collection, (List)CollectionsKt.emptyList(), (ModuleEntity)module);
            for (SourceFolder sourceFolder : dataHolder.getSourceFolders()) {
                this.addSourceRootFolder(contentRootEntity, sourceFolder);
            }
            for (SourceFolder folder : dataHolder.getAnnotationProcessorFolders()) {
                this.addGeneratedJavaSourceFolder(folder.getPath(), folder.getRootType(), contentRootEntity);
            }
            for (SourceFolder folder : dataHolder.getGeneratedFolders()) {
                this.configGeneratedSourceFolder(new File(folder.getPath()), folder.getRootType(), contentRootEntity);
            }
        }
    }

    private final void addSourceRootFolder(ContentRootEntity contentRootEntity, SourceFolder sourceFolder) {
        String string = VfsUtilCore.pathToUrl((String)sourceFolder.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(sourceFolder.path)");
        SourceRootEntity sourceRootEntity = ExtensionsKt.addSourceRootEntity((MutableEntityStorage)this.builder, (ContentRootEntity)contentRootEntity, (VirtualFileUrl)this.virtualFileUrlManager.fromUrl(string), (String)sourceFolder.getRootType(), (EntitySource)contentRootEntity.getEntitySource());
        if (sourceFolder.isResource()) {
            ExtensionsKt.addJavaResourceRootEntity((MutableEntityStorage)this.builder, (SourceRootEntity)sourceRootEntity, (boolean)false, (String)"");
        } else {
            ExtensionsKt.addJavaSourceRootEntity((MutableEntityStorage)this.builder, (SourceRootEntity)sourceRootEntity, (boolean)false, (String)"");
        }
    }

    private final Collection<ContentRootDataHolder> getContentRootsData(MavenModuleImportData importData, List<String> excludedFolders, GeneratedFoldersHolder generatedFoldersHolder, boolean createContentRootForTarget) {
        String baseContentRoot = this.getBaseContentRoot(importData);
        Map<String, JpsModuleSourceRootType<?>> folderItemMap = this.getFolderItemMap(importData);
        return ContentRootCollector.collect(baseContentRoot, folderItemMap, excludedFolders, generatedFoldersHolder, createContentRootForTarget);
    }

    private final String getBaseContentRoot(MavenModuleImportData importData) {
        String string;
        switch (WorkspaceFolderImporter$WhenMappings.$EnumSwitchMapping$0[importData.getModuleData().getType().ordinal()]) {
            case 1: {
                string = ((Object)Path.of(importData.getMavenProject().getDirectory(), "src", "main")).toString();
                break;
            }
            case 2: {
                string = ((Object)Path.of(importData.getMavenProject().getDirectory(), "src", "test")).toString();
                break;
            }
            default: {
                string = ((Object)Path.of(importData.getMavenProject().getDirectory(), new String[0])).toString();
            }
        }
        return string;
    }

    private final Map<String, JpsModuleSourceRootType<?>> getFolderItemMap(MavenModuleImportData importData) {
        Map<String, JpsModuleSourceRootType<?>> map2;
        switch (WorkspaceFolderImporter$WhenMappings.$EnumSwitchMapping$1[importData.getModuleData().getType().ordinal()]) {
            case 1: {
                Map<String, JpsModuleSourceRootType<?>> map3 = MavenFoldersImporter.getMainSourceFolders(importData.getMavenProject());
                map2 = map3;
                Intrinsics.checkNotNullExpressionValue(map3, (String)"MavenFoldersImporter.get\u2026(importData.mavenProject)");
                break;
            }
            case 2: {
                Map<String, JpsModuleSourceRootType<?>> map4 = MavenFoldersImporter.getTestSourceFolders(importData.getMavenProject());
                map2 = map4;
                Intrinsics.checkNotNullExpressionValue(map4, (String)"MavenFoldersImporter.get\u2026(importData.mavenProject)");
                break;
            }
            case 3: {
                map2 = MapsKt.emptyMap();
                break;
            }
            case 4: {
                map2 = MapsKt.emptyMap();
                break;
            }
            default: {
                Map<String, JpsModuleSourceRootType<?>> map5 = MavenFoldersImporter.getSourceFolders(importData.getMavenProject());
                map2 = map5;
                Intrinsics.checkNotNullExpressionValue(map5, (String)"MavenFoldersImporter.get\u2026(importData.mavenProject)");
            }
        }
        return map2;
    }

    private final void addGeneratedJavaSourceFolder(String path, String rootType, ContentRootEntity contentRootEntity) {
        boolean bl;
        VirtualFileUrl url;
        block5: {
            String[] stringArray = new File(path).list();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            url = this.virtualFileUrlManager.fromPath(path);
            Iterable $this$any$iv = contentRootEntity.getSourceRoots();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SourceRootEntity it = (SourceRootEntity)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)url)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        SourceRootEntity sourceRootEntity = ExtensionsKt.addSourceRootEntity((MutableEntityStorage)this.builder, (ContentRootEntity)contentRootEntity, (VirtualFileUrl)url, (String)rootType, (EntitySource)contentRootEntity.getEntitySource());
        ExtensionsKt.addJavaSourceRootEntity((MutableEntityStorage)this.builder, (SourceRootEntity)sourceRootEntity, (boolean)true, (String)"");
    }

    private final void configGeneratedSourceFolder(File targetDir, String rootType, ContentRootEntity contentRootEntity) {
        switch (WorkspaceFolderImporter$WhenMappings.$EnumSwitchMapping$2[this.importingSettings.getGeneratedSourcesFolder().ordinal()]) {
            case 1: {
                String string = targetDir.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetDir.path");
                this.addGeneratedJavaSourceFolder(string, rootType, contentRootEntity);
                break;
            }
            case 2: {
                this.addAllSubDirsAsGeneratedSources(targetDir, rootType, contentRootEntity);
                break;
            }
            case 3: {
                Collection collection = JavaSourceRootDetectionUtil.suggestRoots((File)targetDir);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"JavaSourceRootDetectionU\u2026l.suggestRoots(targetDir)");
                Collection sourceRoots = collection;
                Iterator iterator = sourceRoots.iterator();
                while (iterator.hasNext()) {
                    JavaModuleSourceRoot root;
                    JavaModuleSourceRoot javaModuleSourceRoot = root = (JavaModuleSourceRoot)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)javaModuleSourceRoot, (String)"root");
                    if (FileUtil.filesEqual((File)targetDir, (File)javaModuleSourceRoot.getDirectory())) {
                        String string = targetDir.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetDir.path");
                        this.addGeneratedJavaSourceFolder(string, rootType, contentRootEntity);
                        return;
                    }
                    File file = root.getDirectory();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"root.directory");
                    this.addAsGeneratedSourceFolder(file, rootType, contentRootEntity);
                }
                this.addAllSubDirsAsGeneratedSources(targetDir, rootType, contentRootEntity);
                break;
            }
            case 4: {
                break;
            }
        }
    }

    private final void addAsGeneratedSourceFolder(File dir2, String rootType, ContentRootEntity contentRootEntity) {
        block9: {
            block8: {
                boolean hasRegisteredSubfolder;
                SourceRootEntity folder;
                block7: {
                    boolean bl;
                    Object v1;
                    String url;
                    block6: {
                        Iterable iterable;
                        String string = VfsUtilCore.fileToUrl((File)dir2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.fileToUrl(dir)");
                        url = string;
                        Iterable iterable2 = iterable = (Iterable)contentRootEntity.getSourceRoots();
                        for (Object object : iterable2) {
                            SourceRootEntity it = (SourceRootEntity)object;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getUrl().getUrl(), (Object)url)) continue;
                            v1 = object;
                            break block6;
                        }
                        v1 = null;
                    }
                    folder = v1;
                    Iterable $this$any$iv = contentRootEntity.getSourceRoots();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            SourceRootEntity it = (SourceRootEntity)element$iv;
                            boolean bl3 = false;
                            if (!VfsUtilCore.isEqualOrAncestor((String)url, (String)it.getUrl().getUrl())) continue;
                            bl = true;
                            break block7;
                        }
                        bl = hasRegisteredSubfolder = false;
                    }
                }
                if (!hasRegisteredSubfolder) break block8;
                if (folder == null) break block9;
                JavaSourceRootEntity javaSourceRootEntity = ExtensionsKt.asJavaSourceRoot((SourceRootEntity)folder);
                if (javaSourceRootEntity != null && javaSourceRootEntity.getGenerated()) break block8;
                JavaResourceRootEntity javaResourceRootEntity = ExtensionsKt.asJavaResourceRoot((SourceRootEntity)folder);
                if (javaResourceRootEntity == null) break block9;
                if (!javaResourceRootEntity.getGenerated()) break block9;
            }
            String string = dir2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dir.path");
            this.addGeneratedJavaSourceFolder(string, rootType, contentRootEntity);
        }
    }

    private final void addAllSubDirsAsGeneratedSources(File dir2, String rootType, ContentRootEntity contentRootEntity) {
        File[] fileArray = dir2.listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File f = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                File file = f;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"f");
                if (!file.isDirectory()) continue;
                this.addAsGeneratedSourceFolder(f, rootType, contentRootEntity);
            }
        }
    }

    public WorkspaceFolderImporter(@NotNull MutableEntityStorage builder, @NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull MavenImportingSettings importingSettings) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter((Object)importingSettings, (String)"importingSettings");
        this.builder = builder;
        this.virtualFileUrlManager = virtualFileUrlManager;
        this.importingSettings = importingSettings;
    }
}

