/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.execution.MavenRCSettingsWatcher;
import org.jetbrains.idea.maven.execution.MavenSettingsObservable;
import org.jetbrains.idea.maven.project.MavenEnvironmentForm;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.utils.ComboBoxUtil;

public class MavenGeneralPanel
implements PanelWithAnchor,
MavenSettingsObservable {
    private JCheckBox checkboxWorkOffline;
    private JPanel panel;
    private JComboBox outputLevelCombo;
    private JCheckBox checkboxProduceExceptionErrorMessages;
    private JComboBox checksumPolicyCombo;
    private JComboBox failPolicyCombo;
    private JCheckBox checkboxUsePluginRegistry;
    private JCheckBox checkboxRecursive;
    private MavenEnvironmentForm mavenPathsForm;
    private JBLabel myMultiProjectBuildFailPolicyLabel;
    private JCheckBox alwaysUpdateSnapshotsCheckBox;
    private JTextField threadsEditor;
    private final DefaultComboBoxModel outputLevelComboModel;
    private final DefaultComboBoxModel checksumPolicyComboModel;
    private final DefaultComboBoxModel failPolicyComboModel;
    private final DefaultComboBoxModel pluginUpdatePolicyComboModel;
    private JComponent anchor;
    private JCheckBox showDialogWithAdvancedSettingsCheckBox;
    private JCheckBox useMavenConfigCheckBox;
    private JBLabel mavenConfigWarningLabel;
    private boolean isShowAdvancedSettingsCheckBox;
    private MavenGeneralSettings myInitialSettings;

    public MavenGeneralPanel() {
        this.$$$setupUI$$$();
        this.outputLevelComboModel = new DefaultComboBoxModel();
        this.checksumPolicyComboModel = new DefaultComboBoxModel();
        this.failPolicyComboModel = new DefaultComboBoxModel();
        this.pluginUpdatePolicyComboModel = new DefaultComboBoxModel();
        this.isShowAdvancedSettingsCheckBox = false;
        this.fillOutputLevelCombobox();
        this.fillChecksumPolicyCombobox();
        this.fillFailureBehaviorCombobox();
        this.fillUseMavenConfigGroup();
        this.setAnchor((JComponent)this.myMultiProjectBuildFailPolicyLabel);
    }

    private void fillOutputLevelCombobox() {
        ComboBoxUtil.setModel(this.outputLevelCombo, this.outputLevelComboModel, Arrays.asList(MavenExecutionOptions.LoggingLevel.values()), each -> Pair.create((Object)each.getDisplayString(), (Object)each));
    }

    private void fillFailureBehaviorCombobox() {
        ComboBoxUtil.setModel(this.failPolicyCombo, this.failPolicyComboModel, Arrays.asList(MavenExecutionOptions.FailureMode.values()), each -> Pair.create((Object)each.getDisplayString(), (Object)each));
    }

    private void fillChecksumPolicyCombobox() {
        ComboBoxUtil.setModel(this.checksumPolicyCombo, this.checksumPolicyComboModel, Arrays.asList(MavenExecutionOptions.ChecksumPolicy.values()), each -> Pair.create((Object)each.getDisplayString(), (Object)each));
    }

    private void fillUseMavenConfigGroup() {
        this.mavenConfigWarningLabel.setIcon(AllIcons.General.BalloonWarning12);
        this.mavenConfigWarningLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.mavenConfigWarningLabel.setVerticalTextPosition(1);
        this.mavenConfigWarningLabel.setVisible(false);
    }

    public void showCheckBoxWithAdvancedSettings() {
        this.isShowAdvancedSettingsCheckBox = true;
    }

    public JComponent createComponent() {
        this.showDialogWithAdvancedSettingsCheckBox.setVisible(this.isShowAdvancedSettingsCheckBox);
        this.mavenPathsForm.createComponent();
        return this.panel;
    }

    protected void setData(MavenGeneralSettings data) {
        data.beginUpdate();
        data.setWorkOffline(this.checkboxWorkOffline.isSelected());
        this.mavenPathsForm.setData(data);
        data.setPrintErrorStackTraces(this.checkboxProduceExceptionErrorMessages.isSelected());
        data.setUsePluginRegistry(this.checkboxUsePluginRegistry.isSelected());
        data.setNonRecursive(!this.checkboxRecursive.isSelected());
        data.setOutputLevel((MavenExecutionOptions.LoggingLevel)((Object)ComboBoxUtil.getSelectedValue(this.outputLevelComboModel)));
        data.setChecksumPolicy((MavenExecutionOptions.ChecksumPolicy)((Object)ComboBoxUtil.getSelectedValue(this.checksumPolicyComboModel)));
        data.setFailureBehavior((MavenExecutionOptions.FailureMode)((Object)ComboBoxUtil.getSelectedValue(this.failPolicyComboModel)));
        data.setPluginUpdatePolicy((MavenExecutionOptions.PluginUpdatePolicy)((Object)ComboBoxUtil.getSelectedValue(this.pluginUpdatePolicyComboModel)));
        data.setAlwaysUpdateSnapshots(this.alwaysUpdateSnapshotsCheckBox.isSelected());
        data.setThreads(this.threadsEditor.getText());
        data.setShowDialogWithAdvancedSettings(this.showDialogWithAdvancedSettingsCheckBox.isSelected());
        data.setUseMavenConfig(this.useMavenConfigCheckBox.isSelected());
        data.endUpdate();
        this.mavenConfigWarningLabel.setVisible(this.useMavenConfigCheckBox.isSelected() && this.isModifiedNotOverridableData(data));
    }

    protected void initializeFormData(MavenGeneralSettings data, Project project2) {
        this.myInitialSettings = data;
        this.checkboxWorkOffline.setSelected(data.isWorkOffline());
        this.mavenPathsForm.initializeFormData(data, project2);
        this.checkboxProduceExceptionErrorMessages.setSelected(data.isPrintErrorStackTraces());
        this.checkboxUsePluginRegistry.setSelected(data.isUsePluginRegistry());
        this.checkboxRecursive.setSelected(!data.isNonRecursive());
        this.alwaysUpdateSnapshotsCheckBox.setSelected(data.isAlwaysUpdateSnapshots());
        this.threadsEditor.setText(StringUtil.notNullize((String)data.getThreads()));
        ComboBoxUtil.select(this.outputLevelComboModel, (Object)data.getOutputLevel());
        ComboBoxUtil.select(this.checksumPolicyComboModel, (Object)data.getChecksumPolicy());
        ComboBoxUtil.select(this.failPolicyComboModel, (Object)data.getFailureBehavior());
        ComboBoxUtil.select(this.pluginUpdatePolicyComboModel, (Object)data.getPluginUpdatePolicy());
        this.showDialogWithAdvancedSettingsCheckBox.setSelected(data.isShowDialogWithAdvancedSettings());
        this.useMavenConfigCheckBox.setSelected(data.isUseMavenConfig());
    }

    @Nls
    public String getDisplayName() {
        return CommonBundle.message((String)"tab.title.general", (Object[])new Object[0]);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myMultiProjectBuildFailPolicyLabel.setAnchor(anchor);
        this.mavenPathsForm.setAnchor(anchor);
    }

    @ApiStatus.Internal
    public void applyTargetEnvironmentConfiguration(@NotNull Project project2, @Nullable String targetName) {
        if (project2 == null) {
            MavenGeneralPanel.$$$reportNull$$$0(0);
        }
        this.mavenPathsForm.apply(project2, targetName);
    }

    @Override
    public void registerSettingsWatcher(@NotNull MavenRCSettingsWatcher watcher) {
        if (watcher == null) {
            MavenGeneralPanel.$$$reportNull$$$0(1);
        }
        watcher.registerComponent("workOffline", this.checkboxWorkOffline);
        this.mavenPathsForm.registerSettingsWatcher(watcher);
        watcher.registerComponent("produceExceptionErrorMessages", this.checkboxProduceExceptionErrorMessages);
        watcher.registerComponent("usePluginRegistry", this.checkboxUsePluginRegistry);
        watcher.registerComponent("recursive", this.checkboxRecursive);
        watcher.registerComponent("alwaysUpdateSnapshots", this.alwaysUpdateSnapshotsCheckBox);
        watcher.registerComponent("threadsEditor", this.threadsEditor);
        watcher.registerComponent("outputLevel", this.outputLevelCombo);
        watcher.registerComponent("checksumPolicy", this.checksumPolicyCombo);
        watcher.registerComponent("failPolicy", this.failPolicyCombo);
        watcher.registerComponent("showDialogWithAdvancedSettings", this.showDialogWithAdvancedSettingsCheckBox);
        watcher.registerComponent("useMavenConfigCheckBox", this.useMavenConfigCheckBox);
    }

    private boolean isModifiedNotOverridableData(MavenGeneralSettings data) {
        return !Objects.equals(StringUtil.nullize((String)this.myInitialSettings.getThreads()), StringUtil.nullize((String)data.getThreads())) || !Objects.equals((Object)this.myInitialSettings.getChecksumPolicy(), (Object)data.getChecksumPolicy()) || !Objects.equals((Object)this.myInitialSettings.getFailureBehavior(), (Object)data.getFailureBehavior()) || !Objects.equals((Object)this.myInitialSettings.getOutputLevel(), (Object)data.getOutputLevel()) || !Objects.equals(this.myInitialSettings.isWorkOffline(), data.isWorkOffline()) || !Objects.equals(this.myInitialSettings.isPrintErrorStackTraces(), data.isPrintErrorStackTraces()) || !Objects.equals(this.myInitialSettings.isAlwaysUpdateSnapshots(), data.isAlwaysUpdateSnapshots()) || !Objects.equals(this.myInitialSettings.isNonRecursive(), data.isNonRecursive());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JCheckBox jCheckBox3;
        MavenEnvironmentForm mavenEnvironmentForm;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JComboBox jComboBox;
        JBLabel jBLabel2;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(14, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.output.level"));
        jPanel.add((Component)jLabel, new GridConstraints(6, 0, 1, 4, 8, 0, 0, 0, null, new Dimension(66, 23), null));
        this.outputLevelCombo = jComboBox3 = new JComboBox();
        jPanel.add(jComboBox3, new GridConstraints(6, 4, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.checksum.policy"));
        jPanel.add((Component)jLabel2, new GridConstraints(7, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.checksumPolicyCombo = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(7, 4, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myMultiProjectBuildFailPolicyLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.multiproject.build.policy"));
        jPanel.add((Component)jBLabel2, new GridConstraints(8, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.failPolicyCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(8, 4, 1, 1, 0, 1, 2, 0, null, null, null));
        this.checkboxWorkOffline = jCheckBox7 = new JCheckBox();
        jCheckBox7.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.work.offline"));
        jCheckBox7.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.general.work.offline.tooltip"));
        jPanel.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        this.checkboxUsePluginRegistry = jCheckBox6 = new JCheckBox();
        jCheckBox6.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.use.plugin.registry"));
        jCheckBox6.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.general.use.plugin.registry.tooltip"));
        jPanel.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        this.checkboxRecursive = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.execute.recursively"));
        jCheckBox5.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.general.execute.recursively.tooltip"));
        jPanel.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 6, 8, 0, 3, 0, null, new Dimension(185, 22), null));
        this.checkboxProduceExceptionErrorMessages = jCheckBox4 = new JCheckBox();
        jCheckBox4.setAlignmentY(0.5f);
        jCheckBox4.setMargin(new Insets(2, 0, 2, 0));
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.print.stacktraces"));
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.general.print.stacktraces.tooltip"));
        jPanel.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        this.mavenPathsForm = mavenEnvironmentForm = new MavenEnvironmentForm();
        JComponent jComponent = mavenEnvironmentForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(10, 0, 1, 6, 1, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        this.alwaysUpdateSnapshotsCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.update.snapshots"));
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.general.update.snapshots.tooltip"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(4, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setHorizontalAlignment(10);
        jBLabel3.setHorizontalTextPosition(11);
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.thread.count"));
        jBLabel3.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.general.thread.count.tooltip"));
        jPanel.add((Component)jBLabel3, new GridConstraints(9, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.threadsEditor = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(9, 4, 1, 1, 0, 1, 2, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.thread.count.note"));
        jPanel.add((Component)jBLabel4, new GridConstraints(9, 5, 1, 1, 8, 0, 0, 0, null, null, null));
        this.showDialogWithAdvancedSettingsCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.environment.show.advanced.settings"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.environment.show.advanced.settings.tooltip"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(5, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.useMavenConfigCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.environment.use.maven.config.settings"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.environment.use.maven.config.settings.tooltip"));
        jPanel.add((Component)jCheckBox, new GridConstraints(11, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(13, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(12, 0, 1, 6, 0, 3, 3, 3, null, null, null));
        this.mavenConfigWarningLabel = jBLabel = new JBLabel();
        jBLabel.setAutoscrolls(false);
        jBLabel.setFocusable(false);
        Font font = this.$$$getFont$$$(null, -1, -1, jBLabel.getFont());
        if (font != null) {
            jBLabel.setFont(font);
        }
        jBLabel.setHorizontalAlignment(10);
        jBLabel.setHorizontalTextPosition(11);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.environment.use.maven.config.settings.hint"));
        jBLabel.setToolTipText("");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor(jComboBox3);
        jLabel2.setLabelFor(jComboBox2);
        jBLabel2.setLabelFor(jComboBox);
        jBLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcher";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenGeneralPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTargetEnvironmentConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSettingsWatcher";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

