/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.importing;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.SyncViewManager;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.statistics.ProjectImportCollector;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.importing.MavenImportStats;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenResolveResultProblemProcessor;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.importing.FilesList;
import org.jetbrains.idea.maven.project.importing.ImportPaths;
import org.jetbrains.idea.maven.project.importing.MavenImportContext;
import org.jetbrains.idea.maven.project.importing.MavenImportFinishedContext;
import org.jetbrains.idea.maven.project.importing.MavenImportFlow;
import org.jetbrains.idea.maven.project.importing.MavenImportedContext;
import org.jetbrains.idea.maven.project.importing.MavenImportingManager;
import org.jetbrains.idea.maven.project.importing.MavenImportingResult;
import org.jetbrains.idea.maven.project.importing.MavenInitialImportContext;
import org.jetbrains.idea.maven.project.importing.MavenPluginResolvedContext;
import org.jetbrains.idea.maven.project.importing.MavenReadContext;
import org.jetbrains.idea.maven.project.importing.MavenResolvedContext;
import org.jetbrains.idea.maven.project.importing.MavenStartedImport;
import org.jetbrains.idea.maven.project.importing.RootPath;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 Z2\u00020\u0001:\u0001ZB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002JF\u0010)\u001a\u0002H*\"\b\b\u0000\u0010**\u00020\r2\u000b\u0010+\u001a\u00070,\u00a2\u0006\u0002\b-2\u0006\u0010.\u001a\u00020/2\n\u00100\u001a\u0006\u0012\u0002\b\u0003012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H*03H\u0002\u00a2\u0006\u0002\u00104J\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020!08H\u0007J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0006\u0010:\u001a\u00020;J\b\u0010<\u001a\u00020;H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0007J\u0010\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u00020CH\u0007J(\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010'\u001a\u00020(H\u0007J\u001e\u0010H\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\f\u00102\u001a\b\u0012\u0004\u0012\u00020!03H\u0002J\u000e\u0010I\u001a\u00020>2\u0006\u0010'\u001a\u00020(J*\u0010J\u001a\u00020>2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020@0L2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020@0L2\u0006\u0010'\u001a\u00020(J\u0010\u0010N\u001a\u0002062\u0006\u0010O\u001a\u00020&H\u0002J$\u0010P\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030Q0L032\n\u0010R\u001a\u0006\u0012\u0002\b\u000301H\u0002J'\u0010S\u001a\u0002HT\"\u0004\b\u0000\u0010T2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002HT0VH\u0002\u00a2\u0006\u0002\u0010WJ;\u0010S\u001a\u0002HT\"\u0004\b\u0000\u0010T2\u0006\u0010X\u001a\u00020/2\n\u0010R\u001a\u0006\u0012\u0002\b\u0003012\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002HT0VH\u0002\u00a2\u0006\u0002\u0010YR#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0018\u001a\u0004\u0018\u00010\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000b\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lorg/jetbrains/idea/maven/project/importing/MavenImportingManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "console", "Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "kotlin.jvm.PlatformType", "getConsole", "()Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "console$delegate", "Lkotlin/Lazy;", "value", "Lorg/jetbrains/idea/maven/project/importing/MavenImportContext;", "currentContext", "getCurrentContext", "()Lorg/jetbrains/idea/maven/project/importing/MavenImportContext;", "setCurrentContext", "(Lorg/jetbrains/idea/maven/project/importing/MavenImportContext;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "executor", "Ljava/util/concurrent/ExecutorService;", "mavenPluginInfo", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "getMavenPluginInfo", "()Lcom/intellij/internal/statistic/utils/PluginInfo;", "mavenPluginInfo$delegate", "getProject", "()Lcom/intellij/openapi/project/Project;", "waitingPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lorg/jetbrains/idea/maven/project/importing/MavenImportFinishedContext;", "doImport", "indicator", "Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;", "initialImport", "Lorg/jetbrains/idea/maven/project/importing/MavenInitialImportContext;", "spec", "Lorg/jetbrains/idea/maven/buildtool/MavenImportSpec;", "doTask", "Result", "message", "", "Lcom/intellij/build/events/BuildEventsNls$Message;", "parentActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "activityKlass", "Ljava/lang/Class;", "init", "Lkotlin/Function0;", "(Ljava/lang/String;Lcom/intellij/internal/statistic/StructuredIdeActivity;Ljava/lang/Class;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/idea/maven/project/importing/MavenImportContext;", "forceStopImport", "", "getImportFinishPromise", "Lorg/jetbrains/concurrency/Promise;", "getWaitingPromise", "isImportingInProgress", "", "isRecursiveImportCalledFromMavenProjectsManagerWatcher", "linkAndImportFile", "Lorg/jetbrains/idea/maven/project/importing/MavenImportingResult;", "pom", "Lcom/intellij/openapi/vfs/VirtualFile;", "openProjectAndImport", "importPaths", "Lorg/jetbrains/idea/maven/project/importing/ImportPaths;", "importingSettings", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings;", "generalSettings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "runSync", "scheduleImportAll", "scheduleUpdate", "filesToUpdate", "", "filesToDelete", "setProjectSettings", "initialImportContext", "withData", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "klass", "withStructuredIdeActivity", "T", "f", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "parent", "(Lcom/intellij/internal/statistic/StructuredIdeActivity;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "intellij.maven"})
@ApiStatus.Experimental
public final class MavenImportingManager {
    private final Disposable disposable;
    private final Lazy mavenPluginInfo$delegate;
    @Nullable
    private MavenImportContext currentContext;
    private final Lazy console$delegate;
    private final ExecutorService executor;
    private AsyncPromise<MavenImportFinishedContext> waitingPromise;
    @NotNull
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final PluginInfo getMavenPluginInfo() {
        Lazy lazy = this.mavenPluginInfo$delegate;
        MavenImportingManager mavenImportingManager = this;
        Object var3_3 = null;
        return (PluginInfo)lazy.getValue();
    }

    @Nullable
    public final MavenImportContext getCurrentContext() {
        return this.currentContext;
    }

    private final void setCurrentContext(MavenImportContext value) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isDispatchThread()) {
            this.currentContext = value;
        } else {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(this, value){
                final /* synthetic */ MavenImportingManager this$0;
                final /* synthetic */ MavenImportContext $value;

                public final void run() {
                    MavenImportingManager.access$setCurrentContext$lp(this.this$0, this.$value);
                }
                {
                    this.this$0 = mavenImportingManager;
                    this.$value = mavenImportContext;
                }
            });
        }
    }

    private final MavenSyncConsole getConsole() {
        Lazy lazy = this.console$delegate;
        MavenImportingManager mavenImportingManager = this;
        Object var3_3 = null;
        return (MavenSyncConsole)lazy.getValue();
    }

    @RequiresEdt
    @NotNull
    public final MavenImportingResult linkAndImportFile(@NotNull VirtualFile pom2) {
        Intrinsics.checkNotNullParameter((Object)pom2, (String)"pom");
        ApplicationManager.getApplication().assertIsDispatchThread();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.project);
        ImportPaths importPath = pom2.isDirectory() ? (ImportPaths)new RootPath(pom2) : (ImportPaths)new FilesList(pom2);
        MavenProjectsManager mavenProjectsManager = manager;
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"manager");
        MavenImportingSettings mavenImportingSettings = mavenProjectsManager.getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"manager.importingSettings");
        MavenGeneralSettings mavenGeneralSettings = manager.getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"manager.generalSettings");
        MavenImportSpec mavenImportSpec = MavenImportSpec.EXPLICIT_IMPORT;
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportSpec, (String)"MavenImportSpec.EXPLICIT_IMPORT");
        return this.openProjectAndImport(importPath, mavenImportingSettings, mavenGeneralSettings, mavenImportSpec);
    }

    @RequiresEdt
    @NotNull
    public final MavenImportingResult openProjectAndImport(@NotNull ImportPaths importPaths) {
        Intrinsics.checkNotNullParameter((Object)importPaths, (String)"importPaths");
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent = MavenWorkspaceSettingsComponent.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent, (String)"MavenWorkspaceSettingsCo\u2026nent.getInstance(project)");
        MavenWorkspaceSettings settings = mavenWorkspaceSettingsComponent.getSettings();
        MavenImportingSettings mavenImportingSettings = settings.getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"settings.getImportingSettings()");
        MavenGeneralSettings mavenGeneralSettings = settings.getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"settings.getGeneralSettings()");
        MavenImportSpec mavenImportSpec = MavenImportSpec.EXPLICIT_IMPORT;
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportSpec, (String)"MavenImportSpec.EXPLICIT_IMPORT");
        return this.openProjectAndImport(importPaths, mavenImportingSettings, mavenGeneralSettings, mavenImportSpec);
    }

    @RequiresEdt
    @NotNull
    public final MavenImportingResult openProjectAndImport(@NotNull ImportPaths importPaths, @NotNull MavenImportingSettings importingSettings, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenImportSpec spec) {
        Intrinsics.checkNotNullParameter((Object)importPaths, (String)"importPaths");
        Intrinsics.checkNotNullParameter((Object)importingSettings, (String)"importingSettings");
        Intrinsics.checkNotNullParameter((Object)generalSettings, (String)"generalSettings");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isImportingInProgress()) {
            return new MavenImportingResult((Promise<MavenImportFinishedContext>)((Promise)this.waitingPromise), null);
        }
        if (this.executor.isShutdown()) {
            throw (Throwable)new RuntimeException("Project is closing");
        }
        this.waitingPromise = new AsyncPromise();
        MavenUtil.setupProjectSdk(this.project);
        this.setCurrentContext(new MavenStartedImport(this.project));
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
        MavenExplicitProfiles mavenExplicitProfiles = mavenProjectsManager.getExplicitProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)mavenExplicitProfiles, (String)"MavenProjectsManager.get\u2026project).explicitProfiles");
        Collection enabledProfiles = mavenExplicitProfiles.getEnabledProfiles();
        MavenProjectsManager mavenProjectsManager2 = MavenProjectsManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager2, (String)"MavenProjectsManager.getInstance(project)");
        MavenExplicitProfiles mavenExplicitProfiles2 = mavenProjectsManager2.getExplicitProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)mavenExplicitProfiles2, (String)"MavenProjectsManager.get\u2026project).explicitProfiles");
        Collection disabledProfiles = mavenExplicitProfiles2.getDisabledProfiles();
        MavenImportFlow mavenImportFlow = new MavenImportFlow();
        Collection collection = enabledProfiles;
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"enabledProfiles");
        Collection collection2 = disabledProfiles;
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"disabledProfiles");
        MavenInitialImportContext initialImportContext = mavenImportFlow.prepareNewImport(this.project, importPaths, generalSettings, importingSettings, collection, collection2);
        ((MavenImportListener)this.project.getMessageBus().syncPublisher(MavenImportListener.TOPIC)).importStarted(spec);
        this.setProjectSettings(initialImportContext);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, initialImportContext, spec){
            final /* synthetic */ MavenImportingManager this$0;
            final /* synthetic */ MavenInitialImportContext $initialImportContext;
            final /* synthetic */ MavenImportSpec $spec;

            public final void run() {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, this.this$0.getProject(), MavenProjectBundle.message("maven.project.importing", new Object[0])){
                    final /* synthetic */ openProjectAndImport.1 this$0;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        try {
                            MavenImportFinishedContext finishedContext2 = MavenImportingManager.access$doImport(this.this$0.this$0, new MavenProgressIndicator(this.getProject(), indicator, new Supplier(this){
                                final /* synthetic */ openProjectAndImport.1 this$0;

                                public final MavenSyncConsole get() {
                                    return MavenImportingManager.access$getConsole$p(this.this$0.this$0.this$0);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }), this.this$0.$initialImportContext, this.this$0.$spec);
                            MavenImportingManager.access$getWaitingPromise(this.this$0.this$0).setResult((Object)finishedContext2);
                        }
                        catch (Throwable e) {
                            MavenLog.LOG.debug("import started at: ", (Throwable)this.this$0.$initialImportContext.getStartImportStackTrace());
                            MavenLog.LOG.warn(e);
                            if (indicator.isCanceled()) {
                                MavenImportingManager.access$getWaitingPromise(this.this$0.this$0).setError("Cancelled");
                            }
                            MavenLog.LOG.error(e);
                            MavenImportingManager.access$getWaitingPromise(this.this$0.this$0).setError(e);
                        }
                    }
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1, $super_call_param$2);
                    }
                });
            }
            {
                this.this$0 = mavenImportingManager;
                this.$initialImportContext = mavenInitialImportContext;
                this.$spec = mavenImportSpec;
            }
        });
        return new MavenImportingResult(this.getImportFinishPromise(), initialImportContext.getDummyModule());
    }

    private final void setProjectSettings(MavenInitialImportContext initialImportContext) {
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent = MavenWorkspaceSettingsComponent.getInstance(initialImportContext.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent, (String)"MavenWorkspaceSettingsCo\u2026ialImportContext.project)");
        MavenGeneralSettings generalSettings = mavenWorkspaceSettingsComponent.getSettings().getGeneralSettings();
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent2 = MavenWorkspaceSettingsComponent.getInstance(initialImportContext.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent2, (String)"MavenWorkspaceSettingsCo\u2026ialImportContext.project)");
        MavenImportingSettings importingSettings = mavenWorkspaceSettingsComponent2.getSettings().getImportingSettings();
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent3 = MavenWorkspaceSettingsComponent.getInstance(initialImportContext.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent3, (String)"MavenWorkspaceSettingsCo\u2026ialImportContext.project)");
        mavenWorkspaceSettingsComponent3.getSettings().setGeneralSettings(initialImportContext.getGeneralSettings());
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent4 = MavenWorkspaceSettingsComponent.getInstance(initialImportContext.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent4, (String)"MavenWorkspaceSettingsCo\u2026ialImportContext.project)");
        mavenWorkspaceSettingsComponent4.getSettings().setImportingSettings(initialImportContext.getImportingSettings());
        initialImportContext.getGeneralSettings().copyListeners(generalSettings);
        initialImportContext.getImportingSettings().copyListeners(importingSettings);
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent5 = MavenWorkspaceSettingsComponent.getInstance(initialImportContext.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent5, (String)"MavenWorkspaceSettingsCo\u2026ialImportContext.project)");
        mavenWorkspaceSettingsComponent5.getSettings().setGeneralSettings(initialImportContext.getGeneralSettings());
    }

    private final MavenImportFinishedContext doImport(MavenProgressIndicator indicator, MavenInitialImportContext initialImport, MavenImportSpec spec) {
        return (MavenImportFinishedContext)this.withStructuredIdeActivity((Function1)new Function1<StructuredIdeActivity, MavenImportFinishedContext>(this, spec, initialImport, indicator){
            final /* synthetic */ MavenImportingManager this$0;
            final /* synthetic */ MavenImportSpec $spec;
            final /* synthetic */ MavenInitialImportContext $initialImport;
            final /* synthetic */ MavenProgressIndicator $indicator;

            @NotNull
            public final MavenImportFinishedContext invoke(@NotNull StructuredIdeActivity activity) {
                MavenImportFinishedContext mavenImportFinishedContext;
                block0: {
                    MavenImportedContext mavenImportedContext;
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    MavenImportFlow flow = new MavenImportFlow();
                    MavenImportFinishedContext it = mavenImportFinishedContext = MavenImportingManager.access$runSync(this.this$0, this.$spec, (Function0)new Function0<MavenImportFinishedContext>(this, activity, flow){
                        final /* synthetic */ doImport.1 this$0;
                        final /* synthetic */ StructuredIdeActivity $activity;
                        final /* synthetic */ MavenImportFlow $flow;

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public final MavenImportFinishedContext invoke() {
                            void readMavenFiles2;
                            MavenImportingManager.access$getConsole$p(this.this$0.this$0).addWarning("New Maven importing flow is enabled", "New Maven importing flow is enabled, it is experimental feature. \n\nTo revert to old importing flow, set \"maven.linear.import\" registry flag to false");
                            MavenImportingManager.access$setCurrentContext$p(this.this$0.this$0, this.this$0.$initialImport);
                            Ref.ObjectRef objectRef = new Ref.ObjectRef();
                            MavenImportingManager mavenImportingManager = this.this$0.this$0;
                            String string = MavenProjectBundle.message("maven.reading", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenProjectBundle.message(\"maven.reading\")");
                            objectRef.element = (MavenReadContext)MavenImportingManager.access$doTask(mavenImportingManager, string, this.$activity, MavenImportStats.ReadingTask.class, (Function0)new Function0<MavenReadContext>(this){
                                final /* synthetic */ doImport.1 this$0;

                                @NotNull
                                public final MavenReadContext invoke() {
                                    block0: {
                                        Object object = this.this$0.this$0.this$0.getCurrentContext();
                                        if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                        ((MavenProgressIndicator)object).checkCanceled();
                                    }
                                    return this.this$0.$flow.readMavenFiles(this.this$0.this$0.$initialImport, this.this$0.this$0.$indicator);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            });
                            if (((MavenReadContext)readMavenFiles2.element).getWrapperData() != null) {
                                try {
                                    readMavenFiles2.element = this.$flow.setupMavenWrapper((MavenReadContext)readMavenFiles2.element, this.this$0.$indicator);
                                    ((MavenReadContext)readMavenFiles2.element).getInitialContext().getGeneralSettings().setMavenHome("Use Maven wrapper");
                                }
                                catch (Throwable e) {
                                    MavenLog.LOG.warn(e);
                                }
                            }
                            MavenImportingManager mavenImportingManager2 = this.this$0.this$0;
                            String string2 = MavenProjectBundle.message("maven.resolving", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MavenProjectBundle.message(\"maven.resolving\")");
                            MavenResolvedContext dependenciesContext2 = (MavenResolvedContext)MavenImportingManager.access$doTask(mavenImportingManager2, string2, this.$activity, MavenImportStats.ResolvingTask.class, (Function0)new Function0<MavenResolvedContext>(this, (Ref.ObjectRef)readMavenFiles2){
                                final /* synthetic */ doImport.1 this$0;
                                final /* synthetic */ Ref.ObjectRef $readMavenFiles;

                                @NotNull
                                public final MavenResolvedContext invoke() {
                                    block0: {
                                        Object object = this.this$0.this$0.this$0.getCurrentContext();
                                        if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                        ((MavenProgressIndicator)object).checkCanceled();
                                    }
                                    return this.this$0.$flow.resolveDependencies((MavenReadContext)this.$readMavenFiles.element);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$readMavenFiles = objectRef;
                                    super(0);
                                }
                            });
                            MavenImportingManager mavenImportingManager3 = this.this$0.this$0;
                            String string3 = MavenProjectBundle.message("maven.downloading.plugins", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MavenProjectBundle.messa\u2026ven.downloading.plugins\")");
                            MavenPluginResolvedContext resolvePlugins2 = (MavenPluginResolvedContext)MavenImportingManager.access$doTask(mavenImportingManager3, string3, this.$activity, MavenImportStats.PluginsResolvingTask.class, (Function0)new Function0<MavenPluginResolvedContext>(this, dependenciesContext2){
                                final /* synthetic */ doImport.1 this$0;
                                final /* synthetic */ MavenResolvedContext $dependenciesContext;

                                @NotNull
                                public final MavenPluginResolvedContext invoke() {
                                    block0: {
                                        Object object = this.this$0.this$0.this$0.getCurrentContext();
                                        if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                        ((MavenProgressIndicator)object).checkCanceled();
                                    }
                                    return this.this$0.$flow.resolvePlugins(this.$dependenciesContext);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$dependenciesContext = mavenResolvedContext;
                                    super(0);
                                }
                            });
                            MavenImportingManager mavenImportingManager4 = this.this$0.this$0;
                            String string4 = MavenProjectBundle.message("maven.project.importing", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"MavenProjectBundle.messa\u2026maven.project.importing\")");
                            MavenImportedContext importContext2 = (MavenImportedContext)MavenImportingManager.access$doTask(mavenImportingManager4, string4, this.$activity, MavenImportStats.ApplyingModelTask.class, (Function0)new Function0<MavenImportedContext>(this, dependenciesContext2){
                                final /* synthetic */ doImport.1 this$0;
                                final /* synthetic */ MavenResolvedContext $dependenciesContext;

                                @NotNull
                                public final MavenImportedContext invoke() {
                                    block0: {
                                        Object object = this.this$0.this$0.this$0.getCurrentContext();
                                        if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                        ((MavenProgressIndicator)object).checkCanceled();
                                    }
                                    return this.this$0.$flow.commitToWorkspaceModel(this.$dependenciesContext, this.this$0.$activity);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$dependenciesContext = mavenResolvedContext;
                                    super(0);
                                }
                            });
                            MavenImportingManager mavenImportingManager5 = this.this$0.this$0;
                            String string5 = MavenProjectBundle.message("maven.post.processing", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"MavenProjectBundle.messa\u2026(\"maven.post.processing\")");
                            return (MavenImportFinishedContext)MavenImportingManager.access$doTask(mavenImportingManager5, string5, this.$activity, MavenImportStats.ConfiguringProjectsTask.class, (Function0)new Function0<MavenImportFinishedContext>(this, importContext2, (Ref.ObjectRef)readMavenFiles2){
                                final /* synthetic */ doImport.1 this$0;
                                final /* synthetic */ MavenImportedContext $importContext;
                                final /* synthetic */ Ref.ObjectRef $readMavenFiles;

                                @NotNull
                                public final MavenImportFinishedContext invoke() {
                                    Object object = this.this$0.this$0.this$0.getCurrentContext();
                                    if (object != null && (object = ((MavenImportContext)object).getIndicator()) != null) {
                                        ((MavenProgressIndicator)object).checkCanceled();
                                    }
                                    this.this$0.$flow.runPostImportTasks(this.$importContext);
                                    this.this$0.$flow.updateProjectManager((MavenReadContext)this.$readMavenFiles.element);
                                    MavenImportingManager.access$setProjectSettings(this.this$0.this$0.this$0, this.this$0.this$0.$initialImport);
                                    MavenResolveResultProblemProcessor.notifyMavenProblems(this.this$0.this$0.this$0.getProject());
                                    return new MavenImportFinishedContext(this.$importContext);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$importContext = mavenImportedContext;
                                    this.$readMavenFiles = objectRef;
                                    super(0);
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                            this.$activity = structuredIdeActivity;
                            this.$flow = mavenImportFlow;
                            super(0);
                        }
                    });
                    boolean bl = false;
                    MavenImportedContext mavenImportedContext2 = it.getContext();
                    if (mavenImportedContext2 == null) break block0;
                    MavenImportedContext it2 = mavenImportedContext = mavenImportedContext2;
                    boolean bl2 = false;
                    ((MavenImportListener)this.this$0.getProject().getMessageBus().syncPublisher(MavenImportListener.TOPIC)).importFinished((Collection<MavenProject>)it2.getResolvedContext().getProjectsToImport(), it2.getModulesCreated());
                }
                return mavenImportFinishedContext;
            }
            {
                this.this$0 = mavenImportingManager;
                this.$spec = mavenImportSpec;
                this.$initialImport = mavenInitialImportContext;
                this.$indicator = mavenProgressIndicator;
                super(1);
            }
        });
    }

    private final AsyncPromise<MavenImportFinishedContext> getWaitingPromise() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isDispatchThread()) {
            return this.waitingPromise;
        }
        Ref ref = new Ref();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this, ref){
            final /* synthetic */ MavenImportingManager this$0;
            final /* synthetic */ Ref $ref;

            public final void run() {
                this.$ref.set((Object)MavenImportingManager.access$getWaitingPromise$p(this.this$0));
            }
            {
                this.this$0 = mavenImportingManager;
                this.$ref = ref;
            }
        });
        Object object = ref.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ref.get()");
        return (AsyncPromise)object;
    }

    public final boolean isImportingInProgress() {
        MavenImportContext context = this.currentContext;
        return context != null && !(context instanceof MavenImportFinishedContext);
    }

    @RequiresEdt
    @NotNull
    public final Promise<MavenImportFinishedContext> getImportFinishPromise() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return (Promise)this.getWaitingPromise();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MavenImportingResult scheduleImportAll(@NotNull MavenImportSpec spec) {
        List list;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        if (this.isRecursiveImportCalledFromMavenProjectsManagerWatcher()) {
            return new MavenImportingResult((Promise<MavenImportFinishedContext>)((Promise)this.getWaitingPromise()), null);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.project);
        if (this.isImportingInProgress()) {
            return new MavenImportingResult((Promise<MavenImportFinishedContext>)((Promise)this.getWaitingPromise()), null);
        }
        MavenWorkspaceSettingsComponent settings = MavenWorkspaceSettingsComponent.getInstance(this.project);
        MavenProjectsManager mavenProjectsManager = manager;
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"manager");
        MavenProjectsTree mavenProjectsTree = mavenProjectsManager.getProjectsTree();
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsTree, (String)"manager.projectsTree");
        List<String> list2 = mavenProjectsTree.getManagedFilesPaths();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"manager.projectsTree.managedFilesPaths");
        Iterable iterable = list2;
        MavenImportingManager mavenImportingManager = this;
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (LocalFileSystem.getInstance().findFileByPath(it) == null) continue;
            VirtualFile it$iv$iv = virtualFile;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = list = (List)destination$iv$iv;
        ImportPaths importPaths = new FilesList(list3);
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent = settings;
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent, (String)"settings");
        MavenImportingSettings mavenImportingSettings = mavenWorkspaceSettingsComponent.getSettings().getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"settings.settings.getImportingSettings()");
        MavenGeneralSettings mavenGeneralSettings = settings.getSettings().getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"settings.settings.getGeneralSettings()");
        return mavenImportingManager.openProjectAndImport(importPaths, mavenImportingSettings, mavenGeneralSettings, spec);
    }

    @NotNull
    public final MavenImportingResult scheduleUpdate(@NotNull List<? extends VirtualFile> filesToUpdate, @NotNull List<? extends VirtualFile> filesToDelete, @NotNull MavenImportSpec spec) {
        Intrinsics.checkNotNullParameter(filesToUpdate, (String)"filesToUpdate");
        Intrinsics.checkNotNullParameter(filesToDelete, (String)"filesToDelete");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        if (this.isRecursiveImportCalledFromMavenProjectsManagerWatcher()) {
            return new MavenImportingResult((Promise<MavenImportFinishedContext>)((Promise)this.getWaitingPromise()), null);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.project);
        MavenWorkspaceSettingsComponent settings = MavenWorkspaceSettingsComponent.getInstance(this.project);
        MavenProjectsManager mavenProjectsManager = manager;
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"manager");
        mavenProjectsManager.getProjectsTree().removeManagedFiles(filesToDelete);
        ImportPaths importPaths = new FilesList(filesToUpdate);
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent = settings;
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent, (String)"settings");
        MavenImportingSettings mavenImportingSettings = mavenWorkspaceSettingsComponent.getSettings().getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"settings.settings.getImportingSettings()");
        MavenGeneralSettings mavenGeneralSettings = settings.getSettings().getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"settings.settings.getGeneralSettings()");
        return this.openProjectAndImport(importPaths, mavenImportingSettings, mavenGeneralSettings, spec);
    }

    private final boolean isRecursiveImportCalledFromMavenProjectsManagerWatcher() {
        return this.isImportingInProgress();
    }

    private final <Result extends MavenImportContext> Result doTask(String message, StructuredIdeActivity parentActivity, Class<?> activityKlass, Function0<? extends Result> init) {
        return (Result)((MavenImportContext)this.withStructuredIdeActivity(parentActivity, activityKlass, (Function1)new Function1<StructuredIdeActivity, Result>(this, message, init){
            final /* synthetic */ MavenImportingManager this$0;
            final /* synthetic */ String $message;
            final /* synthetic */ Function0 $init;

            @NotNull
            public final Result invoke(@NotNull StructuredIdeActivity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Result Result2 = MavenImportingManager.access$getConsole$p(this.this$0).runTask(this.$message, this.$init);
                MavenImportContext ctx = (MavenImportContext)Result2;
                boolean bl = false;
                MavenImportingManager.access$setCurrentContext$p(this.this$0, ctx);
                return (Result)((MavenImportContext)Result2);
            }
            {
                this.this$0 = mavenImportingManager;
                this.$message = string;
                this.$init = function0;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MavenImportFinishedContext runSync(MavenImportSpec spec, Function0<MavenImportFinishedContext> init) {
        MavenSyncConsole mavenSyncConsole = this.getConsole();
        Object object = this.project.getService(SyncViewManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(SyncViewManager::class.java)");
        mavenSyncConsole.startImport((BuildProgressListener)object, spec);
        try {
            MavenImportFinishedContext mavenImportFinishedContext = (MavenImportFinishedContext)init.invoke();
            return mavenImportFinishedContext;
        }
        catch (Exception e) {
            if (!this.project.isDisposed()) {
                MavenSyncConsole mavenSyncConsole2 = this.getConsole();
                Throwable throwable = e;
                Object object2 = this.project.getService(SyncViewManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.getService(SyncViewManager::class.java)");
                mavenSyncConsole2.addException(throwable, (BuildProgressListener)object2);
            } else {
                MavenLog.LOG.warn((Throwable)e);
            }
            MavenImportFinishedContext mavenImportFinishedContext = new MavenImportFinishedContext(e, this.project);
            return mavenImportFinishedContext;
        }
        finally {
            this.getConsole().finishImport();
        }
    }

    public final void forceStopImport() {
        block0: {
            Object object = this.currentContext;
            if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
            ((MavenProgressIndicator)object).cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withStructuredIdeActivity(Function1<? super StructuredIdeActivity, ? extends T> f) {
        StructuredIdeActivity startedActivity2 = ProjectImportCollector.IMPORT_ACTIVITY.started(this.project, this.withData(MavenImportStats.ImportingTask.class));
        try {
            Object object = f.invoke((Object)startedActivity2);
            return (T)object;
        }
        finally {
            StructuredIdeActivity.finished$default((StructuredIdeActivity)startedActivity2, null, (int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withStructuredIdeActivity(StructuredIdeActivity parent, Class<?> klass, Function1<? super StructuredIdeActivity, ? extends T> f) {
        StructuredIdeActivity startedActivity2 = ProjectImportCollector.IMPORT_STAGE.startedWithParent(this.project, parent, new Function0<List<? extends EventPair<?>>>(klass){
            final /* synthetic */ Class $klass;

            @NotNull
            public final List<EventPair<?>> invoke() {
                return CollectionsKt.listOf((Object)ProjectImportCollector.TASK_CLASS.with((Object)this.$klass));
            }
            {
                this.$klass = clazz;
                super(0);
            }
        });
        try {
            Object object = f.invoke((Object)startedActivity2);
            return (T)object;
        }
        finally {
            StructuredIdeActivity.finished$default((StructuredIdeActivity)startedActivity2, null, (int)1, null);
        }
    }

    private final Function0<List<EventPair<?>>> withData(Class<?> klass) {
        return new Function0<List<EventPair<?>>>(this, klass){
            final /* synthetic */ MavenImportingManager this$0;
            final /* synthetic */ Class $klass;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<EventPair<?>> invoke() {
                void var1_1;
                List data = CollectionsKt.mutableListOf((Object[])new EventPair[]{ExternalSystemActionsCollector.Companion.getEXTERNAL_SYSTEM_ID().with((Object)"Maven")});
                if (MavenImportingManager.access$getMavenPluginInfo$p(this.this$0) != null) {
                    data.add(EventFields.PluginInfo.with((Object)MavenImportingManager.access$getMavenPluginInfo$p(this.this$0)));
                }
                data.add(ProjectImportCollector.TASK_CLASS.with((Object)this.$klass));
                return var1_1;
            }
            {
                this.this$0 = mavenImportingManager;
                this.$klass = clazz;
                super(0);
            }
        };
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public MavenImportingManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Disposable disposable = Disposer.newDisposable((String)"Maven Importing manager");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable(\"Maven Importing manager\")");
        this.disposable = disposable;
        this.mavenPluginInfo$delegate = LazyKt.lazy((Function0)mavenPluginInfo.2.INSTANCE);
        this.console$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MavenSyncConsole>(this){
            final /* synthetic */ MavenImportingManager this$0;

            public final MavenSyncConsole invoke() {
                Object object = this.this$0.getProject().getService(MavenProjectsManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Maven\u2026jectsManager::class.java)");
                return ((MavenProjectsManager)object).getSyncConsole();
            }
            {
                this.this$0 = mavenImportingManager;
                super(0);
            }
        }));
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Maven importing executor", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026n importing executor\", 1)");
        this.executor = executorService;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(this.disposable);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(disposable)");
        MessageBusConnection connection = messageBusConnection;
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"ProjectManager.TOPIC");
        connection.subscribe(topic, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Disposer.dispose((Disposable)disposable);
                this.forceStopImport();
                executor.shutdownNow();
                ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this){
                    final /* synthetic */ 1 this$0;

                    public final void run() {
                        MavenImportingManager.access$getExecutor$p(this.this$0.this).awaitTermination(500L, TimeUnit.MILLISECONDS);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, RunnerBundle.message("maven.server.shutdown", new Object[0]), false, this.getProject());
            }
        });
        this.waitingPromise = new AsyncPromise();
    }

    public static final /* synthetic */ MavenImportContext access$getCurrentContext$lp(MavenImportingManager $this) {
        return $this.currentContext;
    }

    public static final /* synthetic */ void access$setCurrentContext$lp(MavenImportingManager $this, MavenImportContext mavenImportContext) {
        $this.currentContext = mavenImportContext;
    }

    public static final /* synthetic */ MavenImportFinishedContext access$doImport(MavenImportingManager $this, MavenProgressIndicator indicator, MavenInitialImportContext initialImport, MavenImportSpec spec) {
        return $this.doImport(indicator, initialImport, spec);
    }

    public static final /* synthetic */ MavenSyncConsole access$getConsole$p(MavenImportingManager $this) {
        return $this.getConsole();
    }

    public static final /* synthetic */ AsyncPromise access$getWaitingPromise(MavenImportingManager $this) {
        return $this.getWaitingPromise();
    }

    public static final /* synthetic */ MavenImportFinishedContext access$runSync(MavenImportingManager $this, MavenImportSpec spec, Function0 init) {
        return $this.runSync(spec, (Function0<MavenImportFinishedContext>)init);
    }

    public static final /* synthetic */ MavenImportContext access$getCurrentContext$p(MavenImportingManager $this) {
        return $this.currentContext;
    }

    public static final /* synthetic */ void access$setCurrentContext$p(MavenImportingManager $this, MavenImportContext mavenImportContext) {
        $this.setCurrentContext(mavenImportContext);
    }

    public static final /* synthetic */ MavenImportContext access$doTask(MavenImportingManager $this, String message, StructuredIdeActivity parentActivity, Class activityKlass, Function0 init) {
        return $this.doTask(message, parentActivity, activityKlass, init);
    }

    public static final /* synthetic */ void access$setProjectSettings(MavenImportingManager $this, MavenInitialImportContext initialImportContext) {
        $this.setProjectSettings(initialImportContext);
    }

    public static final /* synthetic */ AsyncPromise access$getWaitingPromise$p(MavenImportingManager $this) {
        return $this.waitingPromise;
    }

    public static final /* synthetic */ void access$setWaitingPromise$p(MavenImportingManager $this, AsyncPromise asyncPromise) {
        $this.waitingPromise = asyncPromise;
    }

    public static final /* synthetic */ PluginInfo access$getMavenPluginInfo$p(MavenImportingManager $this) {
        return $this.getMavenPluginInfo();
    }

    @JvmStatic
    @NotNull
    public static final MavenImportingManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/project/importing/MavenImportingManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/idea/maven/project/importing/MavenImportingManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MavenImportingManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(MavenImportingManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Maven\u2026rtingManager::class.java)");
            return (MavenImportingManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

