/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.project.Project;
import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenIndexId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.server.IndexedMavenId;
import org.jetbrains.idea.maven.server.MavenIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public abstract class MavenIndexerWrapper
extends MavenRemoteObjectWrapper<MavenServerIndexer> {
    private final Project myProject;

    public MavenIndexerWrapper(@Nullable RemoteObjectWrapper<?> parent, Project project2) {
        super(parent);
        this.myProject = project2;
    }

    public void releaseIndex(MavenIndexId mavenIndexId) throws MavenServerIndexerException {
        MavenLog.LOG.debug("releaseIndex " + mavenIndexId.indexId);
        MavenServerIndexer w = (MavenServerIndexer)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.releaseIndex(mavenIndexId, ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public boolean indexExists(File dir2) {
        try {
            return ((MavenServerIndexer)this.getOrCreateWrappee()).indexExists(dir2, ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return false;
        }
    }

    public int getIndexCount() {
        return this.perform(() -> ((MavenServerIndexer)this.getOrCreateWrappee()).getIndexCount(ourToken));
    }

    public void updateIndex(@NotNull MavenIndexId mavenIndexId, @Nullable MavenGeneralSettings settings, @NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException, MavenServerIndexerException {
        if (mavenIndexId == null) {
            MavenIndexerWrapper.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            MavenIndexerWrapper.$$$reportNull$$$0(1);
        }
        this.performCancelable(() -> {
            MavenServerProgressIndicator indicatorWrapper = MavenIndexerWrapper.wrapAndExport(indicator);
            try {
                ((MavenServerIndexer)this.getOrCreateWrappee()).updateIndex(mavenIndexId, MavenServerManager.convertSettings(this.myProject, settings), indicatorWrapper, ourToken);
            }
            finally {
                UnicastRemoteObject.unexportObject((Remote)indicatorWrapper, true);
            }
            return null;
        });
    }

    public void processArtifacts(MavenIndexId mavenIndexId, MavenIndicesProcessor processor) throws MavenServerIndexerException {
        this.perform(() -> {
            try {
                List list;
                int start = 0;
                do {
                    if ((list = ((MavenServerIndexer)this.getOrCreateWrappee()).processArtifacts(mavenIndexId, start, ourToken)) == null) continue;
                    processor.processArtifacts(list);
                    start += list.size();
                } while (list != null);
                return null;
            }
            catch (Exception e) {
                MavenLog.LOG.error("maven index id " + mavenIndexId, (Throwable)e);
                return null;
            }
        });
    }

    @Nullable
    public IndexedMavenId addArtifact(MavenIndexId mavenIndexId, File artifactFile) throws MavenServerIndexerException {
        return this.perform(() -> {
            try {
                return ((MavenServerIndexer)this.getOrCreateWrappee()).addArtifact(mavenIndexId, artifactFile, ourToken);
            }
            catch (Throwable ignore) {
                return null;
            }
        });
    }

    public Set<MavenArtifactInfo> search(MavenIndexId mavenIndexId, String pattern, int maxResult) throws MavenServerIndexerException {
        return this.perform(() -> ((MavenServerIndexer)this.getOrCreateWrappee()).search(mavenIndexId, pattern, maxResult, ourToken));
    }

    @Deprecated
    public Collection<MavenArchetype> getArchetypes() {
        return this.perform(() -> ((MavenServerIndexer)this.getOrCreateWrappee()).getArchetypes(ourToken));
    }

    @TestOnly
    public void releaseInTests() {
        MavenServerIndexer w = (MavenServerIndexer)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.release(ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "mavenIndexId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "indicator";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/server/MavenIndexerWrapper";
        objectArray[2] = "updateIndex";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class RemoteMavenServerIndicesProcessor
    extends MavenRemoteObject
    implements MavenServerIndicesProcessor {
        private final MavenIndicesProcessor myProcessor;

        private RemoteMavenServerIndicesProcessor(MavenIndicesProcessor processor) {
            this.myProcessor = processor;
        }

        public void processArtifacts(Collection<IndexedMavenId> artifacts) {
            this.myProcessor.processArtifacts(artifacts);
        }
    }
}

