/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.application.Application;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;", "", "application", "Lcom/intellij/openapi/application/Application;", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "(Lcom/intellij/openapi/application/Application;Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;)V", "scheduleUpdateFromServer", "Lcom/intellij/settingsSync/UpdateResult;", "intellij.settingsSync"})
public final class SettingsSyncUpdateChecker {
    private final Application application;
    private final SettingsSyncRemoteCommunicator remoteCommunicator;

    @RequiresBackgroundThread
    @NotNull
    public final UpdateResult scheduleUpdateFromServer() {
        UpdateResult updateResult = this.remoteCommunicator.receiveUpdates();
        if (updateResult instanceof UpdateResult.Success) {
            SettingsSnapshot snapshot = ((UpdateResult.Success)updateResult).getSettingsSnapshot();
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(new SyncSettingsEvent.CloudChange(snapshot));
        }
        return updateResult;
    }

    public SettingsSyncUpdateChecker(@NotNull Application application, @NotNull SettingsSyncRemoteCommunicator remoteCommunicator) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
        this.application = application;
        this.remoteCommunicator = remoteCommunicator;
    }
}

