/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.DependencyManager;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFileCache;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.AndroidGradlePluginVersion;
import com.android.tools.idea.gradle.dsl.parser.semantics.DescribedGradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.android.tools.idea.gradle.dsl.utils.BuildScriptUtil;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class BuildModelContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleDslFileCache myFileCache;
    @NotNull
    private final ResolvedConfigurationFileLocationProvider myResolvedConfigurationFileLocationProvider;
    @NotNull
    private final Map<GradleDslFile, ClassToInstanceMap<BuildModelNotification>> myNotifications;
    @NotNull
    private final DependencyManager myDependencyManager;
    @Nullable
    private GradleBuildFile myRootProjectFile;
    @Nullable
    private AndroidGradlePluginVersion agpVersion;

    public void setRootProjectFile(@NotNull GradleBuildFile rootProjectFile) {
        if (rootProjectFile == null) {
            BuildModelContext.$$$reportNull$$$0(0);
        }
        this.myRootProjectFile = rootProjectFile;
    }

    @Nullable
    public GradleBuildFile getRootProjectFile() {
        return this.myRootProjectFile;
    }

    public void setAgpVersion(@Nullable AndroidGradlePluginVersion agpVersion) {
        this.agpVersion = agpVersion;
    }

    @Nullable
    public AndroidGradlePluginVersion getAgpVersion() {
        return this.agpVersion;
    }

    @NotNull
    public static BuildModelContext create(@NotNull Project project, @NotNull ResolvedConfigurationFileLocationProvider resolvedConfigurationFileLocationProvider) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(1);
        }
        if (resolvedConfigurationFileLocationProvider == null) {
            BuildModelContext.$$$reportNull$$$0(2);
        }
        return new BuildModelContext(project, resolvedConfigurationFileLocationProvider);
    }

    private BuildModelContext(@NotNull Project project, @NotNull ResolvedConfigurationFileLocationProvider resolvedConfigurationFileLocationProvider) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(3);
        }
        if (resolvedConfigurationFileLocationProvider == null) {
            BuildModelContext.$$$reportNull$$$0(4);
        }
        this.myNotifications = new HashMap<GradleDslFile, ClassToInstanceMap<BuildModelNotification>>();
        this.myProject = project;
        this.myFileCache = new GradleDslFileCache(project);
        this.myResolvedConfigurationFileLocationProvider = resolvedConfigurationFileLocationProvider;
        this.myDependencyManager = DependencyManager.create();
        this.myRootProjectFile = null;
    }

    @NotNull
    public DependencyManager getDependencyManager() {
        DependencyManager dependencyManager = this.myDependencyManager;
        if (dependencyManager == null) {
            BuildModelContext.$$$reportNull$$$0(5);
        }
        return dependencyManager;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(6);
        }
        return project;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications(@NotNull GradleDslFile file) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(7);
        }
        return new ArrayList<BuildModelNotification>(this.myNotifications.getOrDefault(file, (ClassToInstanceMap<BuildModelNotification>)MutableClassToInstanceMap.create()).values());
    }

    @NotNull
    public <T extends BuildModelNotification> T getNotificationForType(@NotNull GradleDslFile file, @NotNull NotificationTypeReference<T> type) {
        ClassToInstanceMap notificationMap;
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(8);
        }
        if (type == null) {
            BuildModelContext.$$$reportNull$$$0(9);
        }
        if ((notificationMap = this.myNotifications.computeIfAbsent(file, f -> MutableClassToInstanceMap.create())).containsKey(type.getClazz())) {
            BuildModelNotification buildModelNotification = (BuildModelNotification)notificationMap.getInstance(type.getClazz());
            if (buildModelNotification == null) {
                BuildModelContext.$$$reportNull$$$0(10);
            }
            return (T)buildModelNotification;
        }
        BuildModelNotification notification = (BuildModelNotification)type.getConstructor().produce();
        notificationMap.putInstance(type.getClazz(), (Object)notification);
        BuildModelNotification buildModelNotification = notification;
        if (buildModelNotification == null) {
            BuildModelContext.$$$reportNull$$$0(11);
        }
        return (T)buildModelNotification;
    }

    @Nullable
    public VirtualFile getCurrentParsingRoot() {
        return this.myFileCache.getCurrentParsingRoot();
    }

    public void reset() {
        this.myFileCache.clearAllFiles();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, @NotNull String name, boolean isApplied) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(12);
        }
        if (name == null) {
            BuildModelContext.$$$reportNull$$$0(13);
        }
        GradleBuildFile gradleBuildFile = this.myFileCache.getOrCreateBuildFile(file, name, this, isApplied);
        if (gradleBuildFile == null) {
            BuildModelContext.$$$reportNull$$$0(14);
        }
        return gradleBuildFile;
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, boolean isApplied) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(15);
        }
        GradleBuildFile gradleBuildFile = this.getOrCreateBuildFile(file, file.getName(), isApplied);
        if (gradleBuildFile == null) {
            BuildModelContext.$$$reportNull$$$0(16);
        }
        return gradleBuildFile;
    }

    @NotNull
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull VirtualFile settingsFile) {
        if (settingsFile == null) {
            BuildModelContext.$$$reportNull$$$0(17);
        }
        GradleSettingsFile gradleSettingsFile = this.myFileCache.getOrCreateSettingsFile(settingsFile, this);
        if (gradleSettingsFile == null) {
            BuildModelContext.$$$reportNull$$$0(18);
        }
        return gradleSettingsFile;
    }

    @Nullable
    public GradlePropertiesFile getOrCreatePropertiesFile(@NotNull VirtualFile file, @NotNull String moduleName) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(19);
        }
        if (moduleName == null) {
            BuildModelContext.$$$reportNull$$$0(20);
        }
        return this.myFileCache.getOrCreatePropertiesFile(file, moduleName, this);
    }

    @NotNull
    public GradleBuildFile parseBuildFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull String moduleName, boolean isApplied) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(21);
        }
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(22);
        }
        if (moduleName == null) {
            BuildModelContext.$$$reportNull$$$0(23);
        }
        GradleBuildFile buildDslFile = new GradleBuildFile(file, project, moduleName, this);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!isApplied) {
                this.populateWithParentModuleSubProjectsProperties(buildDslFile);
            }
            this.populateSiblingDslFileWithGradlePropertiesFile(buildDslFile);
            buildDslFile.parse();
        });
        GradleBuildFile gradleBuildFile = buildDslFile;
        if (gradleBuildFile == null) {
            BuildModelContext.$$$reportNull$$$0(24);
        }
        return gradleBuildFile;
    }

    public GradleBuildFile parseProjectBuildFile(@NotNull Project project, @Nullable VirtualFile file) {
        GradleBuildFile result;
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(25);
        }
        GradleBuildFile gradleBuildFile = result = file != null ? new GradleBuildFile(file, project, ":", this) : null;
        if (result != null) {
            this.setRootProjectFile(result);
            ApplicationManager.getApplication().runReadAction(() -> {
                this.populateWithParentModuleSubProjectsProperties(result);
                this.populateSiblingDslFileWithGradlePropertiesFile(result);
                result.parse();
            });
            this.putBuildFile(file.getUrl(), result);
        }
        return result;
    }

    private void putBuildFile(@NotNull String name, @NotNull GradleDslFile buildFile) {
        if (name == null) {
            BuildModelContext.$$$reportNull$$$0(26);
        }
        if (buildFile == null) {
            BuildModelContext.$$$reportNull$$$0(27);
        }
        this.myFileCache.putBuildFile(name, buildFile);
    }

    @NotNull
    public List<GradleDslFile> getAllRequestedFiles() {
        List<GradleDslFile> list = this.myFileCache.getAllFiles();
        if (list == null) {
            BuildModelContext.$$$reportNull$$$0(28);
        }
        return list;
    }

    private void populateSiblingDslFileWithGradlePropertiesFile(@NotNull GradleBuildFile buildDslFile) {
        File propertiesFilePath;
        VirtualFile propertiesFile;
        if (buildDslFile == null) {
            BuildModelContext.$$$reportNull$$$0(29);
        }
        if ((propertiesFile = VfsUtil.findFileByIoFile((File)(propertiesFilePath = new File(buildDslFile.getDirectoryPath(), "gradle.properties")), (boolean)false)) == null) {
            return;
        }
        GradlePropertiesFile parsedProperties = this.getOrCreatePropertiesFile(propertiesFile, buildDslFile.getName());
        if (parsedProperties == null) {
            return;
        }
        GradlePropertiesModel propertiesModel = new GradlePropertiesModel(parsedProperties);
        GradlePropertiesFile propertiesDslFile = propertiesModel.myGradlePropertiesFile;
        buildDslFile.setPropertiesFile(propertiesDslFile);
    }

    private void populateWithParentModuleSubProjectsProperties(@NotNull GradleBuildFile buildDslFile) {
        VirtualFile maybeSettingsFile;
        if (buildDslFile == null) {
            BuildModelContext.$$$reportNull$$$0(30);
        }
        if ((maybeSettingsFile = buildDslFile.tryToFindSettingsFile()) == null) {
            return;
        }
        GradleSettingsFile settingsFile = this.getOrCreateSettingsFile(maybeSettingsFile);
        GradleSettingsModelImpl gradleSettingsModel = new GradleSettingsModelImpl(settingsFile);
        String modulePath = gradleSettingsModel.moduleWithDirectory(buildDslFile.getDirectoryPath());
        if (modulePath == null) {
            return;
        }
        GradleBuildModel parentModuleModel = gradleSettingsModel.getParentModuleModel(modulePath);
        if (!(parentModuleModel instanceof GradleBuildModelImpl)) {
            return;
        }
        GradleBuildModelImpl parentModuleModelImpl = (GradleBuildModelImpl)parentModuleModel;
        GradleBuildFile parentModuleDslFile = parentModuleModelImpl.myGradleBuildFile;
        buildDslFile.setParentModuleBuildFile(parentModuleDslFile);
        SubProjectsDslElement subProjectsDslElement = parentModuleDslFile.getPropertyElement(SubProjectsDslElement.SUBPROJECTS);
        if (subProjectsDslElement == null) {
            return;
        }
        buildDslFile.addAppliedProperty(subProjectsDslElement);
        for (Map.Entry<String, GradleDslElement> entry : subProjectsDslElement.getPropertyElements().entrySet()) {
            GradleDslElement element = entry.getValue();
            if (element instanceof ApplyDslElement) {
                ApplyDslElement subProjectsApply = (ApplyDslElement)element;
                ApplyDslElement myApply = new ApplyDslElement(buildDslFile, buildDslFile);
                buildDslFile.setParsedElement(myApply);
                for (GradleDslElement appliedElement : subProjectsApply.getAllElements()) {
                    myApply.addParsedElement(appliedElement);
                }
                continue;
            }
            buildDslFile.addAppliedProperty(this.dslTreeCopy(element, buildDslFile));
        }
    }

    private GradleDslElement dslTreeCopy(GradleDslElement element, GradleDslElement parent) {
        return this.dslTreeCopy(element, parent, new HashMap<GradleDslElement, GradleDslElement>());
    }

    private GradleDslElement dslTreeCopy(GradleDslElement element, GradleDslElement parent, Map<GradleDslElement, GradleDslElement> seen) {
        GradleDslElement result;
        GradleDslElement previous = seen.get(element);
        if (previous != null) {
            return previous;
        }
        if (element instanceof DescribedGradlePropertiesDslElement) {
            PropertiesElementDescription description = ((DescribedGradlePropertiesDslElement)((Object)element)).getDescription();
            Object myProperties = description.constructor.construct(parent, GradleNameElement.copy(element.getNameElement()));
            result = myProperties;
            seen.put(element, result);
            for (GradleDslElement subElement : ((GradlePropertiesDslElement)element).getAllElements()) {
                ((GradlePropertiesDslElement)myProperties).addAppliedProperty(this.dslTreeCopy(subElement, (GradleDslElement)myProperties, seen));
            }
        } else {
            result = element;
            seen.put(element, result);
        }
        return result;
    }

    @Nullable
    public VirtualFile getGradleBuildFile(@NotNull Module module) {
        VirtualFile result;
        if (module == null) {
            BuildModelContext.$$$reportNull$$$0(31);
        }
        if ((result = this.myResolvedConfigurationFileLocationProvider.getGradleBuildFile(module)) != null) {
            return result;
        }
        @SystemIndependent String rootPath = this.myResolvedConfigurationFileLocationProvider.getGradleProjectRootPath(module);
        if (rootPath == null) {
            return null;
        }
        File moduleRoot = new File(FileUtilRt.toSystemDependentName((String)rootPath));
        return this.getGradleBuildFile(moduleRoot);
    }

    @Nullable
    public VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        File gradleBuildFilePath;
        VirtualFile result;
        if (dirPath == null) {
            BuildModelContext.$$$reportNull$$$0(32);
        }
        return (result = VfsUtil.findFileByIoFile((File)(gradleBuildFilePath = BuildScriptUtil.findGradleBuildFile(dirPath)), (boolean)false)) != null && result.isValid() ? result : null;
    }

    @Nullable
    public VirtualFile getGradleSettingsFile(@NotNull File dirPath) {
        File gradleSettingsFilePath;
        VirtualFile result;
        if (dirPath == null) {
            BuildModelContext.$$$reportNull$$$0(33);
        }
        return (result = VfsUtil.findFileByIoFile((File)(gradleSettingsFilePath = BuildScriptUtil.findGradleSettingsFile(dirPath)), (boolean)false)) != null && result.isValid() ? result : null;
    }

    @Nullable
    public VirtualFile getProjectSettingsFile() {
        @SystemIndependent String rootPath = this.myResolvedConfigurationFileLocationProvider.getGradleProjectRootPath(this.getProject());
        if (rootPath == null) {
            return null;
        }
        return this.getGradleSettingsFile(new File(FileUtilRt.toSystemDependentName((String)rootPath)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 24: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 24: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectFile";
                break;
            }
            case 1: 
            case 3: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedConfigurationFileLocationProvider";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/BuildModelContext";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsFile";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDslFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/BuildModelContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationForType";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateBuildFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSettingsFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBuildFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRequestedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRootProjectFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 24: 
            case 28: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPublicNotifications";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationForType";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateBuildFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateSettingsFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreatePropertiesFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseBuildFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseProjectBuildFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putBuildFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "populateSiblingDslFileWithGradlePropertiesFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "populateWithParentModuleSubProjectsProperties";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getGradleBuildFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getGradleSettingsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 24: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ResolvedConfigurationFileLocationProvider {
        @Nullable
        public VirtualFile getGradleBuildFile(@NotNull Module var1);

        @Nullable
        public @SystemIndependent String getGradleProjectRootPath(@NotNull Module var1);

        @Nullable
        public @SystemIndependent String getGradleProjectRootPath(@NotNull Project var1);
    }
}

