/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.maven;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.navigator.MavenNavigationUtil;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"getMavenVersionPsiElement", "Lcom/intellij/psi/PsiElement;", "dependency", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.packageSearch.maven"})
public final class GetMavenVersionPsiElementKt {
    @Nullable
    public static final PsiElement getMavenVersionPsiElement(@NotNull UnifiedDependency dependency, @NotNull PsiFile file) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = dependency.getCoordinates().getGroupId();
        if (string == null) {
            return null;
        }
        String groupId = string;
        String string2 = dependency.getCoordinates().getArtifactId();
        if (string2 == null) {
            return null;
        }
        String artifactId = string2;
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel((Project)file.getProject(), (VirtualFile)file.getVirtualFile());
        if (mavenDomProjectModel == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomProjectModel, (String)"MavenDomUtil.getMavenDom\u2026rtualFile) ?: return null");
        MavenDomProjectModel projectModel = mavenDomProjectModel;
        MavenDomDependency mavenDependency = MavenNavigationUtil.findDependency((MavenDomProjectModel)projectModel, (String)groupId, (String)artifactId);
        MavenDomDependency mavenDomDependency = mavenDependency;
        if (mavenDomDependency == null || (mavenDomDependency = mavenDomDependency.getVersion()) == null || (mavenDomDependency = mavenDomDependency.getXmlElement()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependency, (String)"mavenDependency?.version\u2026xmlElement ?: return null");
        MavenDomDependency element = mavenDomDependency;
        if (element instanceof XmlTag) {
            XmlTagValue xmlTagValue = ((XmlTag)element).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)xmlTagValue, (String)"element.value");
            Object[] objectArray = xmlTagValue.getTextElements();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"element.value.textElements");
            psiElement = (PsiElement)ArraysKt.firstOrNull((Object[])objectArray);
        } else {
            psiElement = null;
        }
        return psiElement;
    }
}

