/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.repositories;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.configuration.PackageSearchGeneralConfiguration;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.KnownRepositories;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.RepositoryModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.RepositoryUsageInfo;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.repositories.RepositoryTreeItem;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.repositories.RepositoryTreeItemRenderer;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.BordersKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.Displayable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u00020\u00050\u0004B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0017\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\u001eH\u0002J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/repositories/RepositoryTree;", "Lcom/intellij/ui/treeStructure/Tree;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/ide/CopyProvider;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/util/Displayable;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$All;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "rootNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getRootNode", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "display", "", "viewModel", "(Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$All;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getData", "", "Lorg/jetbrains/annotations/Nullable;", "dataId", "", "getRepositoryItemFrom", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/repositories/RepositoryTreeItem;", "treePath", "Ljavax/swing/tree/TreePath;", "getSelectedRepositoryItem", "isCopyEnabled", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyVisible", "openFile", "repositoryModuleItem", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/repositories/RepositoryTreeItem$Module;", "focusEditor", "performCopy", "intellij.packageSearch"})
public final class RepositoryTree
extends Tree
implements DataProvider,
CopyProvider,
Displayable<KnownRepositories.All> {
    private final Project project;

    private final DefaultMutableTreeNode getRootNode() {
        TreeModel treeModel = this.getModel();
        if (treeModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        }
        Object object = ((DefaultTreeModel)treeModel).getRoot();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        }
        return (DefaultMutableTreeNode)object;
    }

    private final void openFile(RepositoryTreeItem.Module repositoryModuleItem, boolean focusEditor) {
        if (!PackageSearchGeneralConfiguration.Companion.getInstance(this.project).getAutoScrollToSource()) {
            return;
        }
        VirtualFile file = repositoryModuleItem.getUsageInfo().getProjectModule().getBuildFile();
        FileEditorManager.getInstance((Project)this.project).openFile(file, focusEditor, true);
    }

    static /* synthetic */ void openFile$default(RepositoryTree repositoryTree, RepositoryTreeItem.Module module, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        repositoryTree.openFile(module, bl);
    }

    @Override
    @Nullable
    public Object display(@NotNull KnownRepositories.All viewModel, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, viewModel, null){
            int label;
            final /* synthetic */ RepositoryTree this$0;
            final /* synthetic */ KnownRepositories.All $viewModel;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        RepositoryTreeItem previouslySelectedItem = RepositoryTree.access$getSelectedRepositoryItem(this.this$0);
                        this.this$0.clearSelection();
                        RepositoryTree.access$getRootNode$p(this.this$0).removeAllChildren();
                        Iterable $this$sortedBy$iv = this.$viewModel;
                        boolean $i$f$sortedBy = false;
                        List sortedRepositories = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                RepositoryModel it = (RepositoryModel)a;
                                boolean bl = false;
                                Comparable comparable = (Comparable)((Object)it.getDisplayName());
                                it = (RepositoryModel)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                String string = it.getDisplayName();
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                            }
                        });
                        for (RepositoryModel repository : sortedRepositories) {
                            if (repository.getUsageInfo().isEmpty()) continue;
                            RepositoryTreeItem.Repository repoItem = new RepositoryTreeItem.Repository(repository);
                            DefaultMutableTreeNode repoNode = new DefaultMutableTreeNode(repoItem);
                            for (RepositoryUsageInfo usageInfo : repository.getUsageInfo()) {
                                RepositoryTreeItem.Module moduleItem = new RepositoryTreeItem.Module(usageInfo);
                                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(moduleItem);
                                repoNode.add(treeNode);
                                if (!Intrinsics.areEqual((Object)previouslySelectedItem, (Object)moduleItem)) continue;
                                TreeSelectionModel treeSelectionModel = RepositoryTree.access$getSelectionModel$p(this.this$0);
                                Intrinsics.checkNotNullExpressionValue((Object)treeSelectionModel, (String)"selectionModel");
                                treeSelectionModel.setSelectionPath(new TreePath(treeNode));
                            }
                            RepositoryTree.access$getRootNode$p(this.this$0).add(repoNode);
                            if (!Intrinsics.areEqual((Object)previouslySelectedItem, (Object)repoItem)) continue;
                            TreeSelectionModel treeSelectionModel = RepositoryTree.access$getSelectionModel$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)treeSelectionModel, (String)"selectionModel");
                            treeSelectionModel.setSelectionPath(new TreePath(repoNode));
                        }
                        TreeUtil.expandAll((JTree)((JTree)((Object)this.this$0)));
                        this.this$0.updateUI();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = repositoryTree;
                this.$viewModel = all2;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        RepositoryTreeItem selectedItem = this.getSelectedRepositoryItem();
        return selectedItem instanceof DataProvider ? ((DataProvider)selectedItem).getData(dataId) : null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        RepositoryTreeItem selectedItem = this.getSelectedRepositoryItem();
        if (selectedItem instanceof CopyProvider) {
            ((CopyProvider)selectedItem).performCopy(dataContext);
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        RepositoryTreeItem selectedItem = this.getSelectedRepositoryItem();
        return selectedItem instanceof CopyProvider && ((CopyProvider)selectedItem).isCopyEnabled(dataContext);
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        RepositoryTreeItem selectedItem = this.getSelectedRepositoryItem();
        return selectedItem instanceof CopyProvider && ((CopyProvider)selectedItem).isCopyVisible(dataContext);
    }

    private final RepositoryTreeItem getSelectedRepositoryItem() {
        return this.getRepositoryItemFrom(this.getSelectionPath());
    }

    private final RepositoryTreeItem getRepositoryItemFrom(TreePath treePath) {
        DefaultMutableTreeNode item;
        TreePath treePath2 = treePath;
        Object object = treePath2 != null ? treePath2.getLastPathComponent() : null;
        if (!(object instanceof DefaultMutableTreeNode)) {
            object = null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = item = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
        if (!(object2 instanceof RepositoryTreeItem)) {
            object2 = null;
        }
        return (RepositoryTreeItem)object2;
    }

    public RepositoryTree(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.setCellRenderer((TreeCellRenderer)((Object)new RepositoryTreeItemRenderer()));
        TreeSelectionModel treeSelectionModel = this.selectionModel;
        Intrinsics.checkNotNullExpressionValue((Object)treeSelectionModel, (String)"selectionModel");
        treeSelectionModel.setSelectionMode(1);
        this.rootVisible = false;
        this.setRootVisible(false);
        this.showsRootHandles = true;
        this.setBorder((Border)BordersKt.emptyBorder$default(0, 8, 0, 0, 13, null));
        StatusText statusText = this.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"emptyText");
        statusText.setText(PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.tab.repositories.no.repositories.configured", new Object[0]));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@Nullable MouseEvent e) {
                if (e != null && e.getClickCount() >= 1) {
                    TreePath treePath = this.getPathForLocation(e.getX(), e.getY());
                    if (treePath == null) {
                        return;
                    }
                    TreePath treePath2 = treePath;
                    RepositoryTreeItem item = this.getRepositoryItemFrom(treePath2);
                    if (item != null && item instanceof RepositoryTreeItem.Module) {
                        RepositoryTree.openFile$default(this, (RepositoryTreeItem.Module)item, false, 2, null);
                    }
                }
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public final void valueChanged(TreeSelectionEvent it) {
                TreeSelectionEvent treeSelectionEvent = it;
                Intrinsics.checkNotNullExpressionValue((Object)treeSelectionEvent, (String)"it");
                RepositoryTreeItem item = this.getRepositoryItemFrom(treeSelectionEvent.getNewLeadSelectionPath());
                if (item != null && item instanceof RepositoryTreeItem.Module) {
                    RepositoryTree.openFile$default(this, (RepositoryTreeItem.Module)item, false, 2, null);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@Nullable KeyEvent e) {
                KeyEvent keyEvent = e;
                if (keyEvent != null) {
                    if (keyEvent.getKeyCode() == 10) {
                        RepositoryTreeItem item = this.getRepositoryItemFrom(this.getSelectionPath());
                        if (item != null && item instanceof RepositoryTreeItem.Module) {
                            RepositoryTree.openFile$default(this, (RepositoryTreeItem.Module)item, false, 2, null);
                        }
                    }
                }
            }
        });
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)((Object)this));
        TreeUtil.installActions((JTree)((JTree)((Object)this)));
    }

    public static final /* synthetic */ RepositoryTreeItem access$getSelectedRepositoryItem(RepositoryTree $this) {
        return $this.getSelectedRepositoryItem();
    }

    public static final /* synthetic */ DefaultMutableTreeNode access$getRootNode$p(RepositoryTree $this) {
        return $this.getRootNode();
    }

    public static final /* synthetic */ TreeSelectionModel access$getSelectionModel$p(RepositoryTree $this) {
        return $this.selectionModel;
    }

    public static final /* synthetic */ void access$setSelectionModel$p(RepositoryTree $this, TreeSelectionModel treeSelectionModel) {
        $this.selectionModel = treeSelectionModel;
    }
}

