/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.util.List;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Locatable;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.AnalyzeString;
import net.sf.saxon.expr.instruct.ApplyImports;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.CallTemplate;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.IterateInstr;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.NextMatch;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.BMPString;
import net.sf.saxon.regex.GeneralUnicodeString;
import net.sf.saxon.regex.LatinString;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import org.xml.sax.SAXException;

public class StandardErrorListener
implements UnfailingErrorListener {
    private int recoveryPolicy = 1;
    private int requestedRecoveryPolicy = 1;
    private int warningCount = 0;
    private int maximumNumberOfWarnings = 25;
    private int maxOrdinaryCharacter = 255;
    private int stackTraceDetail = 2;
    protected transient Logger logger = new StandardLogger();

    public StandardErrorListener makeAnother(int hostLanguage) {
        StandardErrorListener sel;
        try {
            sel = (StandardErrorListener)this.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            sel = new StandardErrorListener();
        }
        sel.logger = this.logger;
        return sel;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
        this.requestedRecoveryPolicy = policy;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public int getRequestedRecoveryPolicy() {
        return this.requestedRecoveryPolicy;
    }

    public void setMaximumNumberOfWarnings(int max) {
        this.maximumNumberOfWarnings = max;
    }

    public int getMaximumNumberOfWarnings() {
        return this.maximumNumberOfWarnings;
    }

    public void setStackTraceDetail(int level) {
        this.stackTraceDetail = level;
    }

    public int getStackTraceDetail() {
        return this.stackTraceDetail;
    }

    public void setMaxOrdinaryCharacter(int max) {
        this.maxOrdinaryCharacter = max;
    }

    public int getMaxOrdinaryCharacter(int max) {
        return this.maxOrdinaryCharacter;
    }

    @Override
    public void warning(TransformerException exception) {
        if (this.recoveryPolicy == 0) {
            return;
        }
        if (this.logger == null) {
            this.logger = new StandardLogger();
        }
        XPathException xe = XPathException.makeXPathException(exception);
        String message = this.constructMessage(exception, xe, "", "Warning ");
        if (exception instanceof ValidationException) {
            this.logger.error(message);
        } else {
            this.logger.warning(message);
            ++this.warningCount;
            if (this.warningCount > this.getMaximumNumberOfWarnings()) {
                this.logger.info("No more warnings will be displayed");
                this.recoveryPolicy = 0;
                this.warningCount = 0;
            }
        }
    }

    @Override
    public void error(TransformerException exception) {
        String message;
        if (this.recoveryPolicy == 0 && !(exception instanceof ValidationException)) {
            return;
        }
        if (this.logger == null) {
            this.logger = new StandardLogger();
        }
        if (exception instanceof ValidationException) {
            String explanation = this.getExpandedMessage(exception);
            ValidationFailure failure = ((ValidationException)exception).getValidationFailure();
            String constraintReference = failure.getConstraintReferenceMessage();
            String validationLocation = failure.getValidationLocationText();
            String contextLocation = failure.getContextLocationText();
            message = "Validation error " + this.getLocationMessage(exception) + "\n  " + StandardErrorListener.wordWrap(explanation) + StandardErrorListener.wordWrap(validationLocation.isEmpty() ? "" : "\n  " + validationLocation) + StandardErrorListener.wordWrap(contextLocation.isEmpty() ? "" : "\n  " + contextLocation) + StandardErrorListener.wordWrap(constraintReference == null ? "" : "\n  " + constraintReference) + StandardErrorListener.getOffenderListText(failure);
        } else {
            String prefix = this.recoveryPolicy == 1 ? "Recoverable error " : "Error ";
            message = this.constructMessage(exception, XPathException.makeXPathException(exception), "", prefix);
        }
        if (exception instanceof ValidationException) {
            this.logger.error(message);
        } else if (this.recoveryPolicy == 1) {
            this.logger.warning(message);
            ++this.warningCount;
            if (this.warningCount > this.getMaximumNumberOfWarnings()) {
                this.logger.info("No more warnings will be displayed");
                this.recoveryPolicy = 0;
                this.warningCount = 0;
            }
        } else {
            this.logger.error(message);
            this.logger.info("Processing terminated because error recovery is disabled");
        }
    }

    @Override
    public void fatalError(TransformerException exception) {
        XPathContext context;
        XPathException xe = XPathException.makeXPathException(exception);
        if (xe.hasBeenReported()) {
            return;
        }
        if (this.logger == null) {
            this.logger = new StandardLogger();
        }
        String lang = xe.getHostLanguage();
        String langText = "";
        if ("XPath".equals(lang)) {
            langText = "in expression ";
        } else if ("XQuery".equals(lang)) {
            langText = "in query ";
        } else if ("XSLT Pattern".equals(lang)) {
            langText = "in pattern ";
        }
        String kind = "Error ";
        if (xe.isSyntaxError()) {
            kind = "Syntax error ";
        } else if (xe.isStaticError()) {
            kind = "Static error ";
        } else if (xe.isTypeError()) {
            kind = "Type error ";
        }
        String message = this.constructMessage(exception, xe, langText, kind);
        this.logger.error(message);
        if (exception instanceof XPathException) {
            ((XPathException)exception).setHasBeenReported(true);
        }
        if (exception instanceof XPathException && (context = ((XPathException)exception).getXPathContext()) != null && this.getRequestedRecoveryPolicy() != 0 && !(context instanceof EarlyEvaluationContext)) {
            this.outputStackTrace(this.logger, context);
        }
    }

    private String constructMessage(TransformerException exception, XPathException xe, String langText, String kind) {
        String message;
        Expression failingExpression = null;
        if (exception instanceof XPathException) {
            failingExpression = ((XPathException)exception).getFailingExpression();
        }
        if (xe.getLocator() instanceof AttributeLocation) {
            String line1 = kind + langText + StandardErrorListener.getLocationMessageText(xe.getLocator()) + "\n";
            String line2 = "  " + StandardErrorListener.wordWrap(this.getExpandedMessage(exception));
            message = line1 + line2;
        } else if (xe.getLocator() instanceof XPathParser.NestedLocation) {
            XPathParser.NestedLocation nestedLoc = (XPathParser.NestedLocation)xe.getLocator();
            Location outerLoc = nestedLoc.getContainingLocation();
            if (outerLoc instanceof AttributeLocation) {
                String lineInfo;
                int line = nestedLoc.getLocalLineNumber();
                int column = nestedLoc.getColumnNumber();
                String innerLoc = "";
                String string = lineInfo = line <= 0 ? "" : "on line " + line + ' ';
                String columnInfo = column <= 0 ? "" : "at " + (line <= 0 ? "char " : "column ") + column + ' ';
                String nearBy = nestedLoc.getNearbyText();
                innerLoc = lineInfo + columnInfo;
                if (failingExpression != null) {
                    innerLoc = lineInfo + "evaluating (" + failingExpression.toShortString() + ") ";
                } else if (nearBy != null && !nearBy.isEmpty()) {
                    innerLoc = lineInfo + (nearBy.startsWith("...") ? "near" : "in") + ' ' + Err.wrap(nearBy) + ' ' + columnInfo;
                }
                String where = innerLoc;
                String line1 = kind + where + langText + StandardErrorListener.getLocationMessageText(outerLoc) + "\n";
                String line2 = "  " + StandardErrorListener.wordWrap(this.getExpandedMessage(exception));
                message = line1 + line2;
            } else {
                int line = nestedLoc.getLocalLineNumber();
                int column = nestedLoc.getColumnNumber();
                String innerLoc = "";
                innerLoc = innerLoc + (line < 0 ? "" : "on line " + (line + 1) + ' ');
                if (column >= 0) {
                    innerLoc = innerLoc + "at " + (line < 0 ? "char " : "column ") + (column + 1) + ' ';
                }
                if (outerLoc.getLineNumber() > 1) {
                    innerLoc = innerLoc + "(" + langText + "on line " + outerLoc.getLineNumber() + ") ";
                }
                if (outerLoc.getSystemId() != null) {
                    innerLoc = innerLoc + "of " + outerLoc.getSystemId() + " ";
                }
                String nearBy = nestedLoc.getNearbyText();
                if (failingExpression != null) {
                    innerLoc = innerLoc + "evaluating (" + failingExpression.toShortString() + ")";
                } else if (nearBy != null && !nearBy.isEmpty()) {
                    innerLoc = innerLoc + (nearBy.startsWith("...") ? "near" : "in") + ' ' + Err.wrap(nearBy) + ' ';
                }
                String line1 = kind + innerLoc + "\n";
                String line2 = "  " + StandardErrorListener.wordWrap(this.getExpandedMessage(exception));
                message = line1 + line2;
            }
        } else if (xe instanceof ValidationException) {
            String explanation = this.getExpandedMessage(exception);
            ValidationFailure failure = ((ValidationException)xe).getValidationFailure();
            String constraintReference = failure.getConstraintReferenceMessage();
            if (constraintReference != null) {
                explanation = explanation + " (" + constraintReference + ')';
            }
            message = "Validation error " + this.getLocationMessage(exception) + "\n  " + StandardErrorListener.wordWrap(explanation);
            message = message + StandardErrorListener.getOffenderListText(failure);
        } else {
            message = kind + (failingExpression != null ? "evaluating (" + failingExpression.toShortString() + ") " : "") + this.getLocationMessage(exception) + "\n  " + StandardErrorListener.wordWrap(this.getExpandedMessage(exception));
        }
        return this.expandSpecialCharacters(message).toString();
    }

    public static String getOffenderListText(ValidationFailure failure) {
        StringBuilder message = new StringBuilder();
        List<NodeInfo> offendingNodes = failure.getOffendingNodes();
        if (!offendingNodes.isEmpty()) {
            message.append("\n  Nodes for which the assertion fails:");
            for (NodeInfo offender : offendingNodes) {
                String nodeDesc = Type.displayTypeName(offender);
                if (offender.getNodeKind() == 3) {
                    nodeDesc = nodeDesc + " " + Err.wrap(offender.getStringValueCS(), 4);
                }
                if (offender.getLineNumber() != -1) {
                    nodeDesc = nodeDesc + " on line " + offender.getLineNumber();
                    if (offender.getColumnNumber() != -1) {
                        nodeDesc = nodeDesc + " column " + offender.getColumnNumber();
                    }
                    if (offender.getSystemId() != null) {
                        nodeDesc = nodeDesc + " of " + offender.getSystemId();
                    }
                } else {
                    nodeDesc = nodeDesc + " at " + Navigator.getPath(offender);
                }
                message.append("\n  * ").append(nodeDesc);
            }
        }
        return message.toString();
    }

    protected void outputStackTrace(Logger out, XPathContext context) {
        StandardErrorListener.printStackTrace(context, out, this.stackTraceDetail);
    }

    public String getLocationMessage(TransformerException err) {
        SourceLocator loc = err.getLocator();
        while (loc == null) {
            if (err.getException() instanceof TransformerException) {
                err = (TransformerException)err.getException();
                loc = err.getLocator();
                continue;
            }
            if (err.getCause() instanceof TransformerException) {
                err = (TransformerException)err.getCause();
                loc = err.getLocator();
                continue;
            }
            return "";
        }
        return StandardErrorListener.getLocationMessageText(loc);
    }

    public static String getLocationMessageText(SourceLocator loc) {
        boolean containsLineNumber;
        String path;
        String locMessage = "";
        String systemId = null;
        NodeInfo node = null;
        String nodeMessage = null;
        int lineNumber = -1;
        if (loc == null) {
            loc = ExplicitLocation.UNKNOWN_LOCATION;
        }
        if (loc instanceof XPathParser.NestedLocation) {
            loc = ((XPathParser.NestedLocation)loc).getContainingLocation();
        }
        if (loc instanceof AttributeLocation) {
            AttributeLocation saLoc = (AttributeLocation)loc;
            nodeMessage = "in " + saLoc.getElementName().getDisplayName();
            if (saLoc.getAttributeName() != null) {
                nodeMessage = nodeMessage + "/@" + saLoc.getAttributeName();
            }
            nodeMessage = nodeMessage + ' ';
        } else if (loc instanceof DOMLocator) {
            nodeMessage = "at " + ((DOMLocator)loc).getOriginatingNode().getNodeName() + ' ';
        } else if (loc instanceof NodeInfo) {
            node = (NodeInfo)loc;
            nodeMessage = "at " + node.getDisplayName() + ' ';
        } else if (loc instanceof ValidationException && (node = ((ValidationException)((Object)loc)).getNode()) != null) {
            nodeMessage = "at " + node.getDisplayName() + ' ';
        } else if (loc instanceof ValidationException && loc.getLineNumber() == -1 && (path = ((ValidationException)((Object)loc)).getPath()) != null) {
            nodeMessage = "at " + path + ' ';
        } else if (loc instanceof Instruction) {
            String instructionName = StandardErrorListener.getInstructionName((Instruction)((Object)loc));
            if (!"".equals(instructionName)) {
                nodeMessage = "at " + instructionName + ' ';
            }
            systemId = loc.getSystemId();
            lineNumber = loc.getLineNumber();
        } else if (loc instanceof Actor) {
            String kind = "procedure";
            if (loc instanceof UserFunction) {
                kind = "function";
            } else if (loc instanceof NamedTemplate) {
                kind = "template";
            } else if (loc instanceof AttributeSet) {
                kind = "attribute-set";
            } else if (loc instanceof KeyDefinition) {
                kind = "key";
            }
            systemId = loc.getSystemId();
            lineNumber = loc.getLineNumber();
            nodeMessage = "at " + kind + " ";
            StructuredQName name = ((InstructionInfo)loc).getObjectName();
            if (name != null) {
                nodeMessage = nodeMessage + name.toString();
                nodeMessage = nodeMessage + " ";
            }
        }
        if (lineNumber == -1) {
            lineNumber = loc.getLineNumber();
        }
        boolean bl = containsLineNumber = lineNumber != -1;
        if (node != null && !containsLineNumber) {
            nodeMessage = "at " + Navigator.getPath(node) + ' ';
        }
        if (nodeMessage != null) {
            locMessage = locMessage + nodeMessage;
        }
        if (containsLineNumber) {
            locMessage = locMessage + "on line " + lineNumber + ' ';
            if (loc.getColumnNumber() != -1) {
                locMessage = locMessage + "column " + loc.getColumnNumber() + ' ';
            }
        }
        if (systemId != null && systemId.isEmpty()) {
            systemId = null;
        }
        if (systemId == null) {
            try {
                systemId = loc.getSystemId();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        if (systemId != null && !systemId.isEmpty()) {
            locMessage = locMessage + (containsLineNumber ? "of " : "in ") + StandardErrorListener.abbreviatePath(systemId) + ':';
        }
        return locMessage;
    }

    public static String abbreviatePath(String uri) {
        if (uri == null) {
            return "*unknown*";
        }
        int slash = uri.lastIndexOf(47);
        if (slash >= 0 && slash < uri.length() - 1) {
            return uri.substring(slash + 1);
        }
        return uri;
    }

    public String getExpandedMessage(TransformerException err) {
        String errorObjectDesc;
        Sequence<?> errorObject;
        StructuredQName qCode = null;
        if (err instanceof XPathException) {
            qCode = ((XPathException)err).getErrorCodeQName();
        }
        if (qCode == null && err.getException() instanceof XPathException) {
            qCode = ((XPathException)err.getException()).getErrorCodeQName();
        }
        String message = "";
        if (qCode != null) {
            message = qCode.hasURI("http://www.w3.org/2005/xqt-errors") ? qCode.getLocalPart() : qCode.getDisplayName();
        }
        if (err instanceof XPathException && (errorObject = ((XPathException)err).getErrorObject()) != null && (errorObjectDesc = this.getErrorObjectString(errorObject)) != null) {
            message = message + " " + errorObjectDesc;
        }
        Throwable e = err;
        while (e != null) {
            String next = e.getMessage();
            if (next == null) {
                next = "";
            }
            if (next.startsWith("net.sf.saxon.trans.XPathException: ")) {
                next = next.substring(next.indexOf(": ") + 2);
            }
            if (!"TRaX Transform Exception".equals(next) && !message.endsWith(next)) {
                if (!"".equals(message) && !message.trim().endsWith(":")) {
                    message = message + ": ";
                }
                message = message + next;
            }
            if (e instanceof TransformerException) {
                e = e.getException();
                continue;
            }
            if (!(e instanceof SAXException)) break;
            e = ((SAXException)e).getException();
        }
        return message;
    }

    public String getErrorObjectString(Sequence<?> errorObject) {
        return null;
    }

    public static String getInstructionName(Instruction inst) {
        try {
            int construct = inst.getInstructionNameCode();
            if (construct < 0) {
                return "";
            }
            if (construct < 1024 && construct != 158 && construct != 200) {
                if (inst.getPackageData().getHostLanguage() == 50) {
                    return StandardNames.getDisplayName(construct);
                }
                String s = StandardNames.getDisplayName(construct);
                int colon = s.indexOf(58);
                if (colon > 0) {
                    String local = s.substring(colon + 1);
                    if (local.equals("document")) {
                        return "document node constructor";
                    }
                    if (local.equals("text") || s.equals("value-of")) {
                        return "text node constructor";
                    }
                    if (local.equals("element")) {
                        return "computed element constructor";
                    }
                    if (local.equals("attribute")) {
                        return "computed attribute constructor";
                    }
                    if (local.equals("variable")) {
                        return "variable declaration";
                    }
                    if (local.equals("param")) {
                        return "external variable declaration";
                    }
                    if (local.equals("comment")) {
                        return "comment constructor";
                    }
                    if (local.equals("processing-instruction")) {
                        return "processing-instruction constructor";
                    }
                    if (local.equals("namespace")) {
                        return "namespace node constructor";
                    }
                }
                return s;
            }
            switch (construct) {
                case 2006: {
                    StructuredQName qName = inst.getObjectName();
                    return "element constructor <" + qName.getDisplayName() + '>';
                }
                case 2007: {
                    StructuredQName qName = inst.getObjectName();
                    return "attribute constructor " + qName.getDisplayName() + "=\"{...}\"";
                }
            }
            return "";
        }
        catch (Exception err) {
            return "";
        }
    }

    public static String wordWrap(String message) {
        int nl;
        if (message.length() > 1000) {
            message = message.substring(0, 1000);
        }
        if ((nl = message.indexOf(10)) < 0) {
            nl = message.length();
        }
        if (nl > 100) {
            int i;
            for (i = 90; message.charAt(i) != ' ' && i > 0; --i) {
            }
            if (i > 10) {
                return message.substring(0, i) + "\n  " + StandardErrorListener.wordWrap(message.substring(i + 1));
            }
            return message;
        }
        if (nl < message.length()) {
            return message.substring(0, nl) + '\n' + StandardErrorListener.wordWrap(message.substring(nl + 1));
        }
        return message;
    }

    public static void printStackTrace(XPathContext context, Logger out, int level) {
        if (level > 0) {
            int depth = 20;
            while (depth-- > 0) {
                if (level > 0) {
                    Component component = context.getCurrentComponent();
                    if (component != null) {
                        if (component.getActor() instanceof Mode) {
                            Rule rule = context.getCurrentTemplateRule();
                            if (rule != null) {
                                StringBuilder sb = new StringBuilder();
                                Location loc = rule.getPattern().getLocation();
                                sb.append("  In template rule with match=\"").append(rule.getPattern().toShortString()).append("\" ");
                                if (loc != null && loc.getLineNumber() != -1) {
                                    sb.append("on line ").append(loc.getLineNumber()).append(" ");
                                }
                                if (loc != null && loc.getSystemId() != null) {
                                    sb.append("of ").append(StandardErrorListener.abbreviatePath(loc.getSystemId()));
                                }
                                out.error(sb.toString());
                            }
                        } else {
                            out.error(StandardErrorListener.getLocationMessageText(component.getActor()).replace("$at ", "In "));
                        }
                    }
                    context.getStackFrame().getStackFrameMap().showStackFrame(context, out);
                }
                while (!(context instanceof XPathContextMajor)) {
                    context = context.getCaller();
                }
                ContextOriginator originator = ((XPathContextMajor)context).getOrigin();
                if (originator instanceof Controller) {
                    return;
                }
                out.error("     invoked by " + StandardErrorListener.showOriginator(originator));
                if ((context = context.getCaller()) != null) continue;
                return;
            }
        }
    }

    private static String showOriginator(ContextOriginator originator) {
        Location loc;
        StringBuilder sb = new StringBuilder();
        if (originator == null) {
            sb.append("unknown caller (null)");
        } else if (originator instanceof ApplyTemplates) {
            sb.append("xsl:apply-templates");
        } else if (originator instanceof NextMatch) {
            sb.append("xsl:next-match");
        } else if (originator instanceof ApplyImports) {
            sb.append("xsl:apply-imports");
        } else if (originator instanceof UserFunctionCall) {
            sb.append("function call");
        } else if (originator instanceof CallTemplate) {
            sb.append("xsl:call-template");
        } else if (originator instanceof Controller) {
            sb.append("external application");
        } else if (originator instanceof BuiltInRuleSet) {
            sb.append("built-in template rule (" + ((BuiltInRuleSet)originator).getName() + ")");
        } else if (originator instanceof IterateInstr) {
            sb.append("xsl:iterate");
        } else if (originator instanceof ForEachGroup) {
            sb.append("xsl:for-each-group");
        } else if (originator instanceof AnalyzeString) {
            sb.append("xsl:analyze-string");
        } else if (originator instanceof ResultDocument) {
            sb.append("xsl:result-document");
        } else if (originator instanceof KeyDefinition) {
            sb.append("xsl:key definition");
        } else if (originator instanceof GlobalParam) {
            sb.append("global xsl:param");
        } else if (originator instanceof GlobalVariable) {
            sb.append("global xsl:variable");
        } else {
            sb.append("unknown caller (" + originator.getClass() + ")");
        }
        if (originator instanceof Locatable && (loc = ((Locatable)((Object)originator)).getLocation()).getLineNumber() != -1) {
            sb.append(" at ").append(loc.getSystemId() == null ? "line " : loc.getSystemId() + "#");
            sb.append(loc.getLineNumber());
        }
        return sb.toString();
    }

    public CharSequence expandSpecialCharacters(CharSequence in) {
        if (this.logger.isUnicodeAware()) {
            return in;
        }
        return StandardErrorListener.expandSpecialCharacters(in, this.maxOrdinaryCharacter);
    }

    public static CharSequence expandSpecialCharacters(CharSequence in, int threshold) {
        if (threshold >= 0x10FFFF) {
            return in;
        }
        int max = 0;
        boolean isAstral = false;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c > max) {
                max = c;
            }
            if (!UTF16CharacterSet.isSurrogate(c)) continue;
            isAstral = true;
        }
        if (max <= threshold && !isAstral) {
            return in;
        }
        UnicodeString str = max <= 255 ? new LatinString(in) : (!isAstral ? new BMPString(in) : new GeneralUnicodeString(in));
        FastStringBuffer fsb = new FastStringBuffer(str.uLength() * 2);
        for (int i = 0; i < str.uLength(); ++i) {
            int ch = str.uCharAt(i);
            fsb.appendWideChar(ch);
            if (ch <= threshold) continue;
            fsb.append("[x");
            fsb.append(Integer.toHexString(ch));
            fsb.append("]");
        }
        return fsb;
    }
}

