/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.event;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;

public class DocumentEventImpl
extends DocumentEvent {
    private final int myOffset;
    @NotNull
    private final CharSequence myOldString;
    private final int myOldLength;
    @NotNull
    private final CharSequence myNewString;
    private final int myNewLength;
    private final long myOldTimeStamp;
    private final boolean myIsWholeDocReplaced;
    private Diff.Change myChange;
    private static final Diff.Change TOO_BIG_FILE = new Diff.Change(0, 0, 0, 0, null);
    private final int myInitialStartOffset;
    private final int myInitialOldLength;
    private final int myMoveOffset;

    /*
     * WARNING - void declaration
     */
    public DocumentEventImpl(@NotNull Document document2, int offset2, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp, boolean bl) {
        void wholeTextReplaced;
        if (document2 == null) {
            DocumentEventImpl.$$$reportNull$$$0(0);
        }
        if (oldString == null) {
            DocumentEventImpl.$$$reportNull$$$0(1);
        }
        if (newString == null) {
            DocumentEventImpl.$$$reportNull$$$0(2);
        }
        this(document2, offset2, oldString, newString, oldTimeStamp, (boolean)wholeTextReplaced, offset2, oldString.length(), offset2);
    }

    /*
     * WARNING - void declaration
     */
    public DocumentEventImpl(@NotNull Document document2, int offset2, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp, boolean wholeTextReplaced, int initialStartOffset, int initialOldLength, int n) {
        void moveOffset;
        if (document2 == null) {
            DocumentEventImpl.$$$reportNull$$$0(3);
        }
        if (oldString == null) {
            DocumentEventImpl.$$$reportNull$$$0(4);
        }
        if (newString == null) {
            DocumentEventImpl.$$$reportNull$$$0(5);
        }
        super(document2);
        this.myOffset = offset2;
        this.myOldString = oldString;
        this.myOldLength = oldString.length();
        this.myNewString = newString;
        this.myNewLength = newString.length();
        this.myInitialStartOffset = initialStartOffset;
        this.myInitialOldLength = initialOldLength;
        this.myMoveOffset = moveOffset;
        this.myOldTimeStamp = oldTimeStamp;
        boolean bl = this.myIsWholeDocReplaced = this.getDocument().getTextLength() != 0 && wholeTextReplaced;
        assert (initialStartOffset >= 0) : initialStartOffset;
        assert (initialOldLength >= 0) : initialOldLength;
        assert (moveOffset == offset2 || this.myOldLength == 0 || this.myNewLength == 0) : this;
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public int getOldLength() {
        return this.myOldLength;
    }

    @Override
    public int getNewLength() {
        return this.myNewLength;
    }

    @Override
    @NotNull
    public CharSequence getOldFragment() {
        CharSequence charSequence2 = this.myOldString;
        if (charSequence2 == null) {
            DocumentEventImpl.$$$reportNull$$$0(6);
        }
        return charSequence2;
    }

    @Override
    @NotNull
    public CharSequence getNewFragment() {
        CharSequence charSequence2 = this.myNewString;
        if (charSequence2 == null) {
            DocumentEventImpl.$$$reportNull$$$0(7);
        }
        return charSequence2;
    }

    public int getInitialStartOffset() {
        return this.myInitialStartOffset;
    }

    public int getInitialOldLength() {
        return this.myInitialOldLength;
    }

    @Override
    public int getMoveOffset() {
        return this.myMoveOffset;
    }

    @Override
    public long getOldTimeStamp() {
        return this.myOldTimeStamp;
    }

    @Override
    public String toString() {
        return "DocumentEventImpl[myOffset=" + this.myOffset + ", myOldLength=" + this.myOldLength + ", myNewLength=" + this.myNewLength + "]" + (this.isWholeTextReplaced() ? " Whole." : ".");
    }

    @Override
    public boolean isWholeTextReplaced() {
        return this.myIsWholeDocReplaced;
    }

    public int translateLineViaDiffStrict(int line) throws FilesTooBigForDiffException {
        Diff.Change change = this.reBuildDiffIfNeeded();
        if (change == null) {
            return line;
        }
        int startLine = this.getDocument().getLineNumber(this.getOffset());
        if (line < startLine) {
            return line;
        }
        int translatedRelative = Diff.translateLine(change, line - startLine);
        return translatedRelative < 0 ? -1 : translatedRelative + startLine;
    }

    private Diff.Change reBuildDiffIfNeeded() throws FilesTooBigForDiffException {
        if (this.myChange == TOO_BIG_FILE) {
            throw new FilesTooBigForDiffException();
        }
        if (this.myChange == null) {
            try {
                this.myChange = Diff.buildChanges(this.myOldString, this.myNewString);
            }
            catch (FilesTooBigForDiffException e) {
                this.myChange = TOO_BIG_FILE;
                throw e;
            }
        }
        return this.myChange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldString";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newString";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/event/DocumentEventImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/event/DocumentEventImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldFragment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

