/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbi;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbiKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.MemoizedValueClassAbstractReplacements;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InheritedDefaultMethodsOnClassesLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmValueClassAbstractLowering;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J*\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020\nH\u0002J\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u0018\u0010$\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\"H\u0014J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010-\u001a\u00020\"2\u0006\u0010+\u001a\u00020\"H\u0014J0\u0010.\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u000200\u0012\u0006\u0012\u0004\u0018\u00010\u001a0/0(2\u0006\u0010-\u001a\u0002012\n\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0002J\u0010\u00104\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\u000bH\u0016J\u0010\u00105\u001a\u00020\u001a2\u0006\u00102\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u001a2\u0006\u00102\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u001a2\u0006\u00102\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u001a2\u0006\u00102\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u001a2\u0006\u00102\u001a\u00020>H\u0016J,\u0010?\u001a\u00020\u000e*\u0006\u0012\u0002\b\u0003032\u0006\u0010@\u001a\u0002012\n\u0010A\u001a\u0006\u0012\u0002\b\u0003032\u0006\u0010+\u001a\u00020\"H\u0002J\f\u0010B\u001a\u00020\u001a*\u00020\u001aH\u0002J\f\u0010C\u001a\u00020\n*\u000201H\u0016J\f\u0010D\u001a\u00020\n*\u00020\u0010H\u0016J\f\u0010E\u001a\u00020\n*\u00020\"H\u0002J\u001e\u0010F\u001a\u0004\u0018\u00010\u001a*\u00020G2\u0006\u0010H\u001a\u00020\u001a2\u0006\u0010I\u001a\u00020\u001aH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\f\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInlineClassLowering;", "Lorg/jetbrains/kotlin/backend/jvm/lower/JvmValueClassAbstractLowering;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "replacements", "Lorg/jetbrains/kotlin/backend/jvm/MemoizedValueClassAbstractReplacements;", "getReplacements", "()Lorg/jetbrains/kotlin/backend/jvm/MemoizedValueClassAbstractReplacements;", "isSpecializedInlineClassEqEq", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Z", "addJvmInlineAnnotation", "", "valueClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "buildBoxFunction", "buildPrimaryValueClassConstructor", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildSpecializedEqualsMethod", "buildUnboxFunction", "irClass", "buildUnboxFunctions", "coerceInlineClasses", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "argument", "from", "Lorg/jetbrains/kotlin/ir/types/IrType;", "to", "skipCast", "createBridgeBody", "source", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "target", "createBridgeDeclaration", "mangledName", "Lorg/jetbrains/kotlin/name/Name;", "transformConstructorFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "constructor", "replacement", "transformSimpleFunctionFlat", "function", "typedArgumentList", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitCall", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "buildReplacement", "originalFunction", "original", "coerceToUnboxed", "isSpecificFieldGetter", "isSpecificLoweringLogicApplicable", "signatureRequiresMangling", "specializeEqualsCall", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "left", "right", "backend.jvm.lower"})
final class JvmInlineClassLowering
extends JvmValueClassAbstractLowering {
    public JvmInlineClassLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        super(context);
    }

    @Override
    @NotNull
    public MemoizedValueClassAbstractReplacements getReplacements() {
        return this.getContext().getInlineClassReplacements();
    }

    @Override
    public boolean isSpecificLoweringLogicApplicable(@NotNull IrClass $this$isSpecificLoweringLogicApplicable) {
        Intrinsics.checkNotNullParameter($this$isSpecificLoweringLogicApplicable, "<this>");
        return IrDeclarationsKt.isSingleFieldValueClass($this$isSpecificLoweringLogicApplicable);
    }

    @Override
    public boolean isSpecificFieldGetter(@NotNull IrFunction $this$isSpecificFieldGetter) {
        Intrinsics.checkNotNullParameter($this$isSpecificFieldGetter, "<this>");
        return InlineClassAbiKt.isInlineClassFieldGetter($this$isSpecificFieldGetter);
    }

    @Override
    protected void addJvmInlineAnnotation(@NotNull IrClass valueClass) {
        Intrinsics.checkNotNullParameter(valueClass, "valueClass");
        if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)valueClass, InlineClassesUtilsKt.getJVM_INLINE_ANNOTATION_FQ_NAME())) {
            return;
        }
        IrConstructorSymbol constructor2 = SequencesKt.first(IrUtilsKt.getConstructors(this.getContext().getIr().getSymbols().getJvmInlineAnnotation()));
        valueClass.setAnnotations(CollectionsKt.plus((Collection)valueClass.getAnnotations(), IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, ((IrConstructor)constructor2.getOwner()).getReturnType(), constructor2, null, 4, null)));
    }

    @Override
    @NotNull
    protected List<IrDeclaration> transformSimpleFunctionFlat(@NotNull IrSimpleFunction function2, @NotNull IrSimpleFunction replacement) {
        Name name;
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(replacement, "replacement");
        Iterable $this$forEach$iv = replacement.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            this.transformChildrenVoid(it);
            IrExpressionBody irExpressionBody = it.getDefaultValue();
            if (irExpressionBody == null) continue;
            IrExpressionBody cfr_ignored_0 = (IrExpressionBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irExpressionBody, replacement);
        }
        UtilsKt.push(this.getAllScopes(), this.createScope(function2));
        IrElement irElement = function2.getBody();
        replacement.setBody(irElement != null && (irElement = irElement.transform((IrElementTransformer)this, (Object)null)) != null ? (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irElement, replacement) : null);
        UtilsKt.pop(this.getAllScopes());
        IrDeclarationsKt.copyAttributes((IrAttributeContainer)replacement, function2);
        if (function2.getOverriddenSymbols().isEmpty() || replacement.getDispatchReceiverParameter() != null) {
            return CollectionsKt.listOf(replacement);
        }
        if ((!function2.isFakeOverride() || InheritedDefaultMethodsOnClassesLoweringKt.findInterfaceImplementation(function2, this.getContext().getState().getJvmDefaultMode()) != null) && this.signatureRequiresMangling(function2)) {
            name = replacement.getName();
        } else if (AdditionalIrUtilsKt.isGetter(replacement)) {
            IrPropertySymbol irPropertySymbol = replacement.getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull(irPropertySymbol);
            String string2 = ((IrProperty)irPropertySymbol.getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "replacement.correspondin\u2026l!!.owner.name.asString()");
            Name name2 = Name.identifier(JvmAbi.getterName(string2));
            name = name2;
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(JvmAbi.getter\u2026!.owner.name.asString()))");
        } else if (AdditionalIrUtilsKt.isSetter(replacement)) {
            IrPropertySymbol irPropertySymbol = replacement.getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull(irPropertySymbol);
            String string3 = ((IrProperty)irPropertySymbol.getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string3, "replacement.correspondin\u2026l!!.owner.name.asString()");
            Name name3 = Name.identifier(JvmAbi.setterName(string3));
            name = name3;
            Intrinsics.checkNotNullExpressionValue(name3, "identifier(JvmAbi.setter\u2026!.owner.name.asString()))");
        } else {
            name = function2.getName();
        }
        IrSimpleFunction bridgeFunction = this.createBridgeDeclaration(function2, name);
        bridgeFunction.setOverriddenSymbols(replacement.getOverriddenSymbols());
        if (bridgeFunction.isFakeOverride() && IrDeclarationsKt.isSingleFieldValueClass(IrUtilsKt.getParentAsClass(bridgeFunction))) {
            this.createBridgeBody(replacement, bridgeFunction);
        } else {
            this.createBridgeBody(bridgeFunction, replacement);
        }
        IrSimpleFunction[] irSimpleFunctionArray = new IrSimpleFunction[]{replacement, bridgeFunction};
        return CollectionsKt.listOf(irSimpleFunctionArray);
    }

    private final boolean signatureRequiresMangling(IrSimpleFunction $this$signatureRequiresMangling) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = InlineClassAbiKt.getFullValueParameterList($this$signatureRequiresMangling);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv;
                    boolean bl2 = false;
                    if (!InlineClassAbiKt.getRequiresMangling(it.getType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl || this.getContext().getState().getFunctionsWithInlineClassReturnTypesMangled() && InlineClassAbiKt.getRequiresMangling($this$signatureRequiresMangling.getReturnType());
    }

    private final IrSimpleFunction createBridgeDeclaration(IrSimpleFunction source, Name mangledName) {
        IrSimpleFunction irSimpleFunction;
        IrFactory $this$buildFun$iv = this.getContext().getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createBridgeDeclaration_u24lambda_u2d2 = $this$buildFun_u24lambda_u2d16$iv;
        boolean bl2 = false;
        $this$createBridgeDeclaration_u24lambda_u2d2.updateFrom(source);
        $this$createBridgeDeclaration_u24lambda_u2d2.setName(mangledName);
        $this$createBridgeDeclaration_u24lambda_u2d2.setReturnType(source.getReturnType());
        IrSimpleFunction $this$createBridgeDeclaration_u24lambda_u2d3 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
        boolean bl3 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyParameterDeclarationsFrom($this$createBridgeDeclaration_u24lambda_u2d3, source);
        $this$createBridgeDeclaration_u24lambda_u2d3.setAnnotations(source.getAnnotations());
        $this$createBridgeDeclaration_u24lambda_u2d3.setParent(source.getParent());
        IrDeclarationsKt.copyAttributes((IrAttributeContainer)$this$createBridgeDeclaration_u24lambda_u2d3, source);
        return irSimpleFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final void createBridgeBody(IrSimpleFunction source, IrSimpleFunction target) {
        void $this$createBridgeBody_u24lambda_u2d5_u24lambda_u2d4;
        void $this$createBridgeBody_u24lambda_u2d5;
        IrFunctionAccessExpression irFunctionAccessExpression;
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.getContext(), (IrSymbol)source.getSymbol(), source.getStartOffset(), source.getEndOffset());
        IrSimpleFunction irSimpleFunction = source;
        boolean bl = false;
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createBridgeBody_u24lambda_u2d5, target);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createBridgeBody_u24lambda_u2d5;
        boolean bl2 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$createBridgeBody_u24lambda_u2d5_u24lambda_u2d4, source, 0, 2, null);
        for (Pair pair : CollectionsKt.zip((Iterable)IrUtilsKt.getExplicitParameters(source), (Iterable)IrUtilsKt.getExplicitParameters(target))) {
            IrValueParameter parameter = (IrValueParameter)pair.component1();
            IrValueParameter newParameter = (IrValueParameter)pair.component2();
            IrExpressionsKt.putArgument((IrFunctionAccessExpression)$this$createBridgeBody_u24lambda_u2d5_u24lambda_u2d4, newParameter, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createBridgeBody_u24lambda_u2d5, parameter));
        }
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope, irFunctionAccessExpression));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<IrDeclaration> transformConstructorFlat(@NotNull IrConstructor constructor2, @NotNull IrSimpleFunction replacement) {
        void $this$transformConstructorFlat_u24lambda_u2d8;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        Intrinsics.checkNotNullParameter(replacement, "replacement");
        Iterable $this$forEach$iv = replacement.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            this.transformChildrenVoid(it);
        }
        IrGeneratorWithScope $this$irBlockBody$iv = LowerUtilsKt.createIrBuilder(this.getContext(), (IrSymbol)replacement.getSymbol(), replacement.getStartOffset(), replacement.getEndOffset());
        boolean $i$f$irBlockBody = false;
        IrGeneratorWithScope irGeneratorWithScope = $this$irBlockBody$iv;
        int element$iv = ((IrElement)replacement).getStartOffset();
        int endOffset$iv$iv = ((IrElement)replacement).getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        void var11_13 = this_$iv$iv$iv;
        IrSimpleFunction irSimpleFunction = replacement;
        boolean bl = false;
        IrType irType = replacement.getReturnType();
        IrVariable thisVar = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$transformConstructorFlat_u24lambda_u2d8, null, "$this", irType, false, 9, null);
        Map<IrValueSymbol, IrValueDeclaration> map = this.getValueMap();
        IrValueParameter irValueParameter = AdditionalIrUtilsKt.getConstructedClass(constructor2).getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        map.put(irValueParameter.getSymbol(), thisVar);
        Object object = constructor2.getBody();
        if (object != null && (object = IrUtilsKt.getStatements((IrBody)object)) != null) {
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrStatement statement2 = (IrStatement)element$iv2;
                boolean bl2 = false;
                $this$transformConstructorFlat_u24lambda_u2d8.unaryPlus((IrStatement)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)IrElementsKt.transformStatement(IrElementsKt.transformStatement(statement2, new IrElementTransformerVoid((IrBlockBodyBuilder)$this$transformConstructorFlat_u24lambda_u2d8, thisVar, constructor2){
                    final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody;
                    final /* synthetic */ IrVariable $thisVar;
                    final /* synthetic */ IrConstructor $constructor;
                    {
                        this.$this_irBlockBody = $receiver;
                        this.$thisVar = $thisVar;
                        this.$constructor = $constructor;
                    }

                    @NotNull
                    public IrStatement visitClass(@NotNull IrClass declaration) {
                        Intrinsics.checkNotNullParameter(declaration, "declaration");
                        return declaration;
                    }

                    @NotNull
                    public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        this.transformChildrenVoid(expression2);
                        return ExpressionHelpersKt.irSet$default((IrBuilderWithScope)this.$this_irBlockBody, this.$thisVar.getSymbol(), (IrExpression)expression2, null, 4, null);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public IrExpression visitReturn(@NotNull IrReturn expression2) {
                        void $this$visitReturn_u24lambda_u2d0;
                        void this_$iv$iv;
                        void endOffset$iv;
                        void startOffset$iv;
                        void $this$irBlock_u24default$iv;
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        this.transformChildrenVoid(expression2);
                        if (!Intrinsics.areEqual(expression2.getReturnTargetSymbol(), this.$constructor.getSymbol())) {
                            return expression2;
                        }
                        IrBuilderWithScope irBuilderWithScope = this.$this_irBlockBody;
                        int n = expression2.getStartOffset();
                        int n2 = expression2.getEndOffset();
                        IrVariable irVariable2 = this.$thisVar;
                        IrStatementOrigin origin$iv = null;
                        IrType resultType$iv = null;
                        boolean $i$f$irBlock = false;
                        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                        boolean $i$f$block = false;
                        void var11_11 = this_$iv$iv;
                        IrBuilderWithScope irBuilderWithScope2 = this.$this_irBlockBody;
                        boolean bl = false;
                        $this$visitReturn_u24lambda_u2d0.unaryPlus(expression2.getValue());
                        $this$visitReturn_u24lambda_u2d0.unaryPlus(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitReturn_u24lambda_u2d0, irVariable2));
                        return ExpressionHelpersKt.irReturn(irBuilderWithScope2, this_$iv$iv.doBuild());
                    }
                }), this), replacement));
            }
        }
        $this$transformConstructorFlat_u24lambda_u2d8.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$transformConstructorFlat_u24lambda_u2d8, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$transformConstructorFlat_u24lambda_u2d8, thisVar)));
        irSimpleFunction.setBody(this_$iv$iv$iv.doBuild());
        return CollectionsKt.listOf(replacement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<IrValueParameter, IrExpression>> typedArgumentList(IrFunction function2, IrMemberAccessExpression<?> expression2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair<Object, IrExpression> pair;
        Pair<void, IrExpression> pair2;
        Pair<Object, IrExpression> pair3;
        IrValueParameter it;
        Object object;
        int n;
        Object object2;
        Pair[] pairArray = object2 = new Pair[2];
        int n2 = 0;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter irValueParameter2 = irValueParameter;
            n = n2;
            object = pairArray;
            boolean bl = false;
            pair3 = TuplesKt.to(it, expression2.getDispatchReceiver());
            pairArray = object;
            n2 = n;
            pair2 = pair3;
        } else {
            pair2 = null;
        }
        pairArray[n2] = pair2;
        Pair[] pairArray2 = object2;
        int n3 = 1;
        IrValueParameter irValueParameter3 = function2.getExtensionReceiverParameter();
        if (irValueParameter3 != null) {
            it = irValueParameter3;
            n = n3;
            object = pairArray2;
            boolean bl = false;
            pair3 = TuplesKt.to(it, expression2.getExtensionReceiver());
            pairArray2 = object;
            n3 = n;
            pair = pair3;
        } else {
            pair = null;
        }
        pairArray2[n3] = pair;
        Collection collection = CollectionsKt.listOfNotNull(object2);
        object2 = function2.getValueParameters();
        object = collection;
        boolean $i$f$map = false;
        void var5_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IrValueParameter irValueParameter4 = (IrValueParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(TuplesKt.to(it2, expression2.getValueArgument(it2.getIndex())));
        }
        return CollectionsKt.plus(object, (Iterable)((List)destination$iv$iv));
    }

    private final void buildReplacement(IrMemberAccessExpression<?> $this$buildReplacement, IrFunction originalFunction, IrMemberAccessExpression<?> original, IrSimpleFunction replacement) {
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default($this$buildReplacement, original, 0, 2, null);
        Map valueParameterMap = MapsKt.toMap(CollectionsKt.zip((Iterable)IrUtilsKt.getExplicitParameters(originalFunction), (Iterable)IrUtilsKt.getExplicitParameters(replacement)));
        for (Pair<IrValueParameter, IrExpression> pair : this.typedArgumentList(originalFunction, original)) {
            IrValueParameter parameter = pair.component1();
            IrExpression argument2 = pair.component2();
            if (argument2 == null) continue;
            IrValueParameter newParameter = (IrValueParameter)MapsKt.getValue(valueParameterMap, parameter);
            IrMemberAccessExpressionKt.putArgument($this$buildReplacement, replacement, newParameter, (IrExpression)argument2.transform((IrElementTransformer)this, (Object)null));
        }
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrFunctionReferenceImpl irFunctionReferenceImpl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (Intrinsics.areEqual(expression2.getOrigin(), InlineClassAbi.UNMANGLED_FUNCTION_REFERENCE.INSTANCE)) {
            return super.visitFunctionReference(expression2);
        }
        IrFunction function2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrSimpleFunction irSimpleFunction = this.getContext().getInlineClassReplacements().getGetReplacementFunction().invoke(function2);
        if (irSimpleFunction == null) {
            return super.visitFunctionReference(expression2);
        }
        IrSimpleFunction replacement = irSimpleFunction;
        IrFunctionReferenceImpl $this$visitFunctionReference_u24lambda_u2d12 = irFunctionReferenceImpl = new IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), replacement.getSymbol(), function2.getTypeParameters().size(), replacement.getValueParameters().size(), expression2.getReflectionTarget(), expression2.getOrigin());
        boolean bl = false;
        this.buildReplacement($this$visitFunctionReference_u24lambda_u2d12, function2, expression2, replacement);
        return (IrExpression)IrDeclarationsKt.copyAttributes((IrAttributeContainer)irFunctionReferenceImpl, expression2);
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrCallImpl irCallImpl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrFunction function2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrSimpleFunction irSimpleFunction = this.getContext().getInlineClassReplacements().getGetReplacementFunction().invoke(function2);
        if (irSimpleFunction == null) {
            return super.visitFunctionAccess(expression2);
        }
        IrSimpleFunction replacement = irSimpleFunction;
        IrCall irCall = expression2 instanceof IrCall ? (IrCall)expression2 : null;
        IrCallImpl $this$visitFunctionAccess_u24lambda_u2d13 = irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), IrTypeUtilsKt.substitute(function2.getReturnType(), IrUtilsKt.getTypeSubstitutionMap(expression2)), replacement.getSymbol(), replacement.getTypeParameters().size(), replacement.getValueParameters().size(), expression2.getOrigin(), irCall != null ? irCall.getSuperQualifierSymbol() : null);
        boolean bl = false;
        this.buildReplacement($this$visitFunctionAccess_u24lambda_u2d13, function2, expression2, replacement);
        return irCallImpl;
    }

    private final IrExpression coerceInlineClasses(IrExpression argument2, IrType from2, IrType to, boolean skipCast) {
        IrSimpleType underlyingType;
        IrCallImpl irCallImpl;
        IrCallImpl $this$coerceInlineClasses_u24lambda_u2d14 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, -1, -1, to, this.getContext().getIr().getSymbols().getUnsafeCoerceIntrinsic(), 0, 0, null, null, 240, null);
        boolean bl = false;
        InlineClassRepresentation<IrSimpleType> inlineClassRepresentation = IrDeclarationsKt.getInlineClassRepresentation(JvmIrTypeUtilsKt.getErasedUpperBound(from2));
        IrSimpleType irSimpleType = underlyingType = inlineClassRepresentation != null ? inlineClassRepresentation.getUnderlyingType() : null;
        boolean bl2 = irSimpleType != null ? IrTypeUtilsKt.isTypeParameter(irSimpleType) : false;
        if (bl2 && !skipCast) {
            $this$coerceInlineClasses_u24lambda_u2d14.putTypeArgument(0, from2);
            $this$coerceInlineClasses_u24lambda_u2d14.putTypeArgument(1, underlyingType);
            $this$coerceInlineClasses_u24lambda_u2d14.putValueArgument(0, new IrTypeOperatorCallImpl(-1, -1, to, IrTypeOperator.IMPLICIT_CAST, underlyingType, argument2));
        } else {
            $this$coerceInlineClasses_u24lambda_u2d14.putTypeArgument(0, from2);
            $this$coerceInlineClasses_u24lambda_u2d14.putTypeArgument(1, to);
            $this$coerceInlineClasses_u24lambda_u2d14.putValueArgument(0, argument2);
        }
        return irCallImpl;
    }

    static /* synthetic */ IrExpression coerceInlineClasses$default(JvmInlineClassLowering jvmInlineClassLowering, IrExpression irExpression, IrType irType, IrType irType2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return jvmInlineClassLowering.coerceInlineClasses(irExpression, irType, irType2, bl);
    }

    private final IrExpression coerceToUnboxed(IrExpression $this$coerceToUnboxed) {
        return JvmInlineClassLowering.coerceInlineClasses$default(this, $this$coerceToUnboxed, $this$coerceToUnboxed.getType(), InlineClassAbiKt.unboxInlineClass($this$coerceToUnboxed.getType()), false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression specializeEqualsCall(IrBuilderWithScope $this$specializeEqualsCall, IrExpression left, IrExpression right) {
        IrExpression irExpression;
        boolean rightNullCheck;
        boolean rightIsUnboxed;
        if (IrUtilsKt.isNullConst(left) || IrUtilsKt.isNullConst(right)) {
            return null;
        }
        boolean leftIsUnboxed = !Intrinsics.areEqual(InlineClassAbiKt.unboxInlineClass(left.getType()), left.getType());
        boolean bl = rightIsUnboxed = !Intrinsics.areEqual(InlineClassAbiKt.unboxInlineClass(right.getType()), right.getType());
        if (!leftIsUnboxed && !rightIsUnboxed) {
            return null;
        }
        boolean leftNullCheck = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(left.getType());
        boolean bl2 = rightNullCheck = rightIsUnboxed && org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(right.getType());
        if (leftNullCheck || rightNullCheck) {
            IrExpression equalsRight;
            void this_$iv$iv;
            IrBuilderWithScope $this$irBlock_u24default$iv = $this$specializeEqualsCall;
            int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$specializeEqualsCall_u24lambda_u2d17 = this_$iv$iv;
            boolean bl3 = false;
            IrValueDeclaration leftVal = left instanceof IrGetValue ? ((IrGetValue)left).getSymbol().getOwner() : (IrValueDeclaration)ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$specializeEqualsCall_u24lambda_u2d17, left, null, null, false, 14, null);
            IrValueDeclaration rightVal = right instanceof IrGetValue ? ((IrGetValue)right).getSymbol().getOwner() : (IrValueDeclaration)ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$specializeEqualsCall_u24lambda_u2d17, right, null, null, false, 14, null);
            IrExpression equalsCall = JvmInlineClassLowering.specializeEqualsCall$equals(rightIsUnboxed, $this$specializeEqualsCall, this, leftNullCheck ? (IrExpression)ExpressionHelpersKt.irImplicitCast((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17, leftVal), IrTypesKt.makeNotNull(left.getType())) : (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17, leftVal), rightNullCheck ? (IrExpression)ExpressionHelpersKt.irImplicitCast((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17, rightVal), IrTypesKt.makeNotNull(right.getType())) : (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17, rightVal));
            IrExpression irExpression2 = equalsRight = rightNullCheck ? (IrExpression)ExpressionHelpersKt.irIfNull((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17, $this$specializeEqualsCall_u24lambda_u2d17.getContext().getIrBuiltIns().getBooleanType(), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17, rightVal), ExpressionHelpersKt.irFalse((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17), equalsCall) : equalsCall;
            if (leftNullCheck) {
                $this$specializeEqualsCall_u24lambda_u2d17.unaryPlus(ExpressionHelpersKt.irIfNull((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17, $this$specializeEqualsCall_u24lambda_u2d17.getContext().getIrBuiltIns().getBooleanType(), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17, leftVal), ExpressionHelpersKt.irEqualsNull((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d17, rightVal)), equalsRight));
            } else {
                $this$specializeEqualsCall_u24lambda_u2d17.unaryPlus(equalsRight);
            }
            irExpression = this_$iv$iv.doBuild();
        } else {
            irExpression = JvmInlineClassLowering.specializeEqualsCall$equals(rightIsUnboxed, $this$specializeEqualsCall, this, left, right);
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (InlineClassAbiKt.isInlineClassFieldGetter(expression2.getSymbol().getOwner())) {
            IrExpression irExpression2 = expression2.getDispatchReceiver();
            Intrinsics.checkNotNull(irExpression2);
            IrElement arg = irExpression2.transform((IrElementTransformer)this, (Object)null);
            IrValueParameter irValueParameter = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getDispatchReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            irExpression = JvmInlineClassLowering.coerceInlineClasses$default(this, (IrExpression)arg, irValueParameter.getType(), expression2.getType(), false, 8, null);
        } else if (this.isSpecializedInlineClassEqEq(expression2)) {
            this.transformChildrenVoid(expression2);
            BackendContext backendContext = this.getContext();
            ScopeWithIr scopeWithIr = this.getCurrentScope();
            Intrinsics.checkNotNull(scopeWithIr);
            IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder(backendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
            IrExpression irExpression3 = expression2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression3);
            IrExpression irExpression4 = expression2.getValueArgument(1);
            Intrinsics.checkNotNull(irExpression4);
            irExpression = this.specializeEqualsCall(irBuilderWithScope, irExpression3, irExpression4);
            if (irExpression == null) {
                irExpression = expression2;
            }
        } else {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }

    private final boolean isSpecializedInlineClassEqEq(IrCall $this$isSpecializedInlineClassEqEq) {
        Object object;
        block5: {
            block4: {
                Object object2;
                if (!Intrinsics.areEqual($this$isSpecializedInlineClassEqEq.getSymbol(), this.getContext().getIrBuiltIns().getEqeqSymbol())) {
                    return false;
                }
                object = $this$isSpecializedInlineClassEqEq.getValueArgument(0);
                if (object == null || (object = ((IrExpression)object).getType()) == null || (object = IrTypesKt.getClassOrNull((IrType)object)) == null || (object = (IrClass)object.getOwner()) == null) break block4;
                Object it = object2 = object;
                boolean bl = false;
                object = IrDeclarationsKt.isSingleFieldValueClass((IrClass)it) ? object2 : null;
                if (object != null) break block5;
            }
            return false;
        }
        Object leftClass = object;
        return !Intrinsics.areEqual(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)leftClass), StandardNames.RESULT_FQ_NAME) || this.getContext().getState().getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_4) >= 0;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        IrDeclarationParent parent2 = field2.getParent();
        if (Intrinsics.areEqual(field2.getOrigin(), IrDeclarationOrigin.PROPERTY_BACKING_FIELD.INSTANCE) && parent2 instanceof IrClass && IrDeclarationsKt.isSingleFieldValueClass((IrClass)parent2) && Intrinsics.areEqual(field2.getName(), InlineClassAbiKt.getInlineClassFieldName((IrClass)parent2))) {
            IrExpression irExpression = expression2.getReceiver();
            Intrinsics.checkNotNull(irExpression);
            IrElement receiver = irExpression.transform((IrElementTransformer)this, (Object)null);
            return JvmInlineClassLowering.coerceInlineClasses$default(this, (IrExpression)receiver, ((IrExpression)receiver).getType(), field2.getType(), false, 8, null);
        }
        return super.visitGetField(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrValueDeclaration irValueDeclaration = this.getValueMap().get(expression2.getSymbol());
        if (irValueDeclaration != null) {
            IrValueDeclaration it = irValueDeclaration;
            boolean bl = false;
            return new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getOrigin());
        }
        return super.visitGetValue(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrValueDeclaration irValueDeclaration = this.getValueMap().get(expression2.getSymbol());
        if (irValueDeclaration != null) {
            IrValueDeclaration it = irValueDeclaration;
            boolean bl = false;
            return new IrSetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), (IrExpression)expression2.getValue().transform((IrElementTransformer)this, (Object)null), expression2.getOrigin());
        }
        return super.visitSetValue(expression2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildPrimaryValueClassConstructor(@NotNull IrClass valueClass, @NotNull IrConstructor irConstructor2) {
        void $this$buildPrimaryValueClassConstructor_u24lambda_u2d26;
        void this_$iv$iv;
        Iterator $this$filterIsInstanceTo$iv$iv;
        void $this$buildPrimaryValueClassConstructor_u24lambda_u2d24_u24lambda_u2d23;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        Intrinsics.checkNotNullParameter(valueClass, "valueClass");
        Intrinsics.checkNotNullParameter(irConstructor2, "irConstructor");
        Iterator $this$addConstructor$iv = valueClass;
        boolean $i$f$addConstructor = false;
        Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2d20$iv$iv = new IrFunctionBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv$iv22 = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2d21$iv = $this$buildConstructor_u24lambda_u2d20$iv$iv;
        boolean bl = false;
        IrFunctionBuilder $this$buildPrimaryValueClassConstructor_u24lambda_u2d21 = $this$addConstructor_u24lambda_u2d21$iv;
        boolean $i$a$-addConstructor-JvmInlineClassLowering$buildPrimaryValueClassConstructor$22 = false;
        $this$buildPrimaryValueClassConstructor_u24lambda_u2d21.updateFrom(irConstructor2);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PRIVATE");
        $this$buildPrimaryValueClassConstructor_u24lambda_u2d21.setVisibility(descriptorVisibility);
        $this$buildPrimaryValueClassConstructor_u24lambda_u2d21.setOrigin(JvmLoweredDeclarationOrigin.SYNTHETIC_INLINE_CLASS_MEMBER.INSTANCE);
        $this$buildPrimaryValueClassConstructor_u24lambda_u2d21.setReturnType(irConstructor2.getReturnType());
        $this$addConstructor_u24lambda_u2d21$iv.setReturnType(IrUtilsKt.getDefaultType((IrClass)((Object)$this$addConstructor$iv)));
        Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2d20$iv$iv);
        boolean bl2 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        constructor$iv.setParent((IrDeclarationParent)((Object)$this$addConstructor$iv));
        Iterator $this$buildPrimaryValueClassConstructor_u24lambda_u2d24 = $this$addConstructor$iv = $this$buildConstructor$iv$iv;
        boolean bl3 = false;
        Iterable $this$forEach$iv = irConstructor2.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl4 = false;
            it.setDefaultValue(null);
        }
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyParameterDeclarationsFrom((IrFunction)((Object)$this$buildPrimaryValueClassConstructor_u24lambda_u2d24), irConstructor2);
        $this$buildPrimaryValueClassConstructor_u24lambda_u2d24.setAnnotations(irConstructor2.getAnnotations());
        IrGeneratorWithScope $this$irBlockBody$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)((IrConstructor)((Object)$this$buildPrimaryValueClassConstructor_u24lambda_u2d24)).getSymbol(), 0, 0, 6, null);
        boolean $i$f$irBlockBody22 = false;
        IrGeneratorWithScope $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv$iv22 = $this$irBlockBody$iv;
        int element$iv = ((IrElement)((Object)$this$buildPrimaryValueClassConstructor_u24lambda_u2d24)).getStartOffset();
        int endOffset$iv$iv22 = ((IrElement)((Object)$this$buildPrimaryValueClassConstructor_u24lambda_u2d24)).getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder $i$a$-addConstructor-JvmInlineClassLowering$buildPrimaryValueClassConstructor$22 = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv22);
        boolean $i$f$blockBody = false;
        void var14_38 = this_$iv$iv$iv;
        Iterator iterator2 = $this$buildPrimaryValueClassConstructor_u24lambda_u2d24;
        boolean bl5 = false;
        $this$buildPrimaryValueClassConstructor_u24lambda_u2d24_u24lambda_u2d23.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$buildPrimaryValueClassConstructor_u24lambda_u2d24_u24lambda_u2d23, SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$buildPrimaryValueClassConstructor_u24lambda_u2d24_u24lambda_u2d23.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildPrimaryValueClassConstructor_u24lambda_u2d24_u24lambda_u2d23;
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$buildPrimaryValueClassConstructor_u24lambda_u2d24_u24lambda_u2d23;
        IrValueParameter irValueParameter = valueClass.getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        $this$buildPrimaryValueClassConstructor_u24lambda_u2d24_u24lambda_u2d23.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter), InlineClassesKt.getInlineClassBackingField(valueClass), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildPrimaryValueClassConstructor_u24lambda_u2d24_u24lambda_u2d23, ((IrFunction)((Object)$this$buildPrimaryValueClassConstructor_u24lambda_u2d24)).getValueParameters().get(0)), null, 8, null));
        ((IrFunction)((Object)iterator2)).setBody(this_$iv$iv$iv.doBuild());
        IrSimpleFunction irSimpleFunction = this.getContext().getInlineClassReplacements().getGetReplacementFunction().invoke(irConstructor2);
        Intrinsics.checkNotNull(irSimpleFunction);
        IrSimpleFunction function2 = irSimpleFunction;
        Iterable $this$filterIsInstance$iv = valueClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$irBlockBody22 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator endOffset$iv$iv22 = $this$filterIsInstanceTo$iv$iv.iterator();
        while (endOffset$iv$iv22.hasNext()) {
            Object element$iv$iv = endOffset$iv$iv22.next();
            if (!(element$iv$iv instanceof IrAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List initBlocks = (List)destination$iv$iv;
        Iterable $this$forEach$iv2 = function2.getValueParameters();
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            IrValueParameter it = (IrValueParameter)element$iv2;
            boolean bl6 = false;
            this.transformChildrenVoid(it);
        }
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody3 = false;
        IrBlockBodyBuilder it = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody2 = false;
        void element$iv$iv = this_$iv$iv;
        IrSimpleFunction irSimpleFunction2 = function2;
        boolean bl7 = false;
        IrValueParameter argument2 = function2.getValueParameters().get(0);
        IrVariable thisValue = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$buildPrimaryValueClassConstructor_u24lambda_u2d26, this.coerceInlineClasses(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildPrimaryValueClassConstructor_u24lambda_u2d26, argument2), argument2.getType(), function2.getReturnType(), true), null, null, false, 14, null);
        Map<IrValueSymbol, IrValueDeclaration> map = this.getValueMap();
        IrValueParameter irValueParameter2 = valueClass.getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter2);
        map.put(irValueParameter2.getSymbol(), thisValue);
        for (IrAnonymousInitializer initBlock : initBlocks) {
            for (IrStatement stmt : initBlock.getBody().getStatements()) {
                $this$buildPrimaryValueClassConstructor_u24lambda_u2d26.unaryPlus((IrStatement)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)IrElementsKt.transformStatement(stmt, this), function2));
            }
        }
        $this$buildPrimaryValueClassConstructor_u24lambda_u2d26.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$buildPrimaryValueClassConstructor_u24lambda_u2d26, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildPrimaryValueClassConstructor_u24lambda_u2d26, thisValue)));
        irSimpleFunction2.setBody(this_$iv$iv.doBuild());
        valueClass.getDeclarations().removeAll(initBlocks);
        ((Collection)valueClass.getDeclarations()).add(function2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildBoxFunction(@NotNull IrClass valueClass) {
        void $this$buildBoxFunction_u24lambda_u2d28_u24lambda_u2d27;
        IrConstructorCall irConstructorCall;
        Intrinsics.checkNotNullParameter(valueClass, "valueClass");
        IrSimpleFunction function2 = this.getContext().getInlineClassReplacements().getGetBoxFunction().invoke(valueClass);
        DeclarationIrBuilder $this$buildBoxFunction_u24lambda_u2d28 = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        IrBuilderWithScope irBuilderWithScope = $this$buildBoxFunction_u24lambda_u2d28;
        IrBuilderWithScope irBuilderWithScope2 = $this$buildBoxFunction_u24lambda_u2d28;
        IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(valueClass);
        Intrinsics.checkNotNull(irConstructor2);
        IrConstructorCall irConstructorCall2 = irConstructorCall = ExpressionHelpersKt.irCall(irBuilderWithScope2, irConstructor2.getSymbol());
        IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope;
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl2 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$buildBoxFunction_u24lambda_u2d28_u24lambda_u2d27, function2, 0, 2, null);
        $this$buildBoxFunction_u24lambda_u2d28_u24lambda_u2d27.putValueArgument(0, ExpressionHelpersKt.irGet($this$buildBoxFunction_u24lambda_u2d28, function2.getValueParameters().get(0)));
        Unit unit2 = Unit.INSTANCE;
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope3, irConstructorCall));
        ((Collection)valueClass.getDeclarations()).add(function2);
    }

    @Override
    protected void buildUnboxFunctions(@NotNull IrClass valueClass) {
        Intrinsics.checkNotNullParameter(valueClass, "valueClass");
        this.buildUnboxFunction(valueClass);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildUnboxFunction(IrClass irClass2) {
        void $this$buildUnboxFunction_u24lambda_u2d29;
        void this_$iv$iv;
        IrSimpleFunction function2 = this.getContext().getInlineClassReplacements().getGetUnboxFunction().invoke(irClass2);
        IrField field2 = InlineClassesKt.getInlineClassBackingField(irClass2);
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var10_10 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl = false;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildUnboxFunction_u24lambda_u2d29;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull(irValueParameter);
        IrGetValueImpl thisVal = ExpressionHelpersKt.irGet(irBuilderWithScope, irValueParameter);
        $this$buildUnboxFunction_u24lambda_u2d29.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$buildUnboxFunction_u24lambda_u2d29, ExpressionHelpersKt.irGetField((IrBuilderWithScope)$this$buildUnboxFunction_u24lambda_u2d29, thisVal, field2)));
        irSimpleFunction.setBody(this_$iv$iv.doBuild());
        ((Collection)irClass2.getDeclarations()).add(function2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildSpecializedEqualsMethod(@NotNull IrClass valueClass) {
        void $this$buildSpecializedEqualsMethod_u24lambda_u2d30;
        Intrinsics.checkNotNullParameter(valueClass, "valueClass");
        IrSimpleFunction function2 = this.getContext().getInlineClassReplacements().getSpecializedEqualsMethod(valueClass, this.getContext().getIrBuiltIns());
        IrValueParameter left = function2.getValueParameters().get(0);
        IrValueParameter right = function2.getValueParameters().get(1);
        IrType type2 = InlineClassAbiKt.unboxInlineClass(left.getType());
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)valueClass.getSymbol(), 0, 0, 6, null);
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl = false;
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$buildSpecializedEqualsMethod_u24lambda_u2d30, ExpressionHelpersKt.irEquals$default((IrBuilderWithScope)$this$buildSpecializedEqualsMethod_u24lambda_u2d30, JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildSpecializedEqualsMethod_u24lambda_u2d30, left), left.getType(), type2, false, 8, null), JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildSpecializedEqualsMethod_u24lambda_u2d30, right), right.getType(), type2, false, 8, null), null, 4, null)));
        ((Collection)valueClass.getDeclarations()).add(function2);
    }

    private static final IrExpression specializeEqualsCall$equals(boolean rightIsUnboxed, IrBuilderWithScope $this_specializeEqualsCall, JvmInlineClassLowering this$0, IrExpression left, IrExpression right) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrSimpleFunction irSimpleFunction;
        if (IrTypeUtilsKt.isUnsigned(left.getType()) && IrTypeUtilsKt.isUnsigned(right.getType()) && rightIsUnboxed) {
            return ExpressionHelpersKt.irEquals$default($this_specializeEqualsCall, this$0.coerceToUnboxed(left), this$0.coerceToUnboxed(right), null, 4, null);
        }
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(left.getType());
        Intrinsics.checkNotNull(irClassSymbol);
        IrClass klass = (IrClass)irClassSymbol.getOwner();
        if (rightIsUnboxed) {
            irSimpleFunction = this$0.getContext().getInlineClassReplacements().getSpecializedEqualsMethod(klass, $this_specializeEqualsCall.getContext().getIrBuiltIns());
        } else {
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(klass);
            boolean $i$f$single = false;
            IrSimpleFunction single$iv = null;
            boolean found$iv = false;
            Iterator<IrSimpleFunction> iterator2 = $this$single$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunction element$iv;
                IrSimpleFunction it = element$iv = iterator2.next();
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual(it.getName().asString(), "equals") && !((Collection)it.getOverriddenSymbols()).isEmpty();
                if (!bl2) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction equals = single$iv;
            IrSimpleFunction irSimpleFunction2 = this$0.getContext().getInlineClassReplacements().getGetReplacementFunction().invoke(equals);
            Intrinsics.checkNotNull(irSimpleFunction2);
            irSimpleFunction = irSimpleFunction2;
        }
        IrSimpleFunction equalsMethod = irSimpleFunction;
        IrFunctionAccessExpression $this$specializeEqualsCall_u24equals_u24lambda_u2d16 = irFunctionAccessExpression = ExpressionHelpersKt.irCall($this_specializeEqualsCall, equalsMethod);
        boolean bl = false;
        $this$specializeEqualsCall_u24equals_u24lambda_u2d16.putValueArgument(0, left);
        $this$specializeEqualsCall_u24equals_u24lambda_u2d16.putValueArgument(1, right);
        return irFunctionAccessExpression;
    }
}

