/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirSwitchableExtensionDeclarationsSymbolProvider;
import org.jetbrains.kotlin.fir.extensions.FirSwitchableExtensionDeclarationsSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirGeneratedClassDeclaredMemberScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\bH\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016R$\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedClassNestedClassifierScope;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "nestedClassifierNames", "", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Ljava/util/Set;)V", "nestedClassifierCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "", "generateNestedClassifier", "name", "getClassifierNames", "getNestedClassSymbol", "isEmpty", "", "Companion", "providers"})
public final class FirGeneratedClassNestedClassifierScope
extends FirNestedClassifierScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Name> nestedClassifierNames;
    @NotNull
    private final FirCache nestedClassifierCache;

    private FirGeneratedClassNestedClassifierScope(FirSession useSiteSession, FirClass klass, Set<Name> nestedClassifierNames) {
        super(klass, useSiteSession);
        this.nestedClassifierNames = nestedClassifierNames;
        this.nestedClassifierCache = FirCachesFactoryKt.getFirCachesFactory(useSiteSession).createCache(new Function2(this){
            final /* synthetic */ FirGeneratedClassNestedClassifierScope this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @Nullable
            public final FirRegularClassSymbol invoke(@NotNull Name name, @Nullable Void void_) {
                Intrinsics.checkNotNullParameter(name, "name");
                return FirGeneratedClassNestedClassifierScope.access$generateNestedClassifier(this.this$0, name);
            }
        });
    }

    private final FirRegularClassSymbol generateNestedClassifier(Name name) {
        FirClassLikeSymbol<?> generatedClass;
        FirClassLikeSymbol<?> firClassLikeSymbol;
        FirRegularClassSymbol companion;
        if (this.getKlass() instanceof FirRegularClass && (companion = ((FirRegularClass)this.getKlass()).getCompanionObjectSymbol()) != null && companion.getOrigin().getGenerated() && Intrinsics.areEqual(companion.getClassId().getShortClassName(), name)) {
            return companion;
        }
        if (!this.nestedClassifierNames.contains(name)) {
            return null;
        }
        FirSwitchableExtensionDeclarationsSymbolProvider firSwitchableExtensionDeclarationsSymbolProvider = FirSwitchableExtensionDeclarationsSymbolProviderKt.getGeneratedDeclarationsSymbolProvider(this.getUseSiteSession());
        if (firSwitchableExtensionDeclarationsSymbolProvider != null) {
            ClassId classId = FirDeclarationUtilKt.getClassId(this.getKlass()).createNestedClassId(name);
            Intrinsics.checkNotNullExpressionValue(classId, "klass.classId.createNestedClassId(name)");
            firClassLikeSymbol = firSwitchableExtensionDeclarationsSymbolProvider.getClassLikeSymbolByClassId(classId);
        } else {
            firClassLikeSymbol = null;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol2 = generatedClass = firClassLikeSymbol;
        if (!(firClassLikeSymbol2 == null ? true : firClassLikeSymbol2 instanceof FirRegularClassSymbol)) {
            boolean bl = false;
            String string2 = "Only regular class are allowed as nested classes";
            throw new IllegalArgumentException(string2.toString());
        }
        return (FirRegularClassSymbol)generatedClass;
    }

    @Override
    @Nullable
    protected FirRegularClassSymbol getNestedClassSymbol(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        FirCache $this$getValue$iv = this.nestedClassifierCache;
        boolean $i$f$getValue = false;
        return (FirRegularClassSymbol)$this$getValue$iv.getValue(name, null);
    }

    @Override
    public boolean isEmpty() {
        return this.nestedClassifierNames.isEmpty();
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return this.nestedClassifierNames;
    }

    public /* synthetic */ FirGeneratedClassNestedClassifierScope(FirSession useSiteSession, FirClass klass, Set nestedClassifierNames, DefaultConstructorMarker $constructor_marker) {
        this(useSiteSession, klass, nestedClassifierNames);
    }

    public static final /* synthetic */ FirRegularClassSymbol access$generateNestedClassifier(FirGeneratedClassNestedClassifierScope $this, Name name) {
        return $this.generateNestedClassifier(name);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedClassNestedClassifierScope$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedClassNestedClassifierScope;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "providers"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final FirGeneratedClassNestedClassifierScope create(@NotNull FirSession useSiteSession, @NotNull FirClass klass) {
            void destination$iv;
            void $this$flatMapTo$iv;
            Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
            Intrinsics.checkNotNullParameter(klass, "klass");
            List<FirDeclarationGenerationExtension> extensions = FirGeneratedClassDeclaredMemberScopeKt.getExtensionsForClass(useSiteSession, klass);
            FirClassSymbol<? extends FirClass> symbol2 = klass.getSymbol();
            Iterable iterable = extensions;
            Collection collection = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                FirDeclarationGenerationExtension it = (FirDeclarationGenerationExtension)element$iv;
                boolean bl = false;
                FirCache $this$getValue$iv = it.getNestedClassifierNamesCache();
                boolean $i$f$getValue = false;
                Iterable list$iv = (Set)$this$getValue$iv.getValue(symbol2, null);
                CollectionsKt.addAll(destination$iv, list$iv);
            }
            Set classifierNames2 = (Set)destination$iv;
            if (classifierNames2.isEmpty()) {
                return null;
            }
            return new FirGeneratedClassNestedClassifierScope(useSiteSession, klass, classifierNames2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

