/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import org.gradle.internal.impldep.org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;

public final class DefaultSerializationService
implements SerializationService {
    public byte[] write(Object object, Class modelClazz) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(os);
        try {
            outputStream.writeObject(object);
        }
        catch (NotSerializableException e) {
            throw new IOException(String.format("Implement Serializable or provide related org.jetbrains.plugins.gradle.tooling.serialization.SerializationService for the tooling model: '%s'", object.getClass().getName()), e);
        }
        finally {
            outputStream.close();
        }
        return os.toByteArray();
    }

    public Object read(byte[] object, Class modelClazz) throws IOException {
        ClassLoaderObjectInputStream inputStream = new ClassLoaderObjectInputStream(modelClazz.getClassLoader(), (InputStream)new ByteArrayInputStream(object));
        try {
            Object object2 = inputStream.readObject();
            return object2;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        finally {
            inputStream.close();
        }
    }

    public Class<Object> getModelClass() {
        throw new IllegalStateException("The method should never be called for this serializer service implementation");
    }
}

