/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.metadata;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.repositories.metadata.AbstractMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultMetadataFileSource;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolverDescriptorParseContext;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DefaultModuleDescriptorArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleDescriptorArtifactMetadata;
import org.gradle.internal.component.model.MutableModuleSources;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRepositoryMetadataSource<S extends MutableModuleComponentResolveMetadata>
extends AbstractMetadataSource<S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalResourceResolver.class);
    final MetadataArtifactProvider metadataArtifactProvider;
    private final FileResourceRepository fileResourceRepository;
    private final ChecksumService checksumService;

    protected AbstractRepositoryMetadataSource(MetadataArtifactProvider metadataArtifactProvider, FileResourceRepository fileResourceRepository, ChecksumService checksumService) {
        this.metadataArtifactProvider = metadataArtifactProvider;
        this.fileResourceRepository = fileResourceRepository;
        this.checksumService = checksumService;
    }

    @Override
    public S create(String repositoryName, ComponentResolvers componentResolvers, ModuleComponentIdentifier moduleVersionIdentifier, ComponentOverrideMetadata prescribedMetaData, ExternalResourceArtifactResolver artifactResolver, BuildableModuleComponentMetaDataResolveResult result2) {
        S parsedMetadataFromRepository = this.parseMetaDataFromArtifact(repositoryName, componentResolvers, moduleVersionIdentifier, artifactResolver, result2);
        if (parsedMetadataFromRepository != null) {
            LOGGER.debug("Metadata file found for module '{}' in repository '{}'.", (Object)moduleVersionIdentifier, (Object)repositoryName);
        }
        return parsedMetadataFromRepository;
    }

    @Nullable
    private S parseMetaDataFromArtifact(String repositoryName, ComponentResolvers componentResolvers, ModuleComponentIdentifier moduleComponentIdentifier, ExternalResourceArtifactResolver artifactResolver, ResourceAwareResolveResult result2) {
        ExternalResourceResolverDescriptorParseContext context;
        MetaDataParser.ParseResult<S> parseResult;
        ModuleDescriptorArtifactMetadata artifact = this.getMetaDataArtifactFor(moduleComponentIdentifier);
        LocallyAvailableExternalResource metadataArtifact = artifactResolver.resolveArtifact(artifact, result2);
        if (metadataArtifact != null && (parseResult = this.parseMetaDataFromResource(moduleComponentIdentifier, metadataArtifact, artifactResolver, context = new ExternalResourceResolverDescriptorParseContext(componentResolvers, this.fileResourceRepository, this.checksumService), repositoryName)) != null) {
            if (parseResult.hasGradleMetadataRedirectionMarker()) {
                if (result2 instanceof BuildableModuleComponentMetaDataResolveResult) {
                    ((BuildableModuleComponentMetaDataResolveResult)result2).redirectToGradleMetadata();
                } else {
                    throw new IllegalStateException("Unexpected Gradle metadata redirection answer");
                }
            }
            MutableModuleComponentResolveMetadata metadata = (MutableModuleComponentResolveMetadata)parseResult.getResult();
            File metadataArtifactFile = metadataArtifact.getFile();
            ExternalResourceMetaData metaData = metadataArtifact.getMetaData();
            MutableModuleSources sources = metadata.getSources();
            sources.add(new DefaultMetadataFileSource(artifact.getId(), metadataArtifactFile, this.findSha1(metaData, metadataArtifactFile)));
            context.appendSources(sources);
            return (S)metadata;
        }
        return null;
    }

    private HashCode findSha1(ExternalResourceMetaData metaData, File artifact) {
        HashCode sha1 = metaData.getSha1();
        if (sha1 == null) {
            sha1 = this.checksumService.sha1(artifact);
        }
        return sha1;
    }

    private ModuleDescriptorArtifactMetadata getMetaDataArtifactFor(ModuleComponentIdentifier moduleComponentIdentifier) {
        IvyArtifactName ivyArtifactName = this.metadataArtifactProvider.getMetaDataArtifactName(moduleComponentIdentifier.getModule());
        return new DefaultModuleDescriptorArtifactMetadata(moduleComponentIdentifier, ivyArtifactName);
    }

    void checkMetadataConsistency(ModuleComponentIdentifier expectedId, MutableModuleComponentResolveMetadata metadata) throws MetaDataParseException {
        this.checkModuleIdentifier(expectedId, metadata.getModuleVersionId());
    }

    private void checkModuleIdentifier(ModuleComponentIdentifier expectedId, ModuleVersionIdentifier actualId) {
        ArrayList<String> errors = new ArrayList<String>();
        this.checkEquals("group", expectedId.getGroup(), actualId.getGroup(), errors);
        this.checkEquals("module name", expectedId.getModule(), actualId.getName(), errors);
        this.checkEquals("version", expectedId.getVersion(), actualId.getVersion(), errors);
        if (errors.size() > 0) {
            throw new MetaDataParseException(String.format("inconsistent module metadata found. Descriptor: %s Errors: %s", actualId, this.joinLines(errors)));
        }
    }

    private String joinLines(List<String> lines) {
        return Joiner.on((String)SystemProperties.getInstance().getLineSeparator()).join(lines);
    }

    private void checkEquals(String label, String expected, String actual, List<String> errors) {
        if (!expected.equals(actual)) {
            errors.add("bad " + label + ": expected='" + expected + "' found='" + actual + "'");
        }
    }

    protected abstract MetaDataParser.ParseResult<S> parseMetaDataFromResource(ModuleComponentIdentifier var1, LocallyAvailableExternalResource var2, ExternalResourceArtifactResolver var3, DescriptorParseContext var4, String var5);
}

