/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies.internal;

import groovy.json.JsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.reporting.dependencies.internal.StrictDependencyResultSpec;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableModuleResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.UnresolvableConfigurationResult;
import org.gradle.api.tasks.diagnostics.internal.insight.DependencyInsightReporter;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.CollectionUtils;

public class JsonProjectDependencyRenderer {
    private final VersionSelectorScheme versionSelectorScheme;
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;

    public JsonProjectDependencyRenderer(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, VersionParser versionParser) {
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
    }

    public String render(Project project) {
        JsonBuilder json = new JsonBuilder();
        this.renderProject(project, json);
        return json.toString();
    }

    private void renderProject(Project project, JsonBuilder json) {
        LinkedHashMap overall = Maps.newLinkedHashMap();
        overall.put("gradleVersion", GradleVersion.current().toString());
        overall.put("generationDate", new Date().toString());
        LinkedHashMap projectOut = Maps.newLinkedHashMap();
        projectOut.put("name", project.getName());
        projectOut.put("description", project.getDescription());
        projectOut.put("configurations", this.createConfigurations(project));
        overall.put("project", projectOut);
        json.call((Map)overall);
    }

    private List<Configuration> getNonDeprecatedConfigurations(Project project) {
        ArrayList<Configuration> filteredConfigurations = new ArrayList<Configuration>();
        for (Configuration configuration2 : project.getConfigurations()) {
            if (((DeprecatableConfiguration)configuration2).isFullyDeprecated()) continue;
            filteredConfigurations.add(configuration2);
        }
        return filteredConfigurations;
    }

    private boolean canBeResolved(Configuration configuration2) {
        boolean isDeprecatedForResolving = ((DeprecatableConfiguration)configuration2).getResolutionAlternatives() != null;
        return configuration2.isCanBeResolved() && !isDeprecatedForResolving;
    }

    private List<Map<String, Object>> createConfigurations(Project project) {
        List<Configuration> configurations = this.getNonDeprecatedConfigurations(project);
        return CollectionUtils.collect(configurations, configuration2 -> {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(4);
            map.put("name", configuration2.getName());
            map.put("description", configuration2.getDescription());
            map.put("dependencies", this.createDependencies((Configuration)configuration2));
            map.put("moduleInsights", this.createModuleInsights((Configuration)configuration2));
            return map;
        });
    }

    private List<Map<String, Object>> createDependencies(Configuration configuration2) {
        if (this.canBeResolved(configuration2)) {
            ResolutionResult result2 = configuration2.getIncoming().getResolutionResult();
            RenderableModuleResult root = new RenderableModuleResult(result2.getRoot());
            return this.createDependencyChildren(root, new HashSet<Object>());
        }
        return this.createDependencyChildren(new UnresolvableConfigurationResult(configuration2), new HashSet<Object>());
    }

    private List<Map<String, Object>> createDependencyChildren(RenderableDependency dependency, Set<Object> visited) {
        Set<? extends RenderableDependency> children = dependency.getChildren();
        return CollectionUtils.collect(children, childDependency -> {
            boolean alreadyVisited = !visited.add(childDependency.getId());
            boolean alreadyRendered = alreadyVisited && !childDependency.getChildren().isEmpty();
            String name = this.replaceArrow(childDependency.getName());
            boolean hasConflict = !name.equals(childDependency.getName());
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(6);
            ModuleIdentifier moduleIdentifier = this.getModuleIdentifier((RenderableDependency)childDependency);
            map.put("module", moduleIdentifier == null ? null : moduleIdentifier.toString());
            map.put("name", name);
            map.put("resolvable", (Object)childDependency.getResolutionState());
            map.put("hasConflict", hasConflict);
            map.put("alreadyRendered", alreadyRendered);
            map.put("children", Collections.emptyList());
            if (!alreadyRendered) {
                map.put("children", this.createDependencyChildren((RenderableDependency)childDependency, visited));
            }
            return map;
        });
    }

    @Nullable
    private ModuleIdentifier getModuleIdentifier(RenderableDependency renderableDependency) {
        if (renderableDependency.getId() instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier id = (ModuleComponentIdentifier)renderableDependency.getId();
            return id.getModuleIdentifier();
        }
        return null;
    }

    private List<Object> createModuleInsights(Configuration configuration2) {
        Set<ModuleIdentifier> modules = this.collectModules(configuration2);
        return CollectionUtils.collect(modules, moduleIdentifier -> this.createModuleInsight((ModuleIdentifier)moduleIdentifier, configuration2));
    }

    private Set<ModuleIdentifier> collectModules(Configuration configuration2) {
        AbstractRenderableDependency root;
        if (this.canBeResolved(configuration2)) {
            ResolutionResult result2 = configuration2.getIncoming().getResolutionResult();
            root = new RenderableModuleResult(result2.getRoot());
        } else {
            root = new UnresolvableConfigurationResult(configuration2);
        }
        HashSet modules = Sets.newHashSet();
        HashSet visited = Sets.newHashSet();
        this.populateModulesWithChildDependencies(root, visited, modules);
        return modules;
    }

    private void populateModulesWithChildDependencies(RenderableDependency dependency, Set<ComponentIdentifier> visited, Set<ModuleIdentifier> modules) {
        for (RenderableDependency renderableDependency : dependency.getChildren()) {
            ModuleIdentifier moduleId = this.getModuleIdentifier(renderableDependency);
            if (moduleId == null) continue;
            modules.add(moduleId);
            boolean alreadyVisited = !visited.add((ComponentIdentifier)renderableDependency.getId());
            if (alreadyVisited) continue;
            this.populateModulesWithChildDependencies(renderableDependency, visited, modules);
        }
    }

    private Map<String, Object> createModuleInsight(ModuleIdentifier module, Configuration configuration2) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2);
        map.put("module", module.toString());
        map.put("insight", this.createInsight(module, configuration2));
        return map;
    }

    private List<Object> createInsight(ModuleIdentifier module, Configuration configuration2) {
        StrictDependencyResultSpec dependencySpec = new StrictDependencyResultSpec(module);
        ResolutionResult result2 = configuration2.getIncoming().getResolutionResult();
        LinkedHashSet<DependencyResult> selectedDependencies = new LinkedHashSet<DependencyResult>();
        result2.allDependencies(it -> {
            if (dependencySpec.isSatisfiedBy(it)) {
                selectedDependencies.add((DependencyResult)it);
            }
        });
        Collection<RenderableDependency> sortedDeps = new DependencyInsightReporter(this.versionSelectorScheme, this.versionComparator, this.versionParser).convertToRenderableItems(selectedDependencies, false);
        return CollectionUtils.collect(sortedDeps, dependency -> {
            String name = this.replaceArrow(dependency.getName());
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(5);
            map.put("name", this.replaceArrow(dependency.getName()));
            map.put("description", dependency.getDescription());
            map.put("resolvable", (Object)dependency.getResolutionState());
            map.put("hasConflict", !name.equals(dependency.getName()));
            map.put("children", this.createInsightDependencyChildren((RenderableDependency)dependency, (Set<Object>)new HashSet<Object>(), configuration2));
            return map;
        });
    }

    private List<Object> createInsightDependencyChildren(RenderableDependency dependency, Set<Object> visited, Configuration configuration2) {
        Set<? extends RenderableDependency> children = dependency.getChildren();
        return CollectionUtils.collect(children, childDependency -> {
            boolean alreadyVisited = !visited.add(childDependency.getId());
            boolean leaf = childDependency.getChildren().isEmpty();
            boolean alreadyRendered = alreadyVisited && !leaf;
            String childName = this.replaceArrow(childDependency.getName());
            boolean hasConflict = !childName.equals(childDependency.getName());
            String name = leaf ? configuration2.getName() : childName;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(6);
            map.put("name", name);
            map.put("resolvable", (Object)childDependency.getResolutionState());
            map.put("hasConflict", hasConflict);
            map.put("alreadyRendered", alreadyRendered);
            map.put("isLeaf", leaf);
            map.put("children", Collections.emptyList());
            if (!alreadyRendered) {
                map.put("children", this.createInsightDependencyChildren((RenderableDependency)childDependency, visited, configuration2));
            }
            return map;
        });
    }

    private String replaceArrow(String name) {
        return name.replace(" -> ", " \u27a1 ");
    }
}

