/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.util.List;
import org.gradle.internal.hash.Hashable;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

class AbstractListSnapshot<T extends Hashable>
implements Hashable {
    protected final ImmutableList<T> elements;

    public AbstractListSnapshot(ImmutableList<T> elements) {
        this.elements = elements;
    }

    public List<T> getElements() {
        return this.elements;
    }

    @Override
    public void appendToHasher(Hasher hasher) {
        hasher.putString("List");
        hasher.putInt(this.elements.size());
        for (Hashable element : this.elements) {
            element.appendToHasher(hasher);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractListSnapshot other = (AbstractListSnapshot)obj;
        return this.elements.equals(other.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }
}

