/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.jvm.toolchain.internal.JavaCompilerFactory;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainInput;
import org.gradle.jvm.toolchain.internal.ToolchainToolFactory;

public class JavaToolchainFactory {
    private final JavaCompilerFactory compilerFactory;
    private final ToolchainToolFactory toolFactory;
    private final FileFactory fileFactory;
    private final JvmMetadataDetector detector;

    @Inject
    public JavaToolchainFactory(JvmMetadataDetector detector, JavaCompilerFactory compilerFactory, ToolchainToolFactory toolFactory, FileFactory fileFactory) {
        this.detector = detector;
        this.compilerFactory = compilerFactory;
        this.toolFactory = toolFactory;
        this.fileFactory = fileFactory;
    }

    public Optional<JavaToolchain> newInstance(File javaHome, JavaToolchainInput input) {
        JvmInstallationMetadata metadata = this.detector.getMetadata(javaHome);
        if (metadata.isValidInstallation()) {
            JavaToolchain toolchain = new JavaToolchain(metadata, this.compilerFactory, this.toolFactory, this.fileFactory, input);
            return Optional.of(toolchain);
        }
        return Optional.empty();
    }
}

