/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ear;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ear.Ear;
import org.gradle.plugins.ear.EarPluginConvention;
import org.gradle.plugins.ear.descriptor.DeploymentDescriptor;
import org.gradle.plugins.ear.internal.DefaultEarPluginConvention;

public class EarPlugin
implements Plugin<Project> {
    public static final String EAR_TASK_NAME = "ear";
    public static final String DEPLOY_CONFIGURATION_NAME = "deploy";
    public static final String EARLIB_CONFIGURATION_NAME = "earlib";
    static final String DEFAULT_LIB_DIR_NAME = "lib";
    private final ObjectFactory objectFactory;
    private final JvmPluginServices jvmPluginServices;

    @Inject
    public EarPlugin(ObjectFactory objectFactory, JvmPluginServices jvmPluginServices) {
        this.objectFactory = objectFactory;
        this.jvmPluginServices = jvmPluginServices;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        EarPluginConvention earPluginConvention = this.objectFactory.newInstance(DefaultEarPluginConvention.class, new Object[0]);
        project.getConvention().getPlugins().put(EAR_TASK_NAME, earPluginConvention);
        earPluginConvention.setLibDirName(DEFAULT_LIB_DIR_NAME);
        earPluginConvention.setAppDirName("src/main/application");
        this.configureConfigurations(project);
        PluginContainer plugins = project.getPlugins();
        this.setupEarTask(project, earPluginConvention, plugins);
        this.wireEarTaskConventions(project, earPluginConvention);
        this.wireEarTaskConventionsWithJavaPluginApplied(project, plugins);
    }

    private void wireEarTaskConventionsWithJavaPluginApplied(Project project, PluginContainer plugins) {
        plugins.withType(JavaPlugin.class, javaPlugin -> {
            JavaPluginExtension javaPluginExtension = project.getExtensions().findByType(JavaPluginExtension.class);
            project.getTasks().withType(Ear.class).configureEach(task -> {
                task.dependsOn(() -> this.mainSourceSetOf(javaPluginExtension).getRuntimeClasspath());
                task.from(() -> this.mainSourceSetOf(javaPluginExtension).getOutput());
            });
        });
    }

    private SourceSet mainSourceSetOf(JavaPluginExtension javaPluginExtension) {
        return (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
    }

    private void setupEarTask(final Project project, final EarPluginConvention convention, final PluginContainer plugins) {
        NamedDomainObjectProvider ear = project.getTasks().register(EAR_TASK_NAME, Ear.class, new Action<Ear>(){

            @Override
            public void execute(Ear ear) {
                ear.setDescription("Generates a ear archive with all the modules, the application descriptor and the libraries.");
                ear.setGroup("build");
                ear.getGenerateDeploymentDescriptor().convention(convention.getGenerateDeploymentDescriptor());
                plugins.withType(JavaPlugin.class, javaPlugin -> {
                    JavaPluginExtension javaPluginExtension = project.getExtensions().findByType(JavaPluginExtension.class);
                    SourceSet sourceSet = EarPlugin.this.mainSourceSetOf(javaPluginExtension);
                    sourceSet.getResources().srcDir(ear.getAppDirectory());
                });
            }
        });
        DeploymentDescriptor deploymentDescriptor = convention.getDeploymentDescriptor();
        if (deploymentDescriptor != null) {
            if (deploymentDescriptor.getDisplayName() == null) {
                deploymentDescriptor.setDisplayName(project.getName());
            }
            if (deploymentDescriptor.getDescription() == null) {
                deploymentDescriptor.setDescription(project.getDescription());
            }
        }
        project.getExtensions().getByType(DefaultArtifactPublicationSet.class).addCandidate(new LazyPublishArtifact(ear, ((ProjectInternal)project).getFileResolver()));
        project.getTasks().withType(Ear.class).configureEach(new Action<Ear>(){

            @Override
            public void execute(Ear task) {
            }
        });
    }

    private void wireEarTaskConventions(final Project project, final EarPluginConvention earConvention) {
        project.getTasks().withType(Ear.class).configureEach(new Action<Ear>(){

            @Override
            public void execute(Ear task) {
                task.getAppDirectory().convention(project.provider(() -> project.getLayout().getProjectDirectory().dir(earConvention.getAppDirName())));
                task.getConventionMapping().map("libDirName", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return earConvention.getLibDirName();
                    }
                });
                task.getConventionMapping().map("deploymentDescriptor", new Callable<DeploymentDescriptor>(){

                    @Override
                    public DeploymentDescriptor call() throws Exception {
                        return earConvention.getDeploymentDescriptor();
                    }
                });
                task.from(() -> {
                    if (project.getPlugins().hasPlugin(JavaPlugin.class)) {
                        return null;
                    }
                    return task.getAppDirectory().getAsFileTree();
                });
                task.getLib().from(new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return project.getConfigurations().getByName(EarPlugin.EARLIB_CONFIGURATION_NAME).minus(project.getConfigurations().getByName(EarPlugin.DEPLOY_CONFIGURATION_NAME));
                    }
                });
                task.from(new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return project.getConfigurations().getByName(EarPlugin.DEPLOY_CONFIGURATION_NAME);
                    }
                });
            }
        });
    }

    private void configureConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration moduleConfiguration = ((Configuration)configurations.create(DEPLOY_CONFIGURATION_NAME)).setVisible(false).setTransitive(false).setDescription("Classpath for deployable modules, not transitive.");
        this.jvmPluginServices.configureAttributes(moduleConfiguration, details -> details.library().runtimeUsage().withExternalDependencies());
        Configuration earlibConfiguration = ((Configuration)configurations.create(EARLIB_CONFIGURATION_NAME)).setVisible(false).setDescription("Classpath for module dependencies.");
        this.jvmPluginServices.configureAttributes(earlibConfiguration, details -> details.library().runtimeUsage().withExternalDependencies());
        configurations.getByName("default").extendsFrom(moduleConfiguration, earlibConfiguration);
    }
}

