/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.plugins.ide.internal.tooling.ToolingModelBuilderSupport;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleProject;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleProjectTask;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleTask;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class GradleProjectBuilder
implements ToolingModelBuilder {
    @Override
    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.GradleProject");
    }

    @Override
    public Object buildAll(String modelName, Project project) {
        return this.buildHierarchy(project.getRootProject());
    }

    public DefaultGradleProject buildAll(Project project) {
        return this.buildHierarchy(project.getRootProject());
    }

    private DefaultGradleProject buildHierarchy(Project project) {
        ArrayList<DefaultGradleProject> children = new ArrayList<DefaultGradleProject>();
        for (Project child : project.getChildProjects().values()) {
            children.add(this.buildHierarchy(child));
        }
        DefaultGradleProject gradleProject = new DefaultGradleProject().setProjectIdentifier(new DefaultProjectIdentifier(project.getRootDir(), project.getPath())).setName(project.getName()).setDescription(project.getDescription()).setBuildDirectory(project.getBuildDir()).setProjectDirectory(project.getProjectDir()).setChildren(children);
        gradleProject.getBuildScript().setSourceFile(project.getBuildFile());
        String projectOptions = System.getProperty("org.gradle.internal.GradleProjectBuilderOptions", "unmodified");
        List<LaunchableGradleTask> tasks = GradleProjectBuilder.tasks(gradleProject, (TaskContainerInternal)project.getTasks(), projectOptions);
        if (!"skip_task_serialization".equals(projectOptions)) {
            gradleProject.setTasks(tasks);
        }
        for (DefaultGradleProject child : children) {
            child.setParent(gradleProject);
        }
        return gradleProject;
    }

    private static List<LaunchableGradleTask> tasks(DefaultGradleProject owner, TaskContainerInternal tasks, String projectOptions) {
        if ("omit_all_tasks".equals(projectOptions)) {
            return Collections.emptyList();
        }
        if ("skip_task_graph_realization".equals(projectOptions)) {
            return tasks.getNames().stream().map(t -> GradleProjectBuilder.buildFromTaskName(new LaunchableGradleProjectTask(), owner.getProjectIdentifier(), t)).collect(Collectors.toList());
        }
        tasks.discoverTasks();
        tasks.realize();
        SortedSet<String> taskNames = tasks.getNames();
        ArrayList<LaunchableGradleTask> out = new ArrayList<LaunchableGradleTask>(taskNames.size());
        for (String taskName : taskNames) {
            Task t2 = (Task)tasks.findByName(taskName);
            if (t2 == null) continue;
            out.add(ToolingModelBuilderSupport.buildFromTask(new LaunchableGradleProjectTask(), owner.getProjectIdentifier(), t2).setProject(owner));
        }
        return out;
    }

    public static <T extends LaunchableGradleTask> T buildFromTaskName(T target, DefaultProjectIdentifier projectIdentifier, String taskName) {
        String taskPath = projectIdentifier.getProjectPath() + ":" + taskName;
        target.setPath(taskPath).setName(taskName).setGroup("undefined").setDisplayName(taskPath).setDescription("").setPublic(true).setProjectIdentifier(projectIdentifier);
        return target;
    }
}

