/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.match;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchNode;

public class MatchEngine {
    private static final Map<String, IMatchable.MatchProperties> stat_properties = Map.of("type", IMatchable.MatchProperties.STATEMENT_TYPE, "ret", IMatchable.MatchProperties.STATEMENT_RET, "position", IMatchable.MatchProperties.STATEMENT_POSITION, "statsize", IMatchable.MatchProperties.STATEMENT_STATSIZE, "exprsize", IMatchable.MatchProperties.STATEMENT_EXPRSIZE, "iftype", IMatchable.MatchProperties.STATEMENT_IFTYPE);
    private static final Map<String, IMatchable.MatchProperties> expr_properties = Map.ofEntries(Map.entry("type", IMatchable.MatchProperties.EXPRENT_TYPE), Map.entry("ret", IMatchable.MatchProperties.EXPRENT_RET), Map.entry("position", IMatchable.MatchProperties.EXPRENT_POSITION), Map.entry("functype", IMatchable.MatchProperties.EXPRENT_FUNCTYPE), Map.entry("exittype", IMatchable.MatchProperties.EXPRENT_EXITTYPE), Map.entry("consttype", IMatchable.MatchProperties.EXPRENT_CONSTTYPE), Map.entry("constvalue", IMatchable.MatchProperties.EXPRENT_CONSTVALUE), Map.entry("invclass", IMatchable.MatchProperties.EXPRENT_INVOCATION_CLASS), Map.entry("signature", IMatchable.MatchProperties.EXPRENT_INVOCATION_SIGNATURE), Map.entry("parameter", IMatchable.MatchProperties.EXPRENT_INVOCATION_PARAMETER), Map.entry("index", IMatchable.MatchProperties.EXPRENT_VAR_INDEX), Map.entry("name", IMatchable.MatchProperties.EXPRENT_FIELD_NAME));
    private static final Map<String, Statement.StatementType> stat_type = Map.of("if", Statement.StatementType.IF, "do", Statement.StatementType.DO, "switch", Statement.StatementType.SWITCH, "trycatch", Statement.StatementType.TRY_CATCH, "basicblock", Statement.StatementType.BASIC_BLOCK, "sequence", Statement.StatementType.SEQUENCE);
    private static final Map<String, Integer> expr_type = Map.ofEntries(Map.entry("array", 1), Map.entry("assignment", 2), Map.entry("constant", 3), Map.entry("exit", 4), Map.entry("field", 5), Map.entry("function", 6), Map.entry("if", 7), Map.entry("invocation", 8), Map.entry("monitor", 9), Map.entry("new", 10), Map.entry("switch", 11), Map.entry("var", 12), Map.entry("annotation", 13), Map.entry("assert", 14));
    private static final Map<String, Integer> expr_func_type = Map.of("eq", 42);
    private static final Map<String, Integer> expr_exit_type = Map.of("return", 0, "throw", 1);
    private static final Map<String, Integer> stat_if_type = Map.of("if", 0, "ifelse", 1);
    private static final Map<String, VarType> expr_const_type = Map.of("null", VarType.VARTYPE_NULL, "string", VarType.VARTYPE_STRING);
    private final MatchNode rootNode;
    private final Map<String, Object> variables = new HashMap<String, Object>();

    public MatchEngine(String description) {
        String[] lines = description.split("\n");
        int depth = 0;
        LinkedList<MatchNode> stack = new LinkedList<MatchNode>();
        for (String line : lines) {
            int new_depth;
            ArrayList<String> properties = new ArrayList<String>(Arrays.asList(line.split("\\s+")));
            if (((String)properties.get(0)).isEmpty()) {
                properties.remove(0);
            }
            int node_type = "statement".equals(properties.get(0)) ? 0 : 1;
            MatchNode matchNode = new MatchNode(node_type);
            for (int i = 1; i < properties.size(); ++i) {
                Object value;
                String[] values;
                IMatchable.MatchProperties property = (node_type == 0 ? stat_properties : expr_properties).get((values = ((String)properties.get(i)).split(":"))[0]);
                if (property == null) {
                    throw new RuntimeException("Unknown matching property");
                }
                int parameter = 0;
                String strValue = values[1];
                if (values.length == 3) {
                    parameter = Integer.parseInt(values[1]);
                    strValue = values[2];
                }
                switch (property) {
                    case STATEMENT_TYPE: {
                        value = stat_type.get(strValue);
                        break;
                    }
                    case STATEMENT_STATSIZE: 
                    case STATEMENT_EXPRSIZE: {
                        value = Integer.valueOf(strValue);
                        break;
                    }
                    case STATEMENT_POSITION: 
                    case EXPRENT_POSITION: 
                    case EXPRENT_INVOCATION_CLASS: 
                    case EXPRENT_INVOCATION_SIGNATURE: 
                    case EXPRENT_INVOCATION_PARAMETER: 
                    case EXPRENT_VAR_INDEX: 
                    case EXPRENT_FIELD_NAME: 
                    case EXPRENT_CONSTVALUE: 
                    case STATEMENT_RET: 
                    case EXPRENT_RET: {
                        value = strValue;
                        break;
                    }
                    case STATEMENT_IFTYPE: {
                        value = stat_if_type.get(strValue);
                        break;
                    }
                    case EXPRENT_FUNCTYPE: {
                        value = expr_func_type.get(strValue);
                        break;
                    }
                    case EXPRENT_EXITTYPE: {
                        value = expr_exit_type.get(strValue);
                        break;
                    }
                    case EXPRENT_CONSTTYPE: {
                        value = expr_const_type.get(strValue);
                        break;
                    }
                    case EXPRENT_TYPE: {
                        value = expr_type.get(strValue);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhandled matching property");
                    }
                }
                matchNode.addRule(property, new MatchNode.RuleValue(parameter, value));
            }
            if (stack.isEmpty()) {
                stack.push(matchNode);
                continue;
            }
            for (int i = new_depth = line.lastIndexOf(32, depth) + 1; i <= depth; ++i) {
                stack.pop();
            }
            ((MatchNode)stack.getFirst()).addChild(matchNode);
            stack.push(matchNode);
            depth = new_depth;
        }
        this.rootNode = (MatchNode)stack.getLast();
    }

    public boolean match(IMatchable object) {
        this.variables.clear();
        return this.match(this.rootNode, object);
    }

    private boolean match(MatchNode matchNode, IMatchable object) {
        if (!object.match(matchNode, this)) {
            return false;
        }
        int expr_index = 0;
        int stat_index = 0;
        Iterator<MatchNode> iterator = matchNode.getChildren().iterator();
        while (iterator.hasNext()) {
            MatchNode childNode;
            boolean isStatement = (childNode = iterator.next()).getType() == 0;
            IMatchable childObject = object.findObject(childNode, isStatement ? stat_index : expr_index);
            if (childObject == null || !this.match(childNode, childObject)) {
                return false;
            }
            if (isStatement) {
                ++stat_index;
                continue;
            }
            ++expr_index;
        }
        return true;
    }

    public boolean checkAndSetVariableValue(String name, Object value) {
        Object old_value = this.variables.get(name);
        if (old_value != null) {
            return old_value.equals(value);
        }
        this.variables.put(name, value);
        return true;
    }

    public Object getVariableValue(String name) {
        return this.variables.get(name);
    }
}

