/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class PluginStartupApplicationService
implements Disposable {
    private String aliveFlagPath;

    public static PluginStartupApplicationService getInstance() {
        return (PluginStartupApplicationService)ApplicationManager.getApplication().getService(PluginStartupApplicationService.class);
    }

    public synchronized String getAliveFlagPath() {
        if (this.aliveFlagPath == null) {
            try {
                Path flagFile = Files.createTempFile("kotlin-idea-", "-is-running", new FileAttribute[0]);
                final File file2 = flagFile.toFile();
                Disposer.register((Disposable)this, (Disposable)new Disposable(){

                    public void dispose() {
                        file2.delete();
                    }
                });
                this.aliveFlagPath = flagFile.toAbsolutePath().toString();
            }
            catch (IOException e) {
                this.aliveFlagPath = "";
            }
        }
        return this.aliveFlagPath;
    }

    public synchronized void resetAliveFlag() {
        if (this.aliveFlagPath != null && !this.aliveFlagPath.isEmpty()) {
            Path flagFile = Path.of(this.aliveFlagPath, new String[0]);
            try {
                if (PathKt.isFile((Path)flagFile) && PathKt.exists((Path)flagFile) && Files.deleteIfExists(flagFile)) {
                    this.aliveFlagPath = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void dispose() {
    }
}

