/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.PluginStartupApplicationService;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinArtifactsDownloader;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerWorkspaceSettings;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinBuildProcessParametersProvider;", "Lcom/intellij/compiler/server/BuildProcessParametersProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getPathParameters", "", "Lcom/intellij/openapi/util/Pair;", "", "Ljava/nio/file/Path;", "getVMArguments", "", "kotlin.jvm"})
public final class KotlinBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    private final Project project;

    @NotNull
    public List<String> getVMArguments() {
        String string;
        KotlinCompilerWorkspaceSettings compilerWorkspaceSettings = KotlinCompilerWorkspaceSettings.Companion.getInstance(this.project);
        ArrayList<Object> res = new ArrayList<Object>();
        if (compilerWorkspaceSettings.getPreciseIncrementalEnabled()) {
            res.add("-Dkotlin.incremental.compilation=true");
        }
        if (compilerWorkspaceSettings.getIncrementalCompilationForJsEnabled()) {
            res.add("-Dkotlin.incremental.compilation.js=true");
        }
        if (compilerWorkspaceSettings.getEnableDaemon()) {
            res.add("-Dkotlin.daemon.enabled");
        }
        if (Registry.is((String)"kotlin.jps.instrument.bytecode", (boolean)false)) {
            res.add("-Dkotlin.jps.instrument.bytecode=true");
        }
        PluginStartupApplicationService pluginStartupApplicationService = PluginStartupApplicationService.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)pluginStartupApplicationService, (String)"PluginStartupApplicationService.getInstance()");
        String it = string = pluginStartupApplicationService.getAliveFlagPath();
        boolean bl = false;
        String string2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
        if (!StringsKt.isBlank((CharSequence)string2)) {
            res.add("-Dkotlin.daemon.client.alive.path=\"" + it + "\"");
        }
        return res;
    }

    @NotNull
    public List<Pair<String, Path>> getPathParameters() {
        Pair pair;
        Pair it = pair = new Pair((Object)"-Djps.kotlin.home=", (Object)KotlinArtifactsDownloader.INSTANCE.getUnpackedKotlinDistPath(this.project).toPath());
        boolean bl = false;
        Object object = it.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.second");
        return CollectionsKt.listOfNotNull((Object)(PathKt.isDirectory((Path)((Path)object)) ? pair : null));
    }

    public KotlinBuildProcessParametersProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }
}

