/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.configuration.DefaultScriptingSupportKt;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationCache;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationState;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.ScriptClassRootsStorage;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.UtilsKt;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsBuilder;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsUpdater;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0006H$J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\"\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u00182\b\b\u0002\u0010\u001f\u001a\u00020\u0018J\u0012\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u001d\u001a\u0004\u0018\u00010\"J\u0012\u0010#\u001a\u0004\u0018\u00010$2\b\u0010\u001d\u001a\u0004\u0018\u00010\"J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010)\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\u000e\u0010*\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001bJ\u000e\u0010+\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001bJ$\u0010,\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u00182\b\b\u0002\u0010\u001f\u001a\u00020\u0018H\u0002J8\u0010-\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001b2\b\b\u0002\u0010.\u001a\u00020\u00182\b\b\u0002\u0010\u001f\u001a\u00020\u00182\b\b\u0002\u0010/\u001a\u00020\u00182\b\b\u0002\u0010\u001e\u001a\u00020\u0018H$J$\u00100\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\"2\b\u00101\u001a\u0004\u0018\u00010!2\b\b\u0002\u00102\u001a\u00020\u0018H\u0014J\u0018\u00103\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\"2\u0006\u00104\u001a\u00020!H\u0004J\u0015\u00105\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u000206H\u0001\u00a2\u0006\u0002\b7R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/DefaultScriptingSupportBase;", "", "manager", "Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "(Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;)V", "cache", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationCache;", "getCache$annotations", "()V", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationCache;", "getManager", "()Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "collectConfigurations", "", "builder", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder;", "collectConfigurationsWithCache", "createCache", "ensureLoadedFromCache", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "ensureUpToDatedConfigurationSuggested", "file", "skipNotification", "forceSync", "getAppliedConfiguration", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationSnapshot;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCachedConfigurationState", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationState;", "getOrLoadConfiguration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "virtualFile", "preloadedKtFile", "hasCachedConfiguration", "isConfigurationLoadingInProgress", "isLoadedFromCache", "reloadIfOutOfDate", "reloadOutOfDateConfiguration", "isFirstLoad", "fromCacheOnly", "setAppliedConfiguration", "newConfigurationSnapshot", "syncUpdate", "setLoadedConfiguration", "configurationSnapshot", "updateScriptDependenciesSynchronously", "Lcom/intellij/psi/PsiFile;", "updateScriptDependenciesSynchronously$kotlin_core", "kotlin.core"})
public abstract class DefaultScriptingSupportBase {
    @NotNull
    private final ScriptConfigurationCache cache;
    @NotNull
    private final CompositeScriptConfigurationManager manager;

    @NotNull
    public final Project getProject() {
        return this.manager.getProject();
    }

    protected static /* synthetic */ void getCache$annotations() {
    }

    @NotNull
    protected final ScriptConfigurationCache getCache() {
        return this.cache;
    }

    @NotNull
    protected abstract ScriptConfigurationCache createCache();

    protected abstract boolean reloadOutOfDateConfiguration(@NotNull KtFile var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public static /* synthetic */ boolean reloadOutOfDateConfiguration$default(DefaultScriptingSupportBase defaultScriptingSupportBase, KtFile ktFile, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reloadOutOfDateConfiguration");
        }
        if ((n & 2) != 0) {
            PsiFile psiFile2 = ktFile.getOriginalFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file.originalFile");
            boolean bl5 = bl = defaultScriptingSupportBase.getAppliedConfiguration(psiFile2.getVirtualFile()) == null;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        return defaultScriptingSupportBase.reloadOutOfDateConfiguration(ktFile, bl, bl2, bl3, bl4);
    }

    @Nullable
    public final ScriptConfigurationState getCachedConfigurationState(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        return this.cache.get(file2);
    }

    @Nullable
    public final ScriptConfigurationSnapshot getAppliedConfiguration(@Nullable VirtualFile file2) {
        ScriptConfigurationState scriptConfigurationState = this.getCachedConfigurationState(file2);
        return scriptConfigurationState != null ? scriptConfigurationState.getApplied() : null;
    }

    private final boolean hasCachedConfiguration(KtFile file2) {
        PsiFile psiFile2 = file2.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file.originalFile");
        return this.getAppliedConfiguration(psiFile2.getVirtualFile()) != null;
    }

    public final boolean isConfigurationLoadingInProgress(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return !this.hasCachedConfiguration(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ScriptCompilationConfigurationWrapper getOrLoadConfiguration(@NotNull VirtualFile virtualFile2, @Nullable KtFile preloadedKtFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        ScriptConfigurationSnapshot cached2 = this.getAppliedConfiguration(virtualFile2);
        if (cached2 != null) {
            return cached2.getConfiguration();
        }
        KtFile ktFile = UtilsKt.getKtFile(this.getProject(), virtualFile2, preloadedKtFile);
        if (ktFile == null) {
            return null;
        }
        KtFile ktFile2 = ktFile;
        ScriptClassRootsUpdater this_$iv = this.manager.getUpdater();
        boolean $i$f$update = false;
        this_$iv.beginUpdating();
        try {
            boolean bl = false;
            boolean bl2 = DefaultScriptingSupportBase.reloadOutOfDateConfiguration$default(this, ktFile2, true, false, false, false, 28, null);
        }
        finally {
            this_$iv.commit();
        }
        ScriptConfigurationSnapshot scriptConfigurationSnapshot = this.getAppliedConfiguration(virtualFile2);
        return scriptConfigurationSnapshot != null ? scriptConfigurationSnapshot.getConfiguration() : null;
    }

    public final void ensureUpToDatedConfigurationSuggested(@NotNull KtFile file2, boolean skipNotification, boolean forceSync) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.reloadIfOutOfDate(file2, skipNotification, forceSync);
    }

    public static /* synthetic */ void ensureUpToDatedConfigurationSuggested$default(DefaultScriptingSupportBase defaultScriptingSupportBase, KtFile ktFile, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ensureUpToDatedConfigurationSuggested");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        defaultScriptingSupportBase.ensureUpToDatedConfigurationSuggested(ktFile, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reloadIfOutOfDate(KtFile file2, boolean skipNotification, boolean forceSync) {
        if (!forceSync && !ScriptDefinitionsManager.Companion.getInstance(this.getProject()).isReady()) {
            return;
        }
        ScriptClassRootsUpdater this_$iv = this.manager.getUpdater();
        boolean $i$f$update = false;
        this_$iv.beginUpdating();
        try {
            Unit unit;
            boolean bl = false;
            PsiFile psiFile2 = file2.getOriginalFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file.originalFile");
            VirtualFile virtualFile2 = psiFile2.getVirtualFile();
            if (virtualFile2 != null) {
                VirtualFile virtualFile3;
                VirtualFile virtualFile4 = virtualFile3 = virtualFile2;
                boolean bl2 = false;
                ScriptConfigurationState state = this.cache.get(virtualFile4);
                if (state == null || forceSync || !state.isUpToDate(this.getProject(), virtualFile4, file2)) {
                    boolean bl3 = skipNotification;
                    boolean bl4 = false;
                    boolean bl5 = state == null;
                    boolean bl6 = forceSync;
                    DefaultScriptingSupportBase.reloadOutOfDateConfiguration$default(this, file2, bl5, bl6, bl4, bl3, 8, null);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            this_$iv.commit();
        }
    }

    static /* synthetic */ void reloadIfOutOfDate$default(DefaultScriptingSupportBase defaultScriptingSupportBase, KtFile ktFile, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reloadIfOutOfDate");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        defaultScriptingSupportBase.reloadIfOutOfDate(ktFile, bl, bl2);
    }

    public final boolean isLoadedFromCache(@NotNull KtFile file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!ScriptDefinitionsManager.Companion.getInstance(this.getProject()).isReady()) {
            return false;
        }
        PsiFile psiFile2 = file2.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file.originalFile");
        VirtualFile virtualFile2 = psiFile2.getVirtualFile();
        if (virtualFile2 != null) {
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = virtualFile2;
            boolean bl2 = false;
            bl = this.cache.get(it) != null;
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean ensureLoadedFromCache(@NotNull List<? extends KtFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        if (!ScriptDefinitionsManager.Companion.getInstance(this.getProject()).isReady()) {
            return false;
        }
        boolean allLoaded = true;
        ScriptClassRootsUpdater this_$iv = this.manager.getUpdater();
        boolean $i$f$update = false;
        this_$iv.beginUpdating();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = files2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DefaultScriptingSupportBase defaultScriptingSupportBase;
                VirtualFile virtualFile2;
                KtFile file2 = (KtFile)element$iv;
                boolean bl2 = false;
                PsiFile psiFile2 = file2.getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file.originalFile");
                if (psiFile2.getVirtualFile() == null) continue;
                VirtualFile virtualFile3 = virtualFile2;
                boolean bl3 = false;
                ScriptConfigurationState scriptConfigurationState = this.cache.get(virtualFile3);
                if (scriptConfigurationState != null) continue;
                DefaultScriptingSupportBase $this$run = defaultScriptingSupportBase = this;
                boolean bl4 = false;
                if (!DefaultScriptingSupportBase.reloadOutOfDateConfiguration$default($this$run, file2, true, false, true, false, 20, null)) {
                    allLoaded = false;
                }
                scriptConfigurationState = Unit.INSTANCE;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.commit();
        }
        return allLoaded;
    }

    protected void setAppliedConfiguration(@NotNull VirtualFile file2, @Nullable ScriptConfigurationSnapshot newConfigurationSnapshot, boolean syncUpdate) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.manager.getUpdater().checkInTransaction();
        ScriptConfigurationSnapshot scriptConfigurationSnapshot = newConfigurationSnapshot;
        ScriptCompilationConfigurationWrapper newConfiguration = scriptConfigurationSnapshot != null ? scriptConfigurationSnapshot.getConfiguration() : null;
        ScriptUtilsKt.scriptingDebugLog(file2, (Function0<String>)((Function0)new Function0<String>(newConfiguration){
            final /* synthetic */ ScriptCompilationConfigurationWrapper $newConfiguration;

            @NotNull
            public final String invoke() {
                return "configuration changed = " + this.$newConfiguration;
            }
            {
                this.$newConfiguration = scriptCompilationConfigurationWrapper;
                super(0);
            }
        }));
        if (newConfiguration != null) {
            this.cache.setApplied(file2, newConfigurationSnapshot);
            this.manager.getUpdater().invalidate(file2, syncUpdate);
        }
    }

    public static /* synthetic */ void setAppliedConfiguration$default(DefaultScriptingSupportBase defaultScriptingSupportBase, VirtualFile virtualFile2, ScriptConfigurationSnapshot scriptConfigurationSnapshot, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setAppliedConfiguration");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        defaultScriptingSupportBase.setAppliedConfiguration(virtualFile2, scriptConfigurationSnapshot, bl);
    }

    protected final void setLoadedConfiguration(@NotNull VirtualFile file2, @NotNull ScriptConfigurationSnapshot configurationSnapshot) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configurationSnapshot, (String)"configurationSnapshot");
        this.cache.setLoaded(file2, configurationSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void updateScriptDependenciesSynchronously$kotlin_core(@NotNull PsiFile file2) {
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (DefinitionsKt.findScriptDefinition(file2) == null) {
            return;
        }
        PsiFile psiFile2 = file2;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        if ((KtFile)psiFile2 == null) {
            String string = "PsiFile " + file2 + " should be a KtFile, otherwise script dependencies cannot be loaded";
            throw new IllegalStateException(string.toString());
        }
        VirtualFile virtualFile3 = virtualFile2 = ((KtFile)file2).getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"virtualFile");
        ScriptConfigurationState scriptConfigurationState = this.cache.get(virtualFile3);
        if (scriptConfigurationState != null) {
            if (scriptConfigurationState.isUpToDate(this.getProject(), virtualFile2, (KtFile)file2)) {
                return;
            }
        }
        ScriptClassRootsUpdater this_$iv = this.manager.getUpdater();
        boolean $i$f$update = false;
        this_$iv.beginUpdating();
        try {
            boolean bl = false;
            boolean bl2 = DefaultScriptingSupportBase.reloadOutOfDateConfiguration$default(this, (KtFile)file2, false, true, false, false, 26, null);
        }
        finally {
            this_$iv.commit();
        }
        UIUtil.dispatchAllInvocationEvents();
    }

    /*
     * WARNING - void declaration
     */
    private final void collectConfigurationsWithCache(ScriptClassRootsBuilder builder) {
        ScriptClassRootsStorage rootsStorage = ScriptClassRootsStorage.Companion.getInstance(this.getProject());
        ScriptClassRootsBuilder storageBuilder = ScriptClassRootsBuilder.Companion.fromStorage(this.getProject(), rootsStorage);
        ScriptClassRootsBuilder ownBuilder = new ScriptClassRootsBuilder(storageBuilder);
        Iterable $this$forEach$iv = this.cache.allApplied();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void vFile;
            Pair $dstr$vFile$configuration = (Pair)element$iv;
            boolean bl = false;
            VirtualFile virtualFile2 = (VirtualFile)$dstr$vFile$configuration.component1();
            ScriptCompilationConfigurationWrapper configuration2 = (ScriptCompilationConfigurationWrapper)$dstr$vFile$configuration.component2();
            ownBuilder.add((VirtualFile)vFile, configuration2);
            if (ScratchUtil.isScratch((VirtualFile)vFile)) continue;
            storageBuilder.add((VirtualFile)vFile, configuration2);
        }
        storageBuilder.toStorage(rootsStorage);
        builder.add(ownBuilder);
    }

    /*
     * WARNING - void declaration
     */
    public final void collectConfigurations(@NotNull ScriptClassRootsBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (DefaultScriptingSupportKt.isFSRootsStorageEnabled()) {
            this.collectConfigurationsWithCache(builder);
        } else {
            Iterable $this$forEach$iv = this.cache.allApplied();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void vFile;
                Pair $dstr$vFile$configuration = (Pair)element$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = (VirtualFile)$dstr$vFile$configuration.component1();
                ScriptCompilationConfigurationWrapper configuration2 = (ScriptCompilationConfigurationWrapper)$dstr$vFile$configuration.component2();
                builder.add((VirtualFile)vFile, configuration2);
            }
        }
    }

    @NotNull
    public final CompositeScriptConfigurationManager getManager() {
        return this.manager;
    }

    public DefaultScriptingSupportBase(@NotNull CompositeScriptConfigurationManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.cache = this.createCache();
    }
}

