/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpointType;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a+\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0001\"\n\b\u0000\u0010\u000b\u0018\u0001*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\b\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00012\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a \u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a2\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001e0\u001d\u001a\f\u0010\u001f\u001a\u00020\u001a*\u00020 H\u0000\u00a8\u0006!"}, d2={"computeLineBreakpointVariants", "", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType;", "project", "Lcom/intellij/openapi/project/Project;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "kotlinBreakpointType", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType;", "getElementsAtLineIfAny", "T", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "getLambdasAtLineIfAny", "Lorg/jetbrains/kotlin/psi/KtFunction;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getTopmostParentOnLineOrSelf", "element", "document", "Lcom/intellij/openapi/editor/Document;", "isBreakpointApplicable", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "checker", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/ApplicabilityResult;", "isInlineOnly", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "kotlin.jvm-debugger.core"})
public final class BreakpointTypeUtilsKt {
    public static final boolean isBreakpointApplicable(@NotNull VirtualFile file2, int line, @NotNull Project project2, @NotNull Function1<? super PsiElement, ApplicabilityResult> checker) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter(checker, (String)"checker");
                PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file2);
                if (psiFile2 == null) break block4;
                VirtualFile virtualFile2 = psiFile2.getVirtualFile();
                if (!(Intrinsics.areEqual((Object)(virtualFile2 != null ? virtualFile2.getFileType() : null), (Object)KotlinFileType.INSTANCE) ^ true)) break block5;
            }
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026ent(file) ?: return false");
        Document document2 = document;
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(project2, document2, line, checker){
            final /* synthetic */ Project $project;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $line;
            final /* synthetic */ Function1 $checker;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void isApplicable2;
                Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                booleanRef.element = false;
                HashSet<E> checked = new HashSet<E>();
                XDebuggerUtil.getInstance().iterateLine(this.$project, this.$document, this.$line, new Processor(this, checked, (Ref.BooleanRef)isApplicable2){
                    final /* synthetic */ isBreakpointApplicable.1 this$0;
                    final /* synthetic */ HashSet $checked;
                    final /* synthetic */ Ref.BooleanRef $isApplicable;

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean invoke(@NotNull PsiElement element3) {
                        block6: {
                            block5: {
                                void $this$getParentOfType$iv;
                                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                                if (element3 instanceof PsiWhiteSpace) break block5;
                                PsiElement psiElement2 = element3;
                                boolean strict$iv = false;
                                boolean $i$f$getParentOfType = false;
                                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiComment.class, (boolean)strict$iv) == null && element3.isValid()) break block6;
                            }
                            return true;
                        }
                        PsiElement parent2 = BreakpointTypeUtilsKt.access$getTopmostParentOnLineOrSelf(element3, this.this$0.$document, this.this$0.$line);
                        if (!this.$checked.add(parent2)) {
                            return true;
                        }
                        ApplicabilityResult result2 = (ApplicabilityResult)this.this$0.$checker.invoke((Object)parent2);
                        if (result2.getShouldStop() && !result2.isApplicable()) {
                            this.$isApplicable.element = false;
                            return false;
                        }
                        this.$isApplicable.element |= result2.isApplicable();
                        return !result2.getShouldStop();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$checked = hashSet;
                        this.$isApplicable = booleanRef;
                    }
                });
                return isApplicable2.element;
            }
            {
                this.$project = project2;
                this.$document = document;
                this.$line = n;
                this.$checker = function1;
                super(0);
            }
        });
    }

    private static final PsiElement getTopmostParentOnLineOrSelf(PsiElement element3, Document document, int line) {
        int offset2;
        PsiElement current = element3;
        PsiElement parent2 = current.getParent();
        while (!(parent2 == null || parent2 instanceof PsiFile || (offset2 = parent2.getTextOffset()) > document.getTextLength() || offset2 >= 0 && document.getLineNumber(offset2) != line)) {
            current = parent2;
            parent2 = current.getParent();
        }
        return current;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JavaLineBreakpointType.JavaBreakpointVariant> computeLineBreakpointVariants(@NotNull Project project2, @NotNull XSourcePosition position, @NotNull KotlinLineBreakpointType kotlinBreakpointType) {
        Object element$iv2;
        LinkedList<Object> result2;
        List<KtFunction> lambdas;
        SourcePosition pos;
        block9: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)kotlinBreakpointType, (String)"kotlinBreakpointType");
            PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(position.getFile());
            if (!(psiFile2 instanceof KtFile)) {
                psiFile2 = null;
            }
            KtFile ktFile = (KtFile)psiFile2;
            if (ktFile == null) {
                return CollectionsKt.emptyList();
            }
            KtFile file2 = ktFile;
            SourcePosition sourcePosition2 = pos = SourcePosition.createFromLine((PsiFile)((PsiFile)file2), (int)position.getLine());
            Intrinsics.checkNotNullExpressionValue((Object)sourcePosition2, (String)"pos");
            lambdas = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(sourcePosition2);
            if (lambdas.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            result2 = new LinkedList<Object>();
            PsiElement psiElement2 = pos.getElementAt();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"pos.elementAt");
            Sequence $this$firstIsInstance$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)psiElement2);
            boolean $i$f$firstIsInstance = false;
            for (Object element$iv2 : $this$firstIsInstance$iv) {
                if (!(element$iv2 instanceof KtElement)) continue;
                break block9;
            }
            throw new NoSuchElementException("No element of given type found");
        }
        KtElement elementAt = (KtElement)element$iv2;
        KtFunction mainMethod = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)elementAt), KtFunction.class, (boolean)false);
        boolean mainMethodAdded = false;
        if (mainMethod != null) {
            boolean isLambdaResult;
            KtExpression bodyExpression = mainMethod.getBodyExpression();
            boolean bl = isLambdaResult = bodyExpression instanceof KtLambdaExpression && lambdas.contains(((KtLambdaExpression)bodyExpression).getFunctionLiteral());
            if (!isLambdaResult) {
                PsiElement psiElement3 = CodeInsightUtils.getTopmostElementAtOffset((PsiElement)elementAt, pos.getOffset());
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"CodeInsightUtils.getTopm\u2026et(elementAt, pos.offset)");
                PsiElement variantElement = psiElement3;
                result2.add((Object)kotlinBreakpointType.new KotlinLineBreakpointType.LineKotlinBreakpointVariant(position, variantElement, -1));
                mainMethodAdded = true;
            }
        }
        Iterable $this$forEachIndexed$iv = lambdas;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void lambda2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtFunction ktFunction = (KtFunction)item$iv;
            int ordinal = n;
            boolean bl = false;
            XSourcePositionImpl positionImpl = XSourcePositionImpl.createByElement((PsiElement)((PsiElement)lambda2.getBodyExpression()));
            if (positionImpl == null) continue;
            result2.add(new JavaLineBreakpointType.LambdaJavaBreakpointVariant((JavaLineBreakpointType)kotlinBreakpointType, (XSourcePosition)positionImpl, (PsiElement)lambda2, Integer.valueOf(ordinal)));
        }
        if (mainMethodAdded && result2.size() > 1) {
            result2.add((Object)kotlinBreakpointType.new KotlinLineBreakpointType.KotlinBreakpointVariant(position, lambdas.size()));
        }
        return result2;
    }

    @NotNull
    public static final List<KtFunction> getLambdasAtLineIfAny(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        PsiFile psiFile2 = sourcePosition2.getFile();
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file2 = ktFile;
        return BreakpointTypeUtilsKt.getLambdasAtLineIfAny(file2, sourcePosition2.getLine());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T extends PsiElement> List<T> getElementsAtLineIfAny(KtFile file2, int line) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        int $i$f$getElementsAtLineIfAny = 0;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PsiElement psiElement2 = DebuggerUtilKt.findElementAtLine(file2, line);
        if (!(psiElement2 instanceof KtElement)) {
            psiElement2 = null;
        }
        KtElement ktElement = (KtElement)psiElement2;
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement lineElement = ktElement;
        int start2 = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)lineElement));
        int end = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lineElement));
        for (PsiElement nextSibling = lineElement.getNextSibling(); nextSibling != null && line == PsiLinesUtilsKt.getLineNumber$default(nextSibling, false, 1, null); nextSibling = nextSibling.getNextSibling()) {
            end = PsiUtilsKt.getEndOffset((PsiElement)nextSibling);
        }
        PsiFile psiFile2 = (PsiFile)file2;
        Class[] classArray = new Class[1];
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        classArray[0] = PsiElement.class;
        List<PsiElement> list2 = CodeInsightUtils.findElementsOfClassInRange(psiFile2, start2, end, classArray);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"CodeInsightUtils.findEle\u2026tart, end, T::class.java)");
        Iterable iterable = list2;
        boolean $i$f$filterIsInstance = false;
        void var9_9 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element$iv$iv instanceof Object)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtFunction> getLambdasAtLineIfAny(@NotNull KtFile file2, int line) {
        KtFunction it;
        Iterable $this$filterTo$iv$iv;
        List list2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean $i$f$getElementsAtLineIfAny = false;
        PsiElement psiElement2 = DebuggerUtilKt.findElementAtLine(file2, line);
        if (!(psiElement2 instanceof KtElement)) {
            psiElement2 = null;
        }
        KtElement ktElement = (KtElement)psiElement2;
        if (ktElement == null) {
            list2 = CollectionsKt.emptyList();
        } else {
            void $this$filterIsInstanceTo$iv$iv$iv;
            void $this$filterIsInstance$iv$iv;
            KtElement lineElement$iv = ktElement;
            int start$iv = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)lineElement$iv));
            int end$iv = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lineElement$iv));
            for (PsiElement nextSibling$iv = lineElement$iv.getNextSibling(); nextSibling$iv != null && line == PsiLinesUtilsKt.getLineNumber$default(nextSibling$iv, false, 1, null); nextSibling$iv = nextSibling$iv.getNextSibling()) {
                end$iv = PsiUtilsKt.getEndOffset((PsiElement)nextSibling$iv);
            }
            List<PsiElement> list3 = CodeInsightUtils.findElementsOfClassInRange((PsiFile)file2, start$iv, end$iv, KtFunction.class);
            Intrinsics.checkNotNullExpressionValue(list3, (String)"CodeInsightUtils.findEle\u2026tart, end, T::class.java)");
            Iterator iterator = list3;
            boolean $i$f$filterIsInstance = false;
            void var10_16 = $this$filterIsInstance$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof KtFunction)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            list2 = (List)destination$iv$iv$iv;
        }
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable start$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtFunction)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof KtFunctionLiteral || it.getName() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set allLiterals = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$filter$iv = allLiterals;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object statement2;
            it = (KtFunction)element$iv$iv;
            boolean bl = false;
            Object object = it.getBodyBlockExpression();
            if (object == null || (object = object.getStatements()) == null || (object = (KtExpression)CollectionsKt.firstOrNull((List)object)) == null) {
                object = (KtExpression)it;
            }
            if (!(PsiLinesUtilsKt.getLineNumber$default((PsiElement)(statement2 = object), false, 1, null) == line && PsiLinesUtilsKt.getLineNumber((PsiElement)statement2, false) == line)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isInlineOnly(@NotNull KtCallableDeclaration $this$isInlineOnly) {
        Object v2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isInlineOnly, (String)"$this$isInlineOnly");
            if (!$this$isInlineOnly.hasModifier(KtTokens.INLINE_KEYWORD)) {
                return false;
            }
            List list2 = $this$isInlineOnly.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"annotationEntries");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                KtAnnotationEntry ktAnnotationEntry = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"it");
                if (!Intrinsics.areEqual((Object)ktAnnotationEntry.getShortName(), (Object)InlineOnlyKt.getINLINE_ONLY_ANNOTATION_FQ_NAME().shortName())) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        KtAnnotationEntry ktAnnotationEntry = v2;
        if (ktAnnotationEntry == null) {
            return false;
        }
        KtAnnotationEntry inlineOnlyAnnotation = ktAnnotationEntry;
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(inlineOnlyAnnotation){
            final /* synthetic */ KtAnnotationEntry $inlineOnlyAnnotation;

            public final boolean invoke() {
                BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)this.$inlineOnlyAnnotation, BodyResolveMode.PARTIAL);
                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)this.$inlineOnlyAnnotation);
                if (annotationDescriptor == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)annotationDescriptor, (String)"bindingContext[BindingCo\u2026tation] ?: return@f false");
                AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                return Intrinsics.areEqual((Object)annotationDescriptor2.getFqName(), (Object)InlineOnlyKt.getINLINE_ONLY_ANNOTATION_FQ_NAME());
            }
            {
                this.$inlineOnlyAnnotation = ktAnnotationEntry;
                super(0);
            }
        });
    }

    public static final /* synthetic */ PsiElement access$getTopmostParentOnLineOrSelf(PsiElement element3, Document document, int line) {
        return BreakpointTypeUtilsKt.getTopmostParentOnLineOrSelf(element3, document, line);
    }
}

