/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CompleteCoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineDescriptor;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.DefaultCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.State;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.ContinuationHolderKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.LocationCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugMetadata;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugProbesImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.JavaLangObjectToString;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfBaseContinuationImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfContinuationStack;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineInfo;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStackFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStackTraceElement;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStandaloneCoroutine;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.StandaloneCoroutine;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.DefaultExecutionContext;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/ContinuationHolder;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;)V", "getContext", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "debugMetadata", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/DebugMetadata;", "debugProbesImpl", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/DebugProbesImpl;", "javaLangObjectToString", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/JavaLangObjectToString;", "locationCache", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/LocationCache;", "createStackFrameItem", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/DefaultCoroutineStackFrameItem;", "frame", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfStackFrame;", "extractCoroutineInfoData", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CompleteCoroutineInfoData;", "continuation", "Lcom/sun/jdi/ObjectReference;", "findCoroutineInformation", "coroutineOwner", "stackFrameItems", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "state", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineDescriptor;", "value", "Companion", "kotlin.jvm-debugger.coroutines"})
public final class ContinuationHolder {
    private final DebugMetadata debugMetadata;
    private final LocationCache locationCache;
    private final DebugProbesImpl debugProbesImpl;
    private final JavaLangObjectToString javaLangObjectToString;
    @NotNull
    private final DefaultExecutionContext context;
    @NotNull
    private static final ReadOnlyProperty log$delegate;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final CompleteCoroutineInfoData extractCoroutineInfoData(@NotNull ObjectReference continuation2) {
        Intrinsics.checkNotNullParameter((Object)continuation2, (String)"continuation");
        try {
            List consumer2 = new ArrayList();
            Object object = this.debugMetadata;
            if (object == null || (object = ((DebugMetadata)object).fetchContinuationStack(continuation2, this.context)) == null) {
                return null;
            }
            Object continuationStack = object;
            for (MirrorOfStackFrame frame : ((MirrorOfContinuationStack)continuationStack).getCoroutineStack()) {
                DefaultCoroutineStackFrameItem coroutineStackFrame = this.createStackFrameItem(frame);
                if (coroutineStackFrame == null) continue;
                consumer2.add(coroutineStackFrame);
            }
            MirrorOfStackFrame lastRestoredFrame = (MirrorOfStackFrame)CollectionsKt.lastOrNull(((MirrorOfContinuationStack)continuationStack).getCoroutineStack());
            Object object2 = lastRestoredFrame;
            return this.findCoroutineInformation(object2 != null && (object2 = ((MirrorOfStackFrame)object2).getBaseContinuationImpl()) != null ? ((MirrorOfBaseContinuationImpl)object2).getCoroutineOwner() : null, consumer2);
        }
        catch (VMDisconnectedException consumer2) {
        }
        catch (Exception e) {
            Companion.getLog().warn("Error while looking for stack frame", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final CompleteCoroutineInfoData findCoroutineInformation(ObjectReference coroutineOwner, List<? extends CoroutineStackFrameItem> stackFrameItems) {
        CoroutineDescriptor coroutineDescriptor;
        List creationStackTrace2;
        block3: {
            MirrorOfCoroutineInfo ci;
            block5: {
                int n;
                int n2;
                List<MirrorOfStackTraceElement> providedCreationStackTrace;
                block6: {
                    block4: {
                        block2: {
                            creationStackTrace2 = new ArrayList();
                            Mirror mirror = coroutineOwner;
                            if (mirror == null || (mirror = mirror.type()) == null || !CoroutineUtilsKt.isAbstractCoroutine((Type)mirror)) break block2;
                            coroutineDescriptor = this.state(coroutineOwner);
                            if (coroutineDescriptor == null) {
                                return null;
                            }
                            break block3;
                        }
                        DebugProbesImpl debugProbesImpl = this.debugProbesImpl;
                        MirrorOfCoroutineInfo mirrorOfCoroutineInfo = ci = debugProbesImpl != null ? debugProbesImpl.getCoroutineInfo(coroutineOwner, this.context) : null;
                        if (ci == null) break block4;
                        providedCreationStackTrace = ci.getCreationStackTraceProvider().getStackTrace();
                        if (providedCreationStackTrace == null) break block5;
                        n2 = 0;
                        n = ((Collection)providedCreationStackTrace).size();
                        break block6;
                    }
                    coroutineDescriptor = new CoroutineDescriptor("coroutine", "-1", State.UNKNOWN, null);
                    break block3;
                }
                while (n2 < n) {
                    void index2;
                    MirrorOfStackTraceElement frame = providedCreationStackTrace.get((int)index2);
                    StackTraceElement ste = frame.stackTraceElement();
                    Location location2 = this.locationCache.createLocation(ste);
                    creationStackTrace2.add(new CreationCoroutineStackFrameItem(ste, location2, index2 == false));
                    ++index2;
                }
            }
            coroutineDescriptor = CoroutineDescriptor.Companion.instance(ci);
        }
        CoroutineDescriptor realState = coroutineDescriptor;
        return new CompleteCoroutineInfoData(realState, stackFrameItems, creationStackTrace2, null, 8, null);
    }

    @Nullable
    public final CoroutineDescriptor state(@Nullable ObjectReference value2) {
        MirrorOfStandaloneCoroutine standAloneCoroutineMirror;
        if (value2 == null) {
            return null;
        }
        StandaloneCoroutine standaloneCoroutine = StandaloneCoroutine.Companion.instance(this.context);
        if (standaloneCoroutine == null) {
            return null;
        }
        StandaloneCoroutine standaloneCoroutine2 = standaloneCoroutine;
        MirrorOfStandaloneCoroutine mirrorOfStandaloneCoroutine = standAloneCoroutineMirror = (MirrorOfStandaloneCoroutine)standaloneCoroutine2.mirror(value2, this.context);
        if ((mirrorOfStandaloneCoroutine != null ? mirrorOfStandaloneCoroutine.getContext() : null) instanceof MirrorOfCoroutineContext) {
            Long id = standAloneCoroutineMirror.getContext().getId();
            String string = standAloneCoroutineMirror.getContext().getName();
            if (string == null) {
                string = "coroutine";
            }
            String name2 = string;
            String string2 = (String)this.javaLangObjectToString.mirror(value2, this.context);
            if (string2 == null) {
                return null;
            }
            String toString = string2;
            String string3 = "\\w+\\{(\\w+)}@([\\w\\d]+)";
            Regex r = new Regex(string3);
            Matcher matcher2 = r.toPattern().matcher(toString);
            if (matcher2.matches()) {
                State state = ContinuationHolder.Companion.stateOf(matcher2.group(1));
                String hexAddress = matcher2.group(2);
                Object object = id;
                if (object == null || (object = String.valueOf((Long)object)) == null) {
                    object = hexAddress;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"id?.toString() ?: hexAddress");
                return new CoroutineDescriptor(name2, (String)object, state, standAloneCoroutineMirror.getContext().getDispatcher());
            }
        }
        return null;
    }

    private final DefaultCoroutineStackFrameItem createStackFrameItem(MirrorOfStackFrame frame) {
        Object object = frame.getBaseContinuationImpl().getStackTraceElement();
        if (object == null || (object = ((MirrorOfStackTraceElement)object).stackTraceElement()) == null) {
            return null;
        }
        Object stackTraceElement = object;
        String string = ((StackTraceElement)stackTraceElement).getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stackTraceElement.className");
        ClassType classType = this.context.findClassSafe(string);
        if (classType == null) {
            return null;
        }
        ClassType locationClass = classType;
        ReferenceType referenceType = locationClass;
        String string2 = ((StackTraceElement)stackTraceElement).getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stackTraceElement.methodName");
        Location generatedLocation = this.locationCache.createLocation(referenceType, string2, ((StackTraceElement)stackTraceElement).getLineNumber());
        List<JavaValue> spilledVariables = ContinuationHolderKt.spilledValues(frame.getBaseContinuationImpl(), this.context);
        return new DefaultCoroutineStackFrameItem(generatedLocation, spilledVariables);
    }

    @NotNull
    public final DefaultExecutionContext getContext() {
        return this.context;
    }

    private ContinuationHolder(DefaultExecutionContext context2) {
        this.context = context2;
        this.debugMetadata = DebugMetadata.Companion.instance(this.context);
        this.locationCache = new LocationCache(this.context);
        this.debugProbesImpl = DebugProbesImpl.Companion.instance(this.context);
        this.javaLangObjectToString = new JavaLangObjectToString(this.context);
    }

    static {
        Companion = new Companion(null);
        log$delegate = ProvidersKt.getLogger();
    }

    public /* synthetic */ ContinuationHolder(DefaultExecutionContext context2, DefaultConstructorMarker $constructor_marker) {
        this(context2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/ContinuationHolder$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "instance", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/ContinuationHolder;", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "stateOf", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/State;", "state", "", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
        }

        @NotNull
        public final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)Companion, $$delegatedProperties[0]);
        }

        @NotNull
        public final ContinuationHolder instance(@NotNull DefaultExecutionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return new ContinuationHolder(context2, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final State stateOf(String state) {
            State state2;
            String string = state;
            if (string != null) {
                switch (string) {
                    case "Active": {
                        state2 = State.RUNNING;
                        return state2;
                    }
                    case "Cancelling": {
                        state2 = State.SUSPENDED_CANCELLING;
                        return state2;
                    }
                    case "Completing": {
                        state2 = State.SUSPENDED_COMPLETING;
                        return state2;
                    }
                    case "Cancelled": {
                        state2 = State.CANCELLED;
                        return state2;
                    }
                    case "Completed": {
                        state2 = State.COMPLETED;
                        return state2;
                    }
                    case "New": {
                        state2 = State.NEW;
                        return state2;
                    }
                }
            }
            state2 = State.UNKNOWN;
            return state2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

