/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.framework.JSLibraryKind;
import org.jetbrains.kotlin.idea.framework.LibraryEffectiveKindProviderKt;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0005R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/framework/JsLibraryStdDetectionUtil;", "", "()V", "IS_JS_LIBRARY_STD_LIB", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getJsLibraryStdVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "project", "Lcom/intellij/openapi/project/Project;", "getJsStdLibJar", "Lcom/intellij/openapi/vfs/VirtualFile;", "classesRoots", "", "hasJsStdlibJar", "ignoreKind", "kotlin.core"})
public final class JsLibraryStdDetectionUtil {
    private static final Key<Boolean> IS_JS_LIBRARY_STD_LIB;
    @NotNull
    public static final JsLibraryStdDetectionUtil INSTANCE;

    public final boolean hasJsStdlibJar(@NotNull Library library2, @NotNull Project project2, boolean ignoreKind) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!(library2 instanceof LibraryEx) || ((LibraryEx)library2).isDisposed()) {
            return false;
        }
        if (!ignoreKind && !(LibraryEffectiveKindProviderKt.effectiveKind((LibraryEx)library2, project2) instanceof JSLibraryKind)) {
            return false;
        }
        VirtualFile[] virtualFileArray = library2.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        List classes2 = CollectionsKt.listOf((Object[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        return this.getJsStdLibJar(classes2) != null;
    }

    public static /* synthetic */ boolean hasJsStdlibJar$default(JsLibraryStdDetectionUtil jsLibraryStdDetectionUtil, Library library2, Project project2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jsLibraryStdDetectionUtil.hasJsStdlibJar(library2, project2, bl);
    }

    @Nullable
    public final IdeKotlinVersion getJsLibraryStdVersion(@NotNull Library library2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!(LibraryEffectiveKindProviderKt.effectiveKind((LibraryEx)library2, project2) instanceof JSLibraryKind)) {
            return null;
        }
        Object[] objectArray = library2.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        VirtualFile virtualFile2 = this.getJsStdLibJar(ArraysKt.toList((Object[])objectArray));
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile jar = virtualFile2;
        return IdeKotlinVersion.Companion.fromManifest(jar);
    }

    @Nullable
    public final VirtualFile getJsStdLibJar(@NotNull List<? extends VirtualFile> classesRoots) {
        Intrinsics.checkNotNullParameter(classesRoots, (String)"classesRoots");
        for (VirtualFile virtualFile2 : classesRoots) {
            VirtualFile jar;
            VirtualFileSystem virtualFileSystem = virtualFile2.getFileSystem();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"root.fileSystem");
            if (virtualFileSystem.getProtocol() != "jar") continue;
            String string = virtualFile2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"root.url");
            String name2 = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)string, (String)"!/", null, (int)2, null), (char)'/', null, (int)2, null);
            if (!Intrinsics.areEqual((Object)name2, (Object)"kotlin-stdlib-js.jar") && !Intrinsics.areEqual((Object)name2, (Object)"kotlin-jslib.jar") && !PathUtil.INSTANCE.getKOTLIN_STDLIB_JS_JAR_PATTERN().matcher(name2).matches() && !PathUtil.INSTANCE.getKOTLIN_JS_LIBRARY_JAR_PATTERN().matcher(name2).matches()) continue;
            if (VfsUtilCore.getVirtualFileForJar((VirtualFile)virtualFile2) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)jar, (String)"VfsUtilCore.getVirtualFileForJar(root) ?: continue");
            Boolean isJSStdLib = (Boolean)jar.getUserData(IS_JS_LIBRARY_STD_LIB);
            if (isJSStdLib == null) {
                isJSStdLib = LibraryUtils.isKotlinJavascriptStdLibrary((File)new File(jar.getPath()));
                jar.putUserData(IS_JS_LIBRARY_STD_LIB, (Object)isJSStdLib);
            }
            if (!isJSStdLib.booleanValue()) continue;
            return jar;
        }
        return null;
    }

    private JsLibraryStdDetectionUtil() {
    }

    static {
        JsLibraryStdDetectionUtil jsLibraryStdDetectionUtil;
        INSTANCE = jsLibraryStdDetectionUtil = new JsLibraryStdDetectionUtil();
        Key key = Key.create((String)"IS_JS_LIBRARY_STD_LIB");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Boolean>(\"IS_JS_LIBRARY_STD_LIB\")");
        IS_JS_LIBRARY_STD_LIB = key;
    }
}

