/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration.kpm;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.kpm.idea.IdeaKpmFragment;
import org.jetbrains.kotlin.gradle.kpm.idea.IdeaKpmFragmentKt;
import org.jetbrains.kotlin.gradle.kpm.idea.IdeaKpmModule;
import org.jetbrains.kotlin.gradle.kpm.idea.IdeaKpmProject;
import org.jetbrains.kotlin.idea.gradle.configuration.kpm.ModuleDataInitializer;
import org.jetbrains.kotlin.idea.gradleJava.configuration.kpm.KotlinFragmentUtilKt;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

@Order(value=1001)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J<\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/kpm/KotlinGradleSourceSetDataInitializer;", "Lorg/jetbrains/kotlin/idea/gradle/configuration/kpm/ModuleDataInitializer;", "()V", "createExternalSourceSet", "Lorg/jetbrains/plugins/gradle/model/ExternalSourceSet;", "fragment", "Lorg/jetbrains/kotlin/gradle/kpm/idea/IdeaKpmFragment;", "gradleSourceSetData", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "initialize", "", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "mainModuleNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "projectDataNode", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "resolverCtx", "Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;", "initializerContext", "Lorg/jetbrains/kotlin/idea/gradle/configuration/kpm/ModuleDataInitializer$Context;", "Companion", "kotlin.gradle.gradle-java"})
public final class KotlinGradleSourceSetDataInitializer
implements ModuleDataInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> mainModuleNode, @NotNull DataNode<ProjectData> projectDataNode, @NotNull ProjectResolverContext resolverCtx, @NotNull ModuleDataInitializer.Context initializerContext) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkNotNullParameter(mainModuleNode, (String)"mainModuleNode");
        Intrinsics.checkNotNullParameter(projectDataNode, (String)"projectDataNode");
        Intrinsics.checkNotNullParameter((Object)resolverCtx, (String)"resolverCtx");
        Intrinsics.checkNotNullParameter((Object)initializerContext, (String)"initializerContext");
        Object object = projectDataNode.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"projectDataNode.getUserD\u2026r.RESOLVED_SOURCE_SETS)!!");
        Map sourceSetMap = (Map)object2;
        Object object3 = resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        Intrinsics.checkNotNull((Object)object3);
        Object object4 = object3;
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"resolverCtx.getExtraProj\u2026nalProject::class.java)!!");
        ExternalProject externalProject = (ExternalProject)object4;
        IdeaKpmProject ideaKpmProject = initializerContext.getModel();
        if (ideaKpmProject == null) {
            map2 = null;
        } else {
            List<IdeaKpmModule> list2 = ideaKpmProject.getModules();
            if (list2 == null) {
                map2 = null;
            } else {
                Iterable $this$associateWith$iv = list2;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    void it;
                    IdeaKpmModule ideaKpmModule = (IdeaKpmModule)element$iv$iv;
                    Object t = element$iv$iv;
                    Map map3 = result$iv;
                    boolean bl = false;
                    List<IdeaKpmFragment> list3 = it.getFragments();
                    map3.put(t, list3);
                }
                map2 = result$iv;
            }
        }
        if (map2 == null) {
            return;
        }
        Map fragmentsByModules = map2;
        for (Map.Entry entry : fragmentsByModules.entrySet()) {
            IdeaKpmModule module2 = (IdeaKpmModule)entry.getKey();
            List fragments = (List)entry.getValue();
            for (IdeaKpmFragment fragment : fragments) {
                GradleSourceSetData fragmentData;
                GradleSourceSetData gradleSourceSetData;
                GradleSourceSetData gradleSourceSetData2;
                Object object5;
                String fragmentModuleId = KotlinFragmentUtilKt.calculateKotlinFragmentModuleId(gradleModule, fragment.getCoordinates(), resolverCtx);
                com.intellij.openapi.util.Pair pair = (com.intellij.openapi.util.Pair)sourceSetMap.get(fragmentModuleId);
                DataNode existingSourceSetDataNode = pair == null ? null : (DataNode)pair.first;
                String moduleExternalName = KotlinGradleSourceSetDataInitializer.Companion.calculateFragmentExternalModuleName(gradleModule, fragment);
                String moduleInternalName = KotlinGradleSourceSetDataInitializer.Companion.calculateFragmentInternalModuleName(gradleModule, externalProject, fragment, resolverCtx);
                DataNode dataNode = existingSourceSetDataNode;
                Object object6 = object5 = dataNode == null ? null : (GradleSourceSetData)dataNode.getData();
                if (object5 == null) {
                    String string;
                    String string2 = initializerContext.getMainModuleFileDirectoryPath();
                    if (string2 == null) {
                        string2 = "";
                    }
                    if ((string = initializerContext.getMainModuleConfigPath()) == null) {
                        string = "";
                    }
                    GradleSourceSetData it = gradleSourceSetData2 = new GradleSourceSetData(fragmentModuleId, moduleExternalName, moduleInternalName, string2, string);
                    boolean bl = false;
                    it.setGroup(externalProject.getGroup());
                    it.setVersion(externalProject.getVersion());
                    String string3 = module2.getCoordinates().getModuleName();
                    if (Intrinsics.areEqual((Object)string3, (Object)"main")) {
                        it.setPublication((ProjectCoordinate)new ProjectId(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion()));
                    } else if (Intrinsics.areEqual((Object)string3, (Object)"test")) {
                        it.setProductionModuleId(moduleInternalName);
                    }
                    it.setIdeModuleGroup(initializerContext.getModuleGroup());
                    it.setSdkName(initializerContext.getJdkName());
                    gradleSourceSetData = gradleSourceSetData2;
                } else {
                    gradleSourceSetData = fragmentData = object5;
                }
                if (existingSourceSetDataNode != null) continue;
                object5 = mainModuleNode.createChild(GradleSourceSetData.KEY, (Object)fragmentData);
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"mainModuleNode.createChi\u2026etData.KEY, fragmentData)");
                GradleSourceSetData fragmentDataNode = object5;
                object5 = sourceSetMap;
                gradleSourceSetData2 = new com.intellij.openapi.util.Pair((Object)fragmentDataNode, (Object)this.createExternalSourceSet(fragment, fragmentData));
                object5.put(fragmentModuleId, gradleSourceSetData2);
            }
        }
    }

    private final ExternalSourceSet createExternalSourceSet(IdeaKpmFragment fragment, GradleSourceSetData gradleSourceSetData) {
        DefaultExternalSourceDirectorySet dirSet;
        DefaultExternalSourceDirectorySet defaultExternalSourceDirectorySet;
        DefaultExternalSourceSet defaultExternalSourceSet;
        DefaultExternalSourceSet sourceSet = defaultExternalSourceSet = new DefaultExternalSourceSet();
        boolean bl = false;
        sourceSet.setName(IdeaKpmFragmentKt.getName(fragment));
        sourceSet.setTargetCompatibility(gradleSourceSetData.getTargetCompatibility());
        Pair[] pairArray = sourceSet.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"sourceSet.dependencies");
        CollectionsKt.addAll((Collection)pairArray, (Iterable)CollectionsKt.emptyList());
        pairArray = new Pair[2];
        DefaultExternalSourceDirectorySet defaultExternalSourceDirectorySet2 = defaultExternalSourceDirectorySet = new DefaultExternalSourceDirectorySet();
        ExternalSystemSourceType externalSystemSourceType = KotlinFragmentUtilKt.computeSourceType(fragment);
        int n = 0;
        Pair[] pairArray2 = pairArray;
        DefaultExternalSourceSet defaultExternalSourceSet2 = sourceSet;
        boolean bl2 = false;
        dirSet.setSrcDirs(CollectionsKt.toSet((Iterable)KotlinFragmentUtilKt.getSourceDirs(fragment)));
        Unit unit = Unit.INSTANCE;
        pairArray2[n] = TuplesKt.to((Object)externalSystemSourceType, (Object)defaultExternalSourceDirectorySet);
        dirSet = defaultExternalSourceDirectorySet = new DefaultExternalSourceDirectorySet();
        externalSystemSourceType = KotlinFragmentUtilKt.computeResourceType(fragment);
        n = 1;
        pairArray2 = pairArray;
        boolean bl3 = false;
        dirSet.setSrcDirs(CollectionsKt.toSet((Iterable)KotlinFragmentUtilKt.getResourceDirs(fragment)));
        unit = Unit.INSTANCE;
        pairArray2[n] = TuplesKt.to((Object)externalSystemSourceType, (Object)defaultExternalSourceDirectorySet);
        defaultExternalSourceSet2.setSources(MapsKt.toMap((Map)MapsKt.linkedMapOf((Pair[])pairArray)));
        return (ExternalSourceSet)defaultExternalSourceSet;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/kpm/KotlinGradleSourceSetDataInitializer$Companion;", "", "()V", "calculateFragmentExternalModuleName", "", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "fragment", "Lorg/jetbrains/kotlin/gradle/kpm/idea/IdeaKpmFragment;", "calculateFragmentInternalModuleName", "externalProject", "Lorg/jetbrains/plugins/gradle/model/ExternalProject;", "resolverCtx", "Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;", "gradlePathToQualifiedName", "rootName", "gradlePath", "kotlin.gradle.gradle-java"})
    public static final class Companion {
        private Companion() {
        }

        private final String calculateFragmentExternalModuleName(IdeaModule gradleModule, IdeaKpmFragment fragment) {
            return gradleModule.getName() + ":" + fragment.getCoordinates().getModule().getModuleName() + "." + IdeaKpmFragmentKt.getName(fragment);
        }

        private final String calculateFragmentInternalModuleName(IdeaModule gradleModule, ExternalProject externalProject, IdeaKpmFragment fragment, ProjectResolverContext resolverCtx) {
            String string;
            String delimiter = null;
            StringBuilder moduleName2 = new StringBuilder();
            String buildSrcGroup = resolverCtx.getBuildSrcGroup();
            if (resolverCtx.isUseQualifiedModuleNames()) {
                delimiter = ".";
                if (StringUtil.isNotEmpty((String)buildSrcGroup)) {
                    moduleName2.append(buildSrcGroup).append(delimiter);
                }
                string = gradleModule.getProject().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gradleModule.project.name");
                String string2 = string;
                string = externalProject.getQName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"externalProject.qName");
                moduleName2.append(this.gradlePathToQualifiedName(string2, string));
            } else {
                delimiter = "_";
                if (StringUtil.isNotEmpty((String)buildSrcGroup)) {
                    moduleName2.append(buildSrcGroup).append(delimiter);
                }
                moduleName2.append(gradleModule.getName());
            }
            moduleName2.append(delimiter);
            moduleName2.append(fragment.getCoordinates().getModule().getModuleName() + "." + IdeaKpmFragmentKt.getName(fragment));
            string = PathUtilRt.suggestFileName((String)moduleName2.toString(), (boolean)true, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"suggestFileName(moduleNa\u2026.toString(), true, false)");
            return string;
        }

        private final String gradlePathToQualifiedName(String rootName, String gradlePath) {
            Object object = StringsKt.startsWith$default((String)gradlePath, (String)":", (boolean)false, (int)2, null) ? rootName + "." : "";
            CharSequence charSequence = gradlePath;
            Regex regex = new Regex(":");
            int n = 0;
            Collection $this$toTypedArray$iv = regex.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            return (String)object + Arrays.stream(stringArray).filter(Companion::gradlePathToQualifiedName$lambda-0).collect(Collectors.joining("."));
        }

        private static final boolean gradlePathToQualifiedName$lambda-0(String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return ((CharSequence)s).length() > 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

